/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.excel;

import fr.amapj.common.DateUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.engine.generator.excel.AbstractExcelGenerator;
import fr.amapj.service.engine.generator.excel.ExcelFormat;
import fr.amapj.service.engine.generator.excel.ExcelGeneratorTool;
import fr.amapj.service.services.gestioncontratsigne.GestionContratSigneService;
import java.text.SimpleDateFormat;
import java.util.List;

public class EGUtilisateurContrat
extends AbstractExcelGenerator {
    Long idModeleContrat;

    public EGUtilisateurContrat(Long idModeleContrat) {
        this.idModeleContrat = idModeleContrat;
    }

    @Override
    public void fillExcelFile(RdbLink em, ExcelGeneratorTool et) {
        et.addSheet("Liste des souscripteurs", 8, 20);
        et.setColumnWidth(2, 40);
        et.setColumnWidth(5, 40);
        et.setColumnWidth(7, 40);
        ModeleContrat mc = em.find(ModeleContrat.class, this.idModeleContrat);
        List<Utilisateur> utilisateurs = new GestionContratSigneService().getAllUtilisateur(this.idModeleContrat);
        this.contructEntete(et, mc);
        int i = 0;
        while (i < utilisateurs.size()) {
            Utilisateur utilisateur = utilisateurs.get(i);
            this.contructRow(et, utilisateur);
            ++i;
        }
    }

    private void contructEntete(ExcelGeneratorTool et, ModeleContrat mc) {
        SimpleDateFormat df1 = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        et.addRow("Liste des souscripteurs du contrat " + mc.nom, et.grasGaucheNonWrappe);
        et.addRow("Extrait le " + df1.format(DateUtils.getDate()), et.grasGaucheNonWrappe);
        et.addRow();
        et.addRow();
        et.setCell(0, "Nom", et.grasGaucheNonWrappeBordure);
        et.setCell(1, "Pr\u00e9nom", et.grasGaucheNonWrappeBordure);
        et.setCell(2, "E mail", et.grasGaucheNonWrappeBordure);
        et.setCell(3, "Tel1", et.grasGaucheNonWrappeBordure);
        et.setCell(4, "Tel2", et.grasGaucheNonWrappeBordure);
        et.setCell(5, "Adr", et.grasGaucheNonWrappeBordure);
        et.setCell(6, "Code Postal", et.grasGaucheNonWrappeBordure);
        et.setCell(7, "Ville", et.grasGaucheNonWrappeBordure);
    }

    private void contructRow(ExcelGeneratorTool et, Utilisateur u) {
        et.addRow();
        et.setCell(0, u.nom, et.grasGaucheNonWrappeBordure);
        et.setCell(1, u.prenom, et.nonGrasGaucheBordure);
        et.setCell(2, u.email, et.nonGrasGaucheBordure);
        et.setCell(3, u.numTel1, et.nonGrasGaucheBordure);
        et.setCell(4, u.numTel2, et.nonGrasGaucheBordure);
        et.setCell(5, u.libAdr1, et.nonGrasGaucheBordure);
        et.setCell(6, u.codePostal, et.nonGrasGaucheBordure);
        et.setCell(7, u.ville, et.nonGrasGaucheBordure);
    }

    @Override
    public String getFileName(RdbLink em) {
        ModeleContrat mc = em.find(ModeleContrat.class, this.idModeleContrat);
        return "liste-souscripteurs-" + mc.nom;
    }

    @Override
    public String getNameToDisplay(RdbLink em) {
        return "la liste des souscripteurs de ce contrat, avec leur e-mail et t\u00e9l\u00e9phone";
    }

    @Override
    public ExcelFormat getFormat() {
        return ExcelFormat.XLS;
    }
}

