/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.excel.cheque;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.DateUtils;
import fr.amapj.common.FormatUtils;
import fr.amapj.common.collections.G1D;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.reel.Contrat;
import fr.amapj.model.models.contrat.reel.EtatPaiement;
import fr.amapj.model.models.contrat.reel.Paiement;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.engine.generator.excel.AbstractExcelGenerator;
import fr.amapj.service.engine.generator.excel.ExcelFormat;
import fr.amapj.service.engine.generator.excel.ExcelGeneratorTool;
import fr.amapj.service.services.parametres.ParametresDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.view.engine.widgets.CurrencyTextFieldConverter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import javax.persistence.TypedQuery;

public class EGSyntheseCheque
extends AbstractExcelGenerator {
    private Long idUtilisateur;
    private Mode mode;

    public EGSyntheseCheque(Mode mode, Long idUtilisateur) {
        this.mode = mode;
        this.idUtilisateur = idUtilisateur;
    }

    @Override
    public void fillExcelFile(RdbLink em, ExcelGeneratorTool et) {
        List<Utilisateur> utilisateurs = this.getUtilisateurs(em, this.idUtilisateur);
        for (Utilisateur utilisateur : utilisateurs) {
            String pageName = String.valueOf(utilisateur.nom) + " " + utilisateur.prenom;
            this.addOneSheet(em, utilisateur, et, pageName, true);
        }
        if (utilisateurs.size() == 0) {
            et.addSheet("AMAP", 1, 50);
            et.addRow("Il y a aucun ch\u00e8que pour aucun utilisateur !!", et.grasGaucheWrappe);
        }
    }

    public void addOneSheet(RdbLink em, Utilisateur u, ExcelGeneratorTool et, String pageName, boolean orderByName) {
        SimpleDateFormat df1 = FormatUtils.getStdDate();
        SimpleDateFormat df2 = FormatUtils.getTimeStd();
        String nomUtilisateur = String.valueOf(u.nom) + " " + u.prenom;
        et.addSheet(pageName, 1, 100);
        ParametresDTO param = new ParametresService().getParametres();
        et.addRow(param.nomAmap, et.grasCentre);
        et.addRow();
        et.addRow(this.getTitre(nomUtilisateur), et.grasGaucheNonWrappe);
        et.addRow("Extrait le " + df2.format(DateUtils.getDate()), et.grasGaucheNonWrappe);
        et.addRow();
        List<Paiement> cells = this.getCheque(em, u);
        G1D<Contrat, Paiement> c1 = new G1D<Contrat, Paiement>();
        c1.fill(cells);
        c1.groupBy(e -> e.contrat);
        if (orderByName) {
            c1.sortLig(e -> e.modeleContrat.nom, true);
        } else {
            c1.sortLig(e -> e.dateCreation, true);
        }
        c1.sortCell(e -> e.modeleContratDatePaiement.datePaiement, true);
        c1.compute();
        List modeleContrats = c1.getFullCells();
        for (G1D.Cell1 cell1 : modeleContrats) {
            this.drawBlocDate(em, et, (Contrat)cell1.lig, cell1.values, df1);
        }
    }

    private void drawBlocDate(RdbLink em, ExcelGeneratorTool et, Contrat c, List<Paiement> paiements, SimpleDateFormat df1) {
        ModeleContrat mc = c.modeleContrat;
        et.addRow(String.valueOf(mc.nom) + " - " + mc.producteur.nom, et.grasGaucheNonWrappeBordureGray);
        et.addRow();
        for (Paiement paiement : paiements) {
            String mnt = String.valueOf(new CurrencyTextFieldConverter().convertToString(paiement.montant)) + " \u20ac";
            String lib = "1 ch\u00e8que de " + mnt + " qui sera d\u00e9bit\u00e9 le " + df1.format(paiement.modeleContratDatePaiement.datePaiement) + "  - Etat du ch\u00e8que =" + this.getEtat(paiement.etat);
            et.addRow(lib, et.nonGrasGaucheNonWrappe);
        }
        et.addRow();
    }

    private String getTitre(String nomUtilisateur) {
        switch (this.mode) {
            case CHEQUE_A_REMETTRE: {
                return "Liste des ch\u00e8ques \u00e0 remettre \u00e0 l'AMAP par " + nomUtilisateur;
            }
            case CHEQUE_AMAP: {
                return "Liste des ch\u00e8ques fournis \u00e0 l'AMAP par " + nomUtilisateur + " et non remis aux producteurs";
            }
            case CHEQUE_REMIS_PRODUCTEUR: {
                return "Liste des ch\u00e8ques fournis \u00e0 l'AMAP par " + nomUtilisateur + " et remis aux producteurs";
            }
            case TOUS: {
                return "Liste de tous les ch\u00e8ques de " + nomUtilisateur + " (quelque soit leur \u00e9tat)";
            }
        }
        throw new AmapjRuntimeException();
    }

    private String getEtat(EtatPaiement etat) {
        switch (etat) {
            case A_FOURNIR: {
                return "Ch\u00e8que \u00e0 fournir \u00e0 l'AMAP";
            }
            case AMAP: {
                return "Ch\u00e8que \u00e0 l'AMAP";
            }
            case PRODUCTEUR: {
                return "Ch\u00e8que remis au producteur";
            }
        }
        throw new AmapjRuntimeException();
    }

    private List<Paiement> getCheque(RdbLink em, Utilisateur u) {
        String query = "select p from Paiement p WHERE ";
        if (this.mode != Mode.TOUS) {
            query = String.valueOf(query) + " p.etat = :etat  AND ";
        }
        query = String.valueOf(query) + " p.contrat.utilisateur=:u";
        TypedQuery<Paiement> q = em.createQuery(query, Paiement.class);
        if (this.mode != Mode.TOUS) {
            q.setParameter("etat", (Object)this.computeEtatPaiement());
        }
        q.setParameter("u", (Object)u);
        return q.getResultList();
    }

    private EtatPaiement computeEtatPaiement() {
        switch (this.mode) {
            case CHEQUE_A_REMETTRE: {
                return EtatPaiement.A_FOURNIR;
            }
            case CHEQUE_AMAP: {
                return EtatPaiement.AMAP;
            }
            case CHEQUE_REMIS_PRODUCTEUR: {
                return EtatPaiement.PRODUCTEUR;
            }
        }
        throw new AmapjRuntimeException();
    }

    public List<Utilisateur> getUtilisateurs(RdbLink em, Long idUtilisateur) {
        if (idUtilisateur != null) {
            return Arrays.asList(em.find(Utilisateur.class, idUtilisateur));
        }
        String query = "select distinct(p.contrat.utilisateur) from Paiement p ";
        if (this.mode != Mode.TOUS) {
            query = String.valueOf(query) + " WHERE p.etat = :etat ";
        }
        query = String.valueOf(query) + " ORDER BY p.contrat.utilisateur.nom , p.contrat.utilisateur.prenom";
        TypedQuery<Utilisateur> q = em.createQuery(query, Utilisateur.class);
        if (this.mode != Mode.TOUS) {
            q.setParameter("etat", (Object)this.computeEtatPaiement());
        }
        return q.getResultList();
    }

    @Override
    public String getFileName(RdbLink em) {
        String etat;
        String nomUtilisateur = "tous les amapiens";
        if (this.idUtilisateur != null) {
            Utilisateur u = em.find(Utilisateur.class, this.idUtilisateur);
            nomUtilisateur = String.valueOf(u.nom) + " " + u.prenom;
        }
        switch (this.mode) {
            case CHEQUE_A_REMETTRE: {
                etat = "promis";
                break;
            }
            case CHEQUE_AMAP: {
                etat = "recus";
                break;
            }
            case CHEQUE_REMIS_PRODUCTEUR: {
                etat = "remis";
                break;
            }
            case TOUS: {
                etat = "promis-recus-remis";
                break;
            }
            default: {
                throw new AmapjRuntimeException();
            }
        }
        return "synthese-cheque-" + etat + "-" + nomUtilisateur;
    }

    @Override
    public String getNameToDisplay(RdbLink em) {
        String nomUtilisateur = "tous les amapiens";
        if (this.idUtilisateur != null) {
            Utilisateur u = em.find(Utilisateur.class, this.idUtilisateur);
            nomUtilisateur = String.valueOf(u.nom) + " " + u.prenom;
        }
        return this.getTitre(nomUtilisateur);
    }

    @Override
    public ExcelFormat getFormat() {
        return ExcelFormat.XLS;
    }

    public static enum Mode {
        CHEQUE_A_REMETTRE,
        CHEQUE_AMAP,
        CHEQUE_REMIS_PRODUCTEUR,
        TOUS;

    }
}

