/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.excel.emargement;

import fr.amapj.common.DateUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.editionspe.EditionSpecifique;
import fr.amapj.model.models.editionspe.emargement.FeuilleEmargementJson;
import fr.amapj.model.models.editionspe.emargement.FormatFeuilleEmargement;
import fr.amapj.model.models.editionspe.emargement.TypFeuilleEmargement;
import fr.amapj.service.engine.generator.excel.AbstractExcelGenerator;
import fr.amapj.service.engine.generator.excel.ExcelFormat;
import fr.amapj.service.engine.generator.excel.ExcelGeneratorTool;
import fr.amapj.service.services.edgenerator.excel.emargement.EGFeuilleEmargementGrille;
import fr.amapj.service.services.edgenerator.excel.emargement.EGFeuilleEmargementListe;
import fr.amapj.service.services.editionspe.EditionSpeService;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class EGFeuilleEmargement
extends AbstractExcelGenerator {
    private Long editionSpecifiqueId;
    private Date ref;
    private String suffix;

    public EGFeuilleEmargement(Long editionSpecifiqueId, Date ref, String suffix) {
        this.suffix = suffix;
        this.editionSpecifiqueId = editionSpecifiqueId;
        this.ref = ref;
    }

    @Override
    public void fillExcelFile(RdbLink em, ExcelGeneratorTool et) {
        EditionSpecifique editionSpe = em.find(EditionSpecifique.class, this.editionSpecifiqueId);
        FeuilleEmargementJson planningJson = (FeuilleEmargementJson)new EditionSpeService().load(editionSpe.id);
        LibInfo libInfo = this.getLibForName(em);
        if (planningJson.getFormat() == FormatFeuilleEmargement.GRILLE) {
            new EGFeuilleEmargementGrille().fillExcelFile(em, et, planningJson, libInfo);
        } else {
            new EGFeuilleEmargementListe().fillExcelFile(em, et, planningJson, libInfo);
        }
    }

    @Override
    public String getFileName(RdbLink em) {
        LibInfo libInfo = this.getLibForName(em);
        return String.valueOf(libInfo.fileName) + this.suffix;
    }

    @Override
    public String getNameToDisplay(RdbLink em) {
        LibInfo libInfo = this.getLibForName(em);
        String str = libInfo.displayName;
        if (this.suffix != null && this.suffix.length() > 0) {
            str = String.valueOf(str) + " (" + this.suffix + ")";
        }
        return str;
    }

    public LibInfo getLibForName(RdbLink em) {
        LibInfo res = new LibInfo();
        SimpleDateFormat df2 = new SimpleDateFormat("MMMMM yyyy");
        SimpleDateFormat df3 = new SimpleDateFormat("ww");
        SimpleDateFormat df4 = new SimpleDateFormat("MMMMM-yyyy");
        SimpleDateFormat df5 = new SimpleDateFormat("dd-MMMMM");
        EditionSpecifique editionSpe = em.find(EditionSpecifique.class, this.editionSpecifiqueId);
        FeuilleEmargementJson planningJson = (FeuilleEmargementJson)new EditionSpeService().load(editionSpe.id);
        if (planningJson.getTypPlanning() == TypFeuilleEmargement.MENSUEL) {
            res.debut = DateUtils.firstDayInMonth(this.ref);
            res.fin = DateUtils.addMonth(res.debut, 1);
            res.lib1 = df2.format(res.debut);
            res.lib2 = "mensuelle";
            res.fileName = "emargement-mensuel-" + df4.format(res.debut);
            res.displayName = "la feuille d'\u00e9margement mensuelle de " + df2.format(res.debut);
        } else {
            res.debut = DateUtils.firstMonday(this.ref);
            res.fin = DateUtils.addDays(res.debut, 7);
            res.lib1 = "S" + df3.format(res.debut);
            res.lib2 = "hebdomadaire";
            res.fileName = "emargement-hebdomadaire-" + df5.format(res.debut);
            res.displayName = "la feuille d'\u00e9margement hebdomadaire semaine " + df3.format(res.debut);
        }
        return res;
    }

    @Override
    public ExcelFormat getFormat() {
        return ExcelFormat.XLS;
    }

    public static void main(String[] args) throws IOException {
        Date d = DateUtils.addMonth(DateUtils.getDate(), 1);
        new EGFeuilleEmargement(10301L, d, "").test();
    }

    public static class LibInfo {
        public String lib1;
        public String lib2;
        public String fileName;
        public String displayName;
        public Date debut;
        public Date fin;
    }
}

