/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.excel.emargement;

import fr.amapj.common.CollectionUtils;
import fr.amapj.common.StringUtils;
import fr.amapj.common.collections.G1D;
import fr.amapj.common.collections.G2D;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.reel.ContratCell;
import fr.amapj.model.models.editionspe.emargement.FeuilleEmargementJson;
import fr.amapj.model.models.fichierbase.Producteur;
import fr.amapj.model.models.fichierbase.ProducteurUtilisateur;
import fr.amapj.model.models.fichierbase.Produit;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.model.models.param.ChoixOuiNon;
import fr.amapj.service.engine.generator.excel.ExcelCellAutoSize;
import fr.amapj.service.engine.generator.excel.ExcelGeneratorTool;
import fr.amapj.service.services.edgenerator.excel.emargement.EGFeuilleEmargement;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDateDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceService;
import fr.amapj.service.services.producteur.ProducteurService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.persistence.Query;
import org.apache.poi.ss.usermodel.Row;

public class EGFeuilleEmargementListe {
    private static final char BULLET_CHARACTER = '\u2022';

    /*
     * WARNING - void declaration
     */
    public void fillExcelFile(RdbLink em, ExcelGeneratorTool et, FeuilleEmargementJson planningJson, EGFeuilleEmargement.LibInfo libInfo) {
        void var13_20;
        SimpleDateFormat df = new SimpleDateFormat("dd MMMMM");
        List<ContratCell> cells = this.getContratCell(em, libInfo, planningJson);
        G2D<Utilisateur, Date, ContratCell> c1 = new G2D<Utilisateur, Date, ContratCell>();
        c1.fill(cells);
        c1.groupByLig(e -> e.contrat.utilisateur);
        c1.groupByCol(e -> e.modeleContratDate.dateLiv);
        c1.sortLig(e -> e.nom, true);
        c1.sortLig(e -> e.prenom, true);
        c1.sortCol(e -> e, true);
        c1.compute();
        List utilisateurs = c1.getLigs();
        List<Date> dateLivs = c1.getCols();
        Entete entete = this.getEntetePlanning(dateLivs, em, libInfo);
        int nbCol = entete.dateCols.size() * 2 + 5;
        et.addSheet("Feuille \u00e9margement " + libInfo.lib2 + " " + libInfo.lib1, nbCol, 25);
        et.setMarginAndPageFormat(planningJson);
        et.setColumnWidthInMm(0, planningJson.getLgColNom());
        et.setColumnWidthInMm(1, planningJson.getLgColPrenom());
        int index = 2;
        Iterator<DateColonne> iterator = entete.dateCols.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            et.setColumnWidthInMm(index, planningJson.getLgColProduits());
            et.setColumnWidthInMm(++index, planningJson.getLgColPresence());
            ++index;
        }
        et.setColumnWidthInMm(index, planningJson.getLgColnumTel1());
        et.setColumnWidthInMm(++index, planningJson.getLgColnumTel2());
        et.setColumnWidthInMm(++index, planningJson.getLgColCommentaire());
        et.addRow();
        et.setCell(0, "DISTRIBUTIONS " + libInfo.lib1.toUpperCase(), et.grasCentreBordure);
        et.mergeCellsRight(0, 2);
        index = 2;
        for (DateColonne dateColonne : entete.dateCols) {
            et.setCell(index, df.format(dateColonne.date), et.grasCentreBordure);
            et.mergeCellsRight(index, 2);
            index += 2;
        }
        et.setNCell(index, 3, "", et.grasCentreBordure);
        et.addRow();
        et.setRowHeigth(3);
        et.setCell(0, "Responsable de distribution", et.nonGrasGaucheBordure);
        et.mergeCellsRight(0, 2);
        index = 2;
        for (DateColonne dateColonne : entete.dateCols) {
            et.setCell(index, dateColonne.permanence, et.nonGrasCentreBordure);
            et.mergeCellsRight(index, 2);
            index += 2;
        }
        et.setNCell(index, 3, "", et.grasCentreBordure);
        et.addRow();
        if (planningJson.getListeAffichageCumulProducteur() == ChoixOuiNon.OUI) {
            this.addCumulParProducteur(cells, et, planningJson, entete, em);
        }
        et.addRow();
        et.setCell(0, "Nom", et.grasCentreBordure);
        et.setCell(1, "Pr\u00e9nom", et.grasCentreBordure);
        index = 2;
        Iterator<DateColonne> iterator2 = entete.dateCols.iterator();
        while (iterator2.hasNext()) {
            iterator2.next();
            et.setCell(index, "Produits", et.grasCentreBordure);
            et.setCell(++index, "Pr\u00e9sence", et.grasCentreBordureColorPetit);
            ++index;
        }
        et.setCell(index, "T\u00e9l\u00e9phone 1 ", et.grasCentreBordure);
        et.setCell(++index, "T\u00e9l\u00e9phone 2 ", et.grasCentreBordure);
        et.setCell(++index, "Commentaire ", et.grasCentreBordure);
        boolean bl = false;
        while (var13_20 < utilisateurs.size()) {
            Utilisateur utilisateur = (Utilisateur)utilisateurs.get((int)var13_20);
            List<List<ContratCell>> ligne = c1.getLine((int)var13_20);
            this.addRowUtilisateur(et, utilisateur, ligne, entete, (int)var13_20, planningJson);
            ++var13_20;
        }
    }

    private void addRowUtilisateur(ExcelGeneratorTool et, Utilisateur utilisateur, List<List<ContratCell>> ligne, Entete entete, int numLigne, FeuilleEmargementJson feuilleEmargementJson) {
        ExcelCellAutoSize as = new ExcelCellAutoSize(5);
        Row currentRow = et.addRow();
        et.setCell(0, utilisateur.nom, et.switchGray(et.grasGaucheWrappeBordure, numLigne));
        et.setCell(1, utilisateur.prenom, et.switchGray(et.nonGrasGaucheBordure, numLigne));
        int index = 2;
        List<DateColonne> dateCols = entete.dateCols;
        int i = 0;
        while (i < dateCols.size()) {
            DateColonne prodCol = dateCols.get(i);
            List<ContratCell> userCells = ligne.get(i);
            String listeProduits = this.getListeProduit(prodCol, utilisateur, userCells, feuilleEmargementJson);
            et.setCell(index, listeProduits, et.switchGray(et.nonGrasGaucheBordure, numLigne));
            as.addCell(et.getColumnWidthInPoints(index), "Arial", 10);
            as.addLine(listeProduits);
            et.setCell(++index, "", et.grasCentreBordureColor);
            ++index;
            ++i;
        }
        et.setCell(index, utilisateur.numTel1, et.switchGray(et.nonGrasCentreBordure, numLigne));
        et.setCell(++index, utilisateur.numTel2, et.switchGray(et.nonGrasCentreBordure, numLigne));
        et.setCell(++index, "", et.switchGray(et.nonGrasCentreBordure, numLigne));
        as.autosize(currentRow);
    }

    private String getListeProduit(DateColonne prodCol, Utilisateur utilisateur, List<ContratCell> cells, FeuilleEmargementJson feuilleEmargementJson) {
        G1D<ModeleContrat, ContratCell> c1 = new G1D<ModeleContrat, ContratCell>();
        c1.fill(cells);
        c1.groupBy(e -> e.modeleContratDate.modeleContrat);
        c1.sortLig(e -> e.producteur.nom, true);
        c1.sortLig(e -> e.nom, true);
        c1.sortCell(e -> e.modeleContratProduit.indx, true);
        c1.compute();
        List livs = c1.getFullCells();
        StringBuffer buf = new StringBuffer();
        for (G1D.Cell1 liv : livs) {
            if (feuilleEmargementJson.getNomDuProducteur() == ChoixOuiNon.OUI) {
                buf.append(((ModeleContrat)liv.lig).producteur.nom);
                buf.append("\n");
            }
            if (feuilleEmargementJson.getNomDuContrat() == ChoixOuiNon.OUI) {
                buf.append(((ModeleContrat)liv.lig).nom);
                buf.append("\n");
            }
            if (feuilleEmargementJson.getDetailProduits() != ChoixOuiNon.OUI) continue;
            for (ContratCell cell : liv.values) {
                Produit p = cell.modeleContratProduit.produit;
                String content = String.valueOf(cell.qte) + " " + p.nom + " , " + p.conditionnement;
                buf.append(" \u2022 " + content + "\n");
            }
        }
        return StringUtils.removeLast(buf.toString(), "\n");
    }

    private Entete getEntetePlanning(List<Date> dateLivs, RdbLink em, EGFeuilleEmargement.LibInfo libInfo) {
        Entete entete = new Entete();
        List<PeriodePermanenceDateDTO> permanenceDTOs = this.getPermanence(em, libInfo);
        for (Date dateLiv : dateLivs) {
            DateColonne dateCol = new DateColonne();
            dateCol.date = dateLiv;
            dateCol.permanence = this.findPermanence(permanenceDTOs, dateLiv);
            entete.dateCols.add(dateCol);
        }
        return entete;
    }

    private List<PeriodePermanenceDateDTO> getPermanence(RdbLink em, EGFeuilleEmargement.LibInfo libInfo) {
        return new PeriodePermanenceService().getAllDistributionsActif(em, libInfo.debut, libInfo.fin);
    }

    private String findPermanence(List<PeriodePermanenceDateDTO> permanenceDTOs, Date dateLiv) {
        for (PeriodePermanenceDateDTO permanenceDTO : permanenceDTOs) {
            if (!permanenceDTO.datePerm.equals(dateLiv)) continue;
            return permanenceDTO.getNomInscrit("\n");
        }
        return "";
    }

    private void addCumulParProducteur(List<ContratCell> cells, ExcelGeneratorTool et, FeuilleEmargementJson planningJson, Entete entete, RdbLink em) {
        G2D<Producteur, Date, ContratCell> c1 = new G2D<Producteur, Date, ContratCell>();
        c1.fill(cells);
        c1.groupByLig(e -> e.modeleContratDate.modeleContrat.producteur);
        c1.groupByCol(e -> e.modeleContratDate.dateLiv);
        c1.sortLig(e -> e.nom, true);
        c1.sortCol(e -> e, true);
        c1.compute();
        List producteurs = c1.getLigs();
        et.addRow("Cumul des quantit\u00e9s par producteur", et.grasGaucheNonWrappe);
        et.addRow();
        et.setCell(0, "Nom du producteur", et.grasCentreBordure);
        et.mergeCellsRight(0, 2);
        int index = 2;
        Iterator<DateColonne> iterator = entete.dateCols.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            et.setCell(index, "Produits", et.grasCentreBordure);
            et.mergeCellsRight(index, 2);
            index += 2;
        }
        et.setCell(index, "T\u00e9l\u00e9phone 1 ", et.grasCentreBordure);
        et.setCell(++index, "T\u00e9l\u00e9phone 2 ", et.grasCentreBordure);
        et.setCell(++index, "Commentaire ", et.grasCentreBordure);
        int i = 0;
        while (i < producteurs.size()) {
            Producteur producteur = (Producteur)producteurs.get(i);
            List<List<ContratCell>> ligne = c1.getLine(i);
            this.addRowCumulProducteur(et, entete, ligne, producteur, i, planningJson, em);
            ++i;
        }
        et.addRow();
        et.addRow("Quantit\u00e9s par amapien", et.grasGaucheNonWrappe);
    }

    private void addRowCumulProducteur(ExcelGeneratorTool et, Entete entete, List<List<ContratCell>> ligne, Producteur producteur, int numLigne, FeuilleEmargementJson feuilleEmargementJson, RdbLink em) {
        ExcelCellAutoSize as = new ExcelCellAutoSize(5);
        Row currentRow = et.addRow();
        et.setCell(0, producteur.nom, et.grasGaucheWrappeBordure);
        et.mergeCellsRight(0, 2);
        int index = 2;
        List<DateColonne> dateCols = entete.dateCols;
        int i = 0;
        while (i < dateCols.size()) {
            DateColonne prodCol = dateCols.get(i);
            List<ContratCell> cells = ligne.get(i);
            String listeProduits = this.getListeProduitProducteur(prodCol, cells, feuilleEmargementJson);
            et.setCell(index, listeProduits, et.switchGray(et.nonGrasGaucheBordure, numLigne));
            as.addCell(et.getColumnWidthInPoints(index) + et.getColumnWidthInPoints(index + 1), "Arial", 10);
            as.addLine(listeProduits);
            et.mergeCellsRight(index, 2);
            index += 2;
            ++i;
        }
        List<ProducteurUtilisateur> us = new ProducteurService().getProducteurUtilisateur(em, producteur);
        String tel1 = CollectionUtils.asString(us, "\n", e -> e.utilisateur.numTel1, true);
        String tel2 = CollectionUtils.asString(us, "\n", e -> e.utilisateur.numTel2, true);
        et.setCell(index, tel1, et.switchGray(et.nonGrasCentreBordure, numLigne));
        et.setCell(++index, tel2, et.switchGray(et.nonGrasCentreBordure, numLigne));
        et.setCell(++index, "", et.switchGray(et.nonGrasCentreBordure, numLigne));
        as.autosize(currentRow);
    }

    private String getListeProduitProducteur(DateColonne prodCol, List<ContratCell> cells, FeuilleEmargementJson feuilleEmargementJson) {
        G1D<ModeleContrat, ContratCell> c1 = new G1D<ModeleContrat, ContratCell>();
        c1.fill(cells);
        c1.groupBy(e -> e.modeleContratDate.modeleContrat);
        c1.sortLig(e -> e.nom, true);
        c1.compute();
        StringBuffer buf = new StringBuffer();
        List modeleContrats = c1.getKeys();
        int i = 0;
        while (i < modeleContrats.size()) {
            ModeleContrat modeleContrat = (ModeleContrat)modeleContrats.get(i);
            buf.append(modeleContrat.nom);
            buf.append("\n");
            List<ContratCell> pcells = c1.getCell(i);
            buf.append(this.computeListeProduit(pcells));
            ++i;
        }
        return StringUtils.removeLast(buf.toString(), "\n");
    }

    private String computeListeProduit(List<ContratCell> pcells) {
        G1D<Produit, ContratCell> c1 = new G1D<Produit, ContratCell>();
        c1.fill(pcells);
        c1.groupBy(e -> e.modeleContratProduit.produit);
        c1.sortLigAdvanced(e -> e.modeleContratProduit.indx, true);
        c1.compute();
        StringBuffer buf = new StringBuffer();
        List produits = c1.getKeys();
        int i = 0;
        while (i < produits.size()) {
            Produit p = (Produit)produits.get(i);
            List cells = c1.getCell(i);
            int qte = CollectionUtils.accumulateInt(cells, e -> e.qte);
            String content = String.valueOf(qte) + " " + p.nom + " , " + p.conditionnement;
            buf.append(" \u2022 " + content + "\n");
            ++i;
        }
        return buf.toString();
    }

    private List<ContratCell> getContratCell(RdbLink em, EGFeuilleEmargement.LibInfo libInfo, FeuilleEmargementJson planningJson) {
        Query q = em.createQuery("select c from ContratCell c WHERE  c.modeleContratDate.dateLiv >= :d1 AND c.modeleContratDate.dateLiv<:d2  ");
        q.setParameter("d1", (Object)libInfo.debut);
        q.setParameter("d2", (Object)libInfo.fin);
        List us = q.getResultList();
        return us;
    }

    public static class DateColonne {
        public Date date;
        public String permanence;
    }

    public static class Entete {
        public List<DateColonne> dateCols = new ArrayList<DateColonne>();
    }
}

