/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.excel.feuilledistribution.producteur;

import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.modele.ModeleContratDate;
import fr.amapj.model.models.contrat.modele.ModeleContratProduit;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.engine.generator.excel.AbstractExcelGenerator;
import fr.amapj.service.engine.generator.excel.ExcelFormat;
import fr.amapj.service.engine.generator.excel.ExcelGeneratorTool;
import fr.amapj.service.services.edgenerator.excel.feuilledistribution.producteur.EGGrilleTool;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.mescontrats.ContratDTO;
import fr.amapj.service.services.mescontrats.MesContratsService;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class EGSyntheseContrat
extends AbstractExcelGenerator {
    Long modeleContratId;

    public EGSyntheseContrat(Long modeleContratId) {
        this.modeleContratId = modeleContratId;
    }

    @Override
    public void fillExcelFile(RdbLink em, ExcelGeneratorTool et) {
        EGGrilleTool grilleTool = new EGGrilleTool();
        ModeleContrat mc = em.find(ModeleContrat.class, this.modeleContratId);
        List<ModeleContratProduit> prods = new GestionContratService().getAllProduit(em, mc);
        List<ModeleContratDate> dates = new GestionContratService().getAllDates(em, mc);
        List<Utilisateur> utilisateurs = new MesContratsService().getUtilisateur(em, mc);
        Map<Utilisateur, ContratDTO> contrats = grilleTool.loadContrat(em, utilisateurs, mc);
        int nbColGauche = 3;
        grilleTool.performSheet(et, "SYNTHESE DU CONTRAT", "Amap", mc, prods, dates, utilisateurs, nbColGauche, contrats);
    }

    @Override
    public String getFileName(RdbLink em) {
        ModeleContrat mc = em.find(ModeleContrat.class, this.modeleContratId);
        return "synthese-" + mc.nom;
    }

    @Override
    public String getNameToDisplay(RdbLink em) {
        return "la synthese des distributions en une page";
    }

    @Override
    public ExcelFormat getFormat() {
        return ExcelFormat.XLSX;
    }

    public static void main(String[] args) throws IOException {
        new EGSyntheseContrat(11252L).test();
    }
}

