/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.excel.livraison;

import fr.amapj.common.CollectionUtils;
import fr.amapj.common.DateUtils;
import fr.amapj.common.FormatUtils;
import fr.amapj.common.StringUtils;
import fr.amapj.common.collections.G1D;
import fr.amapj.common.collections.M2;
import fr.amapj.common.periode.TypPeriode;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.reel.ContratCell;
import fr.amapj.model.models.fichierbase.Produit;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.model.models.permanence.periode.PeriodePermanenceDate;
import fr.amapj.service.engine.generator.excel.AbstractExcelGenerator;
import fr.amapj.service.engine.generator.excel.ExcelCellAutoSize;
import fr.amapj.service.engine.generator.excel.ExcelFormat;
import fr.amapj.service.engine.generator.excel.ExcelGeneratorTool;
import fr.amapj.service.services.edgenerator.excel.livraison.LivraisonAmapienCommon;
import fr.amapj.service.services.parametres.ParametresDTO;
import fr.amapj.service.services.parametres.ParametresService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;

public class EGLivraisonAmapien
extends AbstractExcelGenerator {
    private static final char BULLET_CHARACTER = '\u2022';
    private Date endDate;
    private Date startDate;
    private Long idUtilisateur;
    private TypPeriode typPeriode;

    public EGLivraisonAmapien(TypPeriode typPeriode, Date startDate, Date endDate, Long idUtilisateur) {
        this.typPeriode = typPeriode;
        this.startDate = startDate;
        this.endDate = endDate;
        this.idUtilisateur = idUtilisateur;
    }

    @Override
    public void fillExcelFile(RdbLink em, ExcelGeneratorTool et) {
        List<Utilisateur> utilisateurs = new LivraisonAmapienCommon().getUtilisateurs(em, this.idUtilisateur, this.startDate, this.endDate);
        for (Utilisateur utilisateur : utilisateurs) {
            this.addOneSheet(em, utilisateur, et);
        }
        if (utilisateurs.size() == 0) {
            et.addSheet("AMAP", 1, 50);
            et.addRow("Il y a aucune livraison pour aucun utilisateur !!", et.grasGaucheWrappe);
        }
    }

    private void addOneSheet(RdbLink em, Utilisateur u, ExcelGeneratorTool et) {
        SimpleDateFormat df1 = FormatUtils.getFullDate();
        SimpleDateFormat df2 = FormatUtils.getTimeStd();
        String nomUtilisateur = String.valueOf(u.nom) + " " + u.prenom;
        et.addSheet(nomUtilisateur, 2, 15);
        et.setColumnWidth(1, 80);
        ParametresDTO param = new ParametresService().getParametres();
        et.addRow(param.nomAmap, et.grasCentre);
        et.mergeCellsRight(0, 2);
        ExcelCellAutoSize as = new ExcelCellAutoSize(0);
        Row currentRow = et.addRow();
        String lib = this.getTitre(nomUtilisateur);
        et.setCell(0, lib, et.grasGaucheWrappe);
        et.mergeCellsRight(0, 2);
        as.addCell(et.getColumnWidthInPointsForMergedCell(0, 2), "Arial", 10, true);
        as.addLine(lib);
        as.autosize(currentRow);
        et.addRow("Extrait le " + df2.format(DateUtils.getDate()), et.grasGaucheNonWrappe);
        et.addRow();
        et.addRow();
        et.setRowHeigth(2);
        et.setCell(0, "Date de livraison", et.grasCentreBordureGray);
        et.setCell(1, "Produits", et.grasCentreBordureGray);
        List<M2.Pair<Date, List<ContratCell>, List<PeriodePermanenceDate>>> dateLivs = new LivraisonAmapienCommon().computeListDateLiv(em, u, this.startDate, this.endDate);
        for (M2.Pair<Date, List<ContratCell>, List<PeriodePermanenceDate>> dateLiv : dateLivs) {
            this.drawBlocDate(em, et, (Date)dateLiv.key, (List)dateLiv.v1, (List)dateLiv.v2, df1);
        }
    }

    private String getTitre(String nomUtilisateur) {
        return "Livraisons pour " + nomUtilisateur + " pour " + new LivraisonAmapienCommon().getDescriptionPeriode(this.typPeriode, this.startDate, this.endDate);
    }

    private void drawBlocDate(RdbLink em, ExcelGeneratorTool et, Date datLiv, List<ContratCell> contratCells, List<PeriodePermanenceDate> perms, SimpleDateFormat df1) {
        String libLivraison = this.computeLibLivraison(contratCells);
        String libPermanence = CollectionUtils.asString(new LivraisonAmapienCommon().getInfoPermanence(perms), "\n");
        String libColProduit = StringUtils.removeLast(String.valueOf(libLivraison) + libPermanence, "\n");
        String libColDate = df1.format(datLiv);
        CellStyle dateStyle = et.nonGrasCentreBordure;
        boolean isBold = false;
        if (perms.size() != 0) {
            libColDate = String.valueOf(libColDate) + "\n\nPERMANENCE";
            dateStyle = et.grasCentreBordure;
            isBold = true;
        }
        ExcelCellAutoSize as = new ExcelCellAutoSize(5);
        Row currentRow = et.addRow();
        et.setCell(0, libColDate, dateStyle);
        as.addCell(et.getColumnWidthInPoints(0), "Arial", 10, isBold);
        as.addLine(libColDate);
        et.setCell(1, libColProduit, et.nonGrasGaucheBordure);
        as.addCell(et.getColumnWidthInPoints(1), "Arial", 10);
        as.addLine(libColProduit);
        as.autosize(currentRow);
    }

    private String computeLibLivraison(List<ContratCell> contratCells) {
        List<G1D.Cell1<ModeleContrat, ContratCell>> livs = new LivraisonAmapienCommon().computeBlocDate(contratCells);
        StringBuilder sb = new StringBuilder();
        for (G1D.Cell1<ModeleContrat, ContratCell> liv : livs) {
            sb.append((CharSequence)this.getListeProduit(liv));
        }
        return sb.toString();
    }

    private StringBuilder getListeProduit(G1D.Cell1<ModeleContrat, ContratCell> liv) {
        StringBuilder buf = new StringBuilder();
        buf.append(((ModeleContrat)liv.lig).nom);
        buf.append("\n");
        for (ContratCell cell : liv.values) {
            Produit p = cell.modeleContratProduit.produit;
            String content = String.valueOf(cell.qte) + " x " + p.nom + " , " + p.conditionnement;
            buf.append(" \u2022 " + content + "\n");
        }
        buf.append("\n");
        return buf;
    }

    @Override
    public String getFileName(RdbLink em) {
        return new LivraisonAmapienCommon().getFileName(this.typPeriode, this.startDate, this.endDate);
    }

    @Override
    public String getNameToDisplay(RdbLink em) {
        String nomUtilisateur;
        if (this.idUtilisateur == null) {
            nomUtilisateur = "tous les amapiens";
        } else {
            Utilisateur u = em.find(Utilisateur.class, this.idUtilisateur);
            nomUtilisateur = String.valueOf(u.nom) + " " + u.prenom;
        }
        return this.getTitre(nomUtilisateur);
    }

    @Override
    public ExcelFormat getFormat() {
        return ExcelFormat.XLS;
    }
}

