/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.excel.mntlivre;

import fr.amapj.common.DateUtils;
import fr.amapj.common.collections.G2D;
import fr.amapj.common.periode.PeriodeManager;
import fr.amapj.common.periode.TypPeriode;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.contrat.reel.ContratCell;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.engine.generator.excel.ExcelGeneratorTool;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.persistence.TypedQuery;

public class MntLivreTools {
    private int nbJourAvant;
    private int nbJourApres;
    private TypPeriode typPeriode;

    public MntLivreTools(TypPeriode typPeriode, int nbJourAvant, int nbJourApres) {
        this.typPeriode = typPeriode;
        this.nbJourAvant = nbJourAvant;
        this.nbJourApres = nbJourApres;
    }

    public void fillExcelFile(RdbLink em, ExcelGeneratorTool et, Consumer<PeriodeManager.Periode> fillTab) {
        LocalDateTime now = DateUtils.getLocalDateTime();
        PeriodeManager pm = new PeriodeManager(now, this.typPeriode, this.nbJourAvant, this.nbJourApres, (a, b) -> this.getAllowedDate(em, (LocalDate)a, (LocalDate)b));
        List<PeriodeManager.Periode> periodes = pm.getAllPeriodes();
        for (PeriodeManager.Periode periode : periodes) {
            fillTab.accept(periode);
        }
    }

    public void addAllLines(List<Utilisateur> ligs, int nbCol, RdbLink em, ExcelGeneratorTool et, G2D<Utilisateur, ?, ContratCell> c1) {
        int i;
        if (ligs.size() > 0) {
            et.addRow();
            et.setCell(0, "Total des contrats", et.grasCentreBordureGray);
            i = 1;
            while (i < nbCol) {
                et.setCellSumInColDown(i, 1, ligs.size(), et.prixCentreBordureGray);
                ++i;
            }
        }
        i = 0;
        while (i < ligs.size()) {
            Utilisateur u = ligs.get(i);
            List<List<ContratCell>> contrats = c1.getLine(i);
            this.addRow(u, contrats, et, em);
            ++i;
        }
    }

    public List<ContratCell> getContratCell(RdbLink em, PeriodeManager.Periode periode) {
        String query = "select c from ContratCell c WHERE c.modeleContratDate.dateLiv >= :d1 AND c.modeleContratDate.dateLiv<=:d2 ";
        TypedQuery<ContratCell> q = em.createQuery(query, ContratCell.class);
        q.setParameter("d1", (Object)DateUtils.asDate(periode.startDate));
        q.setParameter("d2", (Object)DateUtils.asDate(periode.endDate));
        return q.getResultList();
    }

    private List<LocalDate> getAllowedDate(RdbLink em, LocalDate startDate, LocalDate endDate) {
        String query = "select distinct(mcd.dateLiv) from ModeleContratDate mcd WHERE mcd.dateLiv >= :d1 AND mcd.dateLiv<=:d2 ";
        TypedQuery<Date> q = em.createQuery(query, Date.class);
        q.setParameter("d1", (Object)DateUtils.asDate(startDate));
        q.setParameter("d2", (Object)DateUtils.asDate(endDate));
        return q.getResultList().stream().map(e -> DateUtils.asLocalDate(e)).collect(Collectors.toList());
    }

    private void addRow(Utilisateur u, List<List<ContratCell>> cells, ExcelGeneratorTool et, RdbLink em) {
        et.addRow();
        et.setCell(0, String.valueOf(u.nom) + " " + u.prenom, et.nonGrasCentreBordure);
        if (cells.size() > 0) {
            et.setCellSumInRow(1, 2, cells.size(), et.prixCentreBordure);
        }
        int index = 2;
        for (List<ContratCell> cs : cells) {
            int montant = cs.stream().mapToInt(e -> e.qte * e.modeleContratProduit.prix).sum();
            et.setCellPrix(index, montant, et.prixCentreBordure);
            ++index;
        }
    }
}

