/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.excel.permanence;

import fr.amapj.common.CollectionUtils;
import fr.amapj.common.DateUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.permanence.periode.PeriodePermanence;
import fr.amapj.service.engine.generator.excel.AbstractExcelGenerator;
import fr.amapj.service.engine.generator.excel.ExcelFormat;
import fr.amapj.service.engine.generator.excel.ExcelGeneratorTool;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDateDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceService;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class EGPlanningPermanence
extends AbstractExcelGenerator {
    private Long idPeriodePermanence;
    private Date startingDate;

    public EGPlanningPermanence(Long idPeriodePermanence, Date startingDate) {
        this.idPeriodePermanence = idPeriodePermanence;
        this.startingDate = startingDate;
    }

    @Override
    public void fillExcelFile(RdbLink em, ExcelGeneratorTool et) {
        this.addSheet(et, false);
        this.addSheet(et, true);
    }

    private void addSheet(ExcelGeneratorTool et, boolean withRole) {
        PeriodePermanenceDTO dto = new PeriodePermanenceService().loadPeriodePermanenceDTO(this.idPeriodePermanence);
        SimpleDateFormat df = new SimpleDateFormat("EEEEE dd MMMMM yyyy");
        if (withRole) {
            et.addSheet("Planning avec r\u00f4les", 4, 56);
            et.setColumnWidth(0, 2);
            et.setColumnWidth(2, 2);
        } else {
            et.addSheet("Planning sans r\u00f4les", 6, 28);
            et.setColumnWidth(0, 2);
            et.setColumnWidth(2, 2);
            et.setColumnWidth(4, 2);
        }
        et.addRow("Planning des permanences", et.grasGaucheNonWrappe);
        et.addRow(dto.nom, et.grasGaucheNonWrappe);
        et.addRow("", et.grasGaucheNonWrappe);
        List<PeriodePermanenceDateDTO> datesToProcess = dto.datePerms;
        if (this.startingDate != null) {
            this.startingDate = DateUtils.suppressTime(this.startingDate);
            datesToProcess = CollectionUtils.filter(datesToProcess, e -> e.datePerm.after(this.startingDate) || e.datePerm.equals(this.startingDate));
        }
        int nbCol = withRole ? 2 : 3;
        List<List<PeriodePermanenceDateDTO>> lines = CollectionUtils.cutInSubList(datesToProcess, nbCol);
        for (List<PeriodePermanenceDateDTO> line : lines) {
            this.processOneLine(line, et, df, withRole);
        }
    }

    private void processOneLine(List<PeriodePermanenceDateDTO> line, ExcelGeneratorTool et, SimpleDateFormat df, boolean withRole) {
        et.addRow();
        int index = 1;
        for (PeriodePermanenceDateDTO distributionDTO : line) {
            et.setCell(index, df.format(distributionDTO.datePerm), et.grasCentreBordure);
            index += 2;
        }
        et.addRow();
        index = 1;
        int maxLine = 1;
        for (PeriodePermanenceDateDTO distributionDTO : line) {
            String str = withRole ? distributionDTO.getNomInscritWithRoles("\n") : distributionDTO.getNomInscrit("\n");
            et.setCell(index, str, et.grasCentreBordure);
            maxLine = Math.max(maxLine, distributionDTO.getNbInscrit());
            index += 2;
        }
        et.setRowHeigth(maxLine + 1);
        et.addRow();
    }

    @Override
    public String getFileName(RdbLink em) {
        PeriodePermanence pp = em.find(PeriodePermanence.class, this.idPeriodePermanence);
        return "planning-permanence-" + pp.nom;
    }

    @Override
    public String getNameToDisplay(RdbLink em) {
        PeriodePermanence pp = em.find(PeriodePermanence.class, this.idPeriodePermanence);
        return "le planning des permanences " + pp.nom;
    }

    @Override
    public ExcelFormat getFormat() {
        return ExcelFormat.XLS;
    }

    public static void main(String[] args) throws IOException {
        new EGPlanningPermanence(1L, null).test();
    }
}

