/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.odt;

import fr.amapj.common.velocity.VelocityTools;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.reel.Contrat;
import fr.amapj.model.models.editionspe.EditionSpecifique;
import fr.amapj.model.models.editionspe.engagement.EngagementJson;
import fr.amapj.model.models.fichierbase.Producteur;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.engine.generator.odt.AbstractOdtGenerator;
import fr.amapj.service.engine.generator.odt.OdtGeneratorTool;
import fr.amapj.service.services.edgenerator.velocity.VCBuilder;
import fr.amapj.service.services.editionspe.EditionSpeService;
import fr.amapj.service.services.mescontrats.MesContratsService;
import fr.amapj.service.services.producteur.ProdUtilisateurDTO;
import fr.amapj.service.services.producteur.ProducteurService;
import java.util.List;

public class OGExemple
extends AbstractOdtGenerator {
    Long modeleContratId;

    public OGExemple(Long modeleContratId) {
        this.modeleContratId = modeleContratId;
    }

    @Override
    public void fillWordFile(RdbLink em, OdtGeneratorTool et) {
        ModeleContrat mc = em.find(ModeleContrat.class, this.modeleContratId);
        EditionSpecifique editionSpecifique = mc.engagement;
        EngagementJson engagement = (EngagementJson)new EditionSpeService().load(editionSpecifique.id);
        String htmlContent = engagement.getText();
        List<Utilisateur> utilisateurs = new MesContratsService().getUtilisateur(em, mc);
        for (Utilisateur utilisateur : utilisateurs) {
            Contrat c = new MesContratsService().getContrat(this.modeleContratId, em, utilisateur);
            this.addOneContrat(em, c, utilisateur, et, htmlContent);
            et.addSautPage();
        }
    }

    private void addOneContrat(RdbLink em, Contrat c, Utilisateur utilisateur, OdtGeneratorTool et, String htmlContent) {
        VelocityTools ctx = this.generateContext(em, c, utilisateur);
        String res = ctx.evaluate(htmlContent);
        et.addWikiContent(res);
    }

    private VelocityTools generateContext(RdbLink em, Contrat c, Utilisateur utilisateur) {
        VelocityTools ctx = new VelocityTools();
        Producteur producteur = c.modeleContrat.producteur;
        VCBuilder.addAmap(ctx);
        VCBuilder.addDateInfo(ctx);
        VCBuilder.addAmapien(ctx, utilisateur);
        VCBuilder.addContrat(ctx, c.modeleContrat, c, null, em);
        VCBuilder.addProducteur(ctx, producteur);
        List<ProdUtilisateurDTO> refs = new ProducteurService().getReferents(em, producteur);
        if (refs.size() >= 1) {
            ProdUtilisateurDTO ref = refs.get(0);
            Utilisateur r = em.find(Utilisateur.class, ref.idUtilisateur);
            VCBuilder.addReferent(ctx, r);
        }
        return ctx;
    }

    @Override
    public String getFileName(RdbLink em) {
        ModeleContrat mc = em.find(ModeleContrat.class, this.modeleContratId);
        return "engagements-" + mc.nom;
    }

    @Override
    public String getNameToDisplay(RdbLink em) {
        em.find(ModeleContrat.class, this.modeleContratId);
        return "la liste des contrats d'engagement";
    }

    public static void main(String[] args) throws Exception {
        new OGExemple(10011L).test();
    }
}

