/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.pdf;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.velocity.VelocityTools;
import fr.amapj.common.velocity.VelocityVar;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.contrat.modele.GestionDocEngagement;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.reel.Contrat;
import fr.amapj.model.models.editionspe.AbstractEditionSpeJson;
import fr.amapj.model.models.editionspe.AbstractPdfEditionSpeJson;
import fr.amapj.model.models.editionspe.EditionSpecifique;
import fr.amapj.model.models.editionspe.engagement.EngagementJson;
import fr.amapj.model.models.fichierbase.Producteur;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.engine.generator.pdf.PdfGeneratorTool;
import fr.amapj.service.engine.generator.pdf.TestablePdfGenerator;
import fr.amapj.service.services.edgenerator.velocity.VCBuilder;
import fr.amapj.service.services.editionspe.EditionSpeService;
import fr.amapj.service.services.mescontrats.ContratDTO;
import fr.amapj.service.services.mescontrats.MesContratsService;
import fr.amapj.service.services.producteur.ProdUtilisateurDTO;
import fr.amapj.service.services.producteur.ProducteurService;
import java.util.List;

public class PGEngagement
extends TestablePdfGenerator {
    private Long modeleContratId;
    private Long contratId;
    private PGEngagementMode mode;
    private ContratDTO contratDTO;
    private Long idSignatureUtilisateur;
    private List<VelocityVar> usedVars;

    public PGEngagement(PGEngagementMode mode, Long modeleContratId, Long contratId, EngagementJson forTest, ContratDTO contratDTO, Long idSignatureUtilisateur) {
        super(forTest);
        this.mode = mode;
        this.modeleContratId = modeleContratId;
        this.contratId = contratId;
        this.contratDTO = contratDTO;
        this.idSignatureUtilisateur = idSignatureUtilisateur;
    }

    public PGEngagement(PGEngagementMode mode, Long modeleContratId, Long contratId, EngagementJson forTest) {
        this(mode, modeleContratId, contratId, forTest, null, null);
    }

    @Override
    public String readDataInTestMode(RdbLink em, AbstractEditionSpeJson forTest) {
        EngagementJson engJson = (EngagementJson)forTest;
        if (engJson.idModeleContrat == null) {
            return "<p>Vous devez selectionner un contrat pour pouvoir tester !</p>";
        }
        this.modeleContratId = engJson.idModeleContrat;
        this.contratId = null;
        return null;
    }

    @Override
    public AbstractPdfEditionSpeJson getEditionInNormalMode(RdbLink em) {
        ModeleContrat mc = em.find(ModeleContrat.class, this.modeleContratId);
        EditionSpecifique editionSpecifique = mc.engagement;
        EngagementJson engagement = (EngagementJson)new EditionSpeService().load(editionSpecifique.id);
        return engagement;
    }

    @Override
    public void fillPdfFile(RdbLink em, PdfGeneratorTool et, String htmlContent) {
        switch (this.mode) {
            case TOUS_LES_CONTRATS: 
            case TOUS_LES_CONTRATS_EN_MODE_TEST: {
                this.performAllContratOfModele(em, et, htmlContent);
                break;
            }
            case UN_CONTRAT: {
                this.performOneContrat(em, et, htmlContent);
                break;
            }
            case UN_VIERGE: {
                this.performOneContratVierge(em, et, htmlContent);
                break;
            }
            case CONTRAT_A_SIGNER: {
                this.performOneContratASigner(em, et, htmlContent);
                break;
            }
            default: {
                throw new AmapjRuntimeException();
            }
        }
    }

    private void performOneContratVierge(RdbLink em, PdfGeneratorTool et, String htmlContent) {
        ModeleContrat mc = em.find(ModeleContrat.class, this.modeleContratId);
        Producteur producteur = mc.producteur;
        this.addOneContrat(em, mc, null, null, et, htmlContent, producteur);
    }

    private void performOneContrat(RdbLink em, PdfGeneratorTool et, String htmlContent) {
        Contrat c = em.find(Contrat.class, this.contratId);
        Utilisateur utilisateur = c.utilisateur;
        Producteur producteur = c.modeleContrat.producteur;
        if (!c.modeleContrat.getId().equals(this.modeleContratId)) {
            throw new AmapjRuntimeException("Incoherence");
        }
        VelocityTools vt = this.addOneContrat(em, c.modeleContrat, c, utilisateur, et, htmlContent, producteur);
        this.usedVars = vt.getUsedVars();
    }

    private void performOneContratASigner(RdbLink em, PdfGeneratorTool et, String htmlContent) {
        ModeleContrat mc = em.find(ModeleContrat.class, this.modeleContratId);
        Producteur producteur = mc.producteur;
        Utilisateur utilisateur = em.findOrNull(Utilisateur.class, this.idSignatureUtilisateur);
        VelocityTools vt = this.addOneContrat(em, mc, null, utilisateur, et, htmlContent, producteur);
        this.usedVars = vt.getUsedVars();
    }

    private void performAllContratOfModele(RdbLink em, PdfGeneratorTool et, String htmlContent) {
        ModeleContrat mc = em.find(ModeleContrat.class, this.modeleContratId);
        Producteur producteur = mc.producteur;
        List<Utilisateur> utilisateurs = new MesContratsService().getUtilisateur(em, mc);
        int nb = utilisateurs.size();
        int i = 0;
        while (i < nb) {
            Utilisateur utilisateur = utilisateurs.get(i);
            Contrat c = new MesContratsService().getContrat(mc.getId(), em, utilisateur);
            this.addOneContrat(em, mc, c, utilisateur, et, htmlContent, producteur);
            if (i != nb - 1) {
                et.addSautPage();
            }
            ++i;
        }
        if (nb == 0) {
            et.addContent("<p>Aucun utilisateur n'a souscrit \u00e0 ce contrat !! </p>");
        }
    }

    private VelocityTools addOneContrat(RdbLink em, ModeleContrat mc, Contrat c, Utilisateur utilisateur, PdfGeneratorTool et, String htmlContent, Producteur producteur) {
        VelocityTools ctx = this.generateContext(em, mc, c, utilisateur, producteur);
        String res = ctx.evaluate(htmlContent);
        et.addContent(res);
        return ctx;
    }

    private VelocityTools generateContext(RdbLink em, ModeleContrat mc, Contrat c, Utilisateur utilisateur, Producteur producteur) {
        VelocityTools ctx = new VelocityTools();
        VCBuilder.addContrat(ctx, mc, c, this.contratDTO, em);
        VCBuilder.addAmap(ctx);
        VCBuilder.addDateInfo(ctx);
        VCBuilder.addAmapien(ctx, utilisateur);
        VCBuilder.addProducteur(ctx, producteur);
        List<ProdUtilisateurDTO> refs = new ProducteurService().getReferents(em, producteur);
        if (refs.size() >= 1) {
            ProdUtilisateurDTO ref = refs.get(0);
            Utilisateur r = em.find(Utilisateur.class, ref.idUtilisateur);
            VCBuilder.addReferent(ctx, r);
        } else {
            VCBuilder.addReferent(ctx, null);
        }
        List<ProdUtilisateurDTO> contactProds = new ProducteurService().getUtilisateur(em, producteur);
        if (contactProds.size() >= 1) {
            ProdUtilisateurDTO contactProd = contactProds.get(0);
            Utilisateur r = em.find(Utilisateur.class, contactProd.idUtilisateur);
            VCBuilder.addContactProducteur(ctx, r);
        } else {
            VCBuilder.addContactProducteur(ctx, null);
        }
        return ctx;
    }

    @Override
    public String getFileNameStandard(RdbLink em) {
        ModeleContrat mc = em.find(ModeleContrat.class, this.modeleContratId);
        switch (this.mode) {
            case TOUS_LES_CONTRATS: {
                return "engagements-" + mc.nom;
            }
            case TOUS_LES_CONTRATS_EN_MODE_TEST: {
                return "test-" + mc.nom;
            }
            case UN_CONTRAT: {
                Utilisateur u = em.find(Contrat.class, (Object)this.contratId).utilisateur;
                return "document-engagement-" + mc.nom + "-" + u.nom + " " + u.prenom;
            }
            case UN_VIERGE: {
                return "engagement-vierge-" + mc.nom;
            }
            case CONTRAT_A_SIGNER: {
                return "signature-contrat";
            }
        }
        throw new AmapjRuntimeException();
    }

    @Override
    public String getNameToDisplayStandard(RdbLink em) {
        switch (this.mode) {
            case TOUS_LES_CONTRATS: {
                return "tous les documents d'engagement (\u00e0 imprimer et \u00e0 signer)";
            }
            case TOUS_LES_CONTRATS_EN_MODE_TEST: {
                return "mode test";
            }
            case UN_CONTRAT: {
                Contrat c = em.find(Contrat.class, this.contratId);
                Utilisateur u = c.utilisateur;
                if (c.modeleContrat.gestionDocEngagement == GestionDocEngagement.SIGNATURE_EN_LIGNE) {
                    return "le document d'engagement " + c.modeleContrat.nom + " pour " + u.nom + " " + u.prenom + " (\u00e0 signer en ligne)";
                }
                return "le document d'engagement " + c.modeleContrat.nom + " pour " + u.nom + " " + u.prenom + " (\u00e0 imprimer et \u00e0 signer)";
            }
            case UN_VIERGE: {
                return "un document d'engagement vierge";
            }
            case CONTRAT_A_SIGNER: {
                return "signature du contrat";
            }
        }
        throw new AmapjRuntimeException();
    }

    public List<VelocityVar> getUsedVars() {
        return this.usedVars;
    }

    public static void main(String[] args) throws Exception {
        new PGEngagement(PGEngagementMode.TOUS_LES_CONTRATS, 10011L, null, null, null, null).test();
    }

    public static enum PGEngagementMode {
        TOUS_LES_CONTRATS,
        UN_CONTRAT,
        UN_VIERGE,
        TOUS_LES_CONTRATS_EN_MODE_TEST,
        CONTRAT_A_SIGNER;

    }
}

