/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.pdf;

import fr.amapj.common.periode.TypPeriode;
import fr.amapj.common.velocity.VelocityTools;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.editionspe.bilanlivraison.BilanLivraisonJson;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.engine.generator.pdf.AbstractPdfGenerator;
import fr.amapj.service.engine.generator.pdf.PdfGeneratorTool;
import fr.amapj.service.services.edgenerator.excel.livraison.LivraisonAmapienCommon;
import fr.amapj.service.services.edgenerator.velocity.VCBuilder;
import fr.amapj.service.services.editionspe.EditionSpeService;
import java.util.Date;
import java.util.List;

public class PGLivraisonAmapien
extends AbstractPdfGenerator {
    private Date endDate;
    private Date startDate;
    private Long idUtilisateur;
    private TypPeriode typPeriode;
    private Long idEditionSpecifique;

    public PGLivraisonAmapien(TypPeriode typPeriode, Date startDate, Date endDate, Long idUtilisateur, Long idEditionSpecifique) {
        this.typPeriode = typPeriode;
        this.startDate = startDate;
        this.endDate = endDate;
        this.idUtilisateur = idUtilisateur;
        this.idEditionSpecifique = idEditionSpecifique;
    }

    @Override
    public void fillPdfFile(RdbLink em, PdfGeneratorTool et) {
        BilanLivraisonJson json = (BilanLivraisonJson)new EditionSpeService().load(this.idEditionSpecifique);
        et.startDocument(json);
        List<Utilisateur> utilisateurs = new LivraisonAmapienCommon().getUtilisateurs(em, this.idUtilisateur, this.startDate, this.endDate);
        int nb = utilisateurs.size();
        int i = 0;
        while (i < utilisateurs.size()) {
            Utilisateur utilisateur = utilisateurs.get(i);
            this.performOneBilan(em, utilisateur, et, json.getText());
            if (i != nb - 1) {
                et.addSautPage();
            }
            ++i;
        }
        if (utilisateurs.size() == 0) {
            et.addContent("<p>Il y a aucune livraison pour aucun utilisateur !! </p>");
        }
    }

    private void performOneBilan(RdbLink em, Utilisateur utilisateur, PdfGeneratorTool et, String htmlContent) {
        VelocityTools ctx = this.generateContext(em, utilisateur);
        String res = ctx.evaluate(htmlContent);
        et.addContent(res);
    }

    private VelocityTools generateContext(RdbLink em, Utilisateur utilisateur) {
        VelocityTools ctx = new VelocityTools();
        VCBuilder.addAmap(ctx);
        VCBuilder.addDateInfo(ctx);
        VCBuilder.addAmapien(ctx, utilisateur);
        VCBuilder.addBilanLivraison(ctx, utilisateur, em, this.typPeriode, this.startDate, this.endDate);
        return ctx;
    }

    @Override
    public String getFileName(RdbLink em) {
        return new LivraisonAmapienCommon().getFileName(this.typPeriode, this.startDate, this.endDate);
    }

    @Override
    public String getNameToDisplay(RdbLink em) {
        String nomUtilisateur;
        if (this.idUtilisateur == null) {
            nomUtilisateur = "tous les amapiens";
        } else {
            Utilisateur u = em.find(Utilisateur.class, this.idUtilisateur);
            nomUtilisateur = String.valueOf(u.nom) + " " + u.prenom;
        }
        return "Livraisons pour " + nomUtilisateur + " pour " + new LivraisonAmapienCommon().getDescriptionPeriode(this.typPeriode, this.startDate, this.endDate);
    }
}

