/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.velocity;

import fr.amapj.common.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class CompactorTools {
    private List<Item> items = new ArrayList<Item>();
    private boolean enabledCompact;

    public CompactorTools(boolean enabledCompact) {
        this.enabledCompact = enabledCompact;
    }

    public void addLine(String s1, String s2) {
        if (s2 == null || s2.length() == 0) {
            return;
        }
        if (!this.enabledCompact) {
            this.items.add(new Item(s1, s2));
            return;
        }
        Item item = this.findMatchingItem(s2);
        if (item == null) {
            this.items.add(new Item(s1, s2));
            return;
        }
        item.part1s.add(s1);
    }

    private Item findMatchingItem(String s2) {
        for (Item item : this.items) {
            if (!item.part2.equals(s2)) continue;
            return item;
        }
        return null;
    }

    public List<String> getResult(String header1, String header2, String sep1, String sep2, String trailer) {
        ArrayList<String> res = new ArrayList<String>();
        for (Item item : this.items) {
            String header = item.part1s.size() == 1 ? header1 : header2;
            String s = String.valueOf(header) + StringUtils.asString(item.part1s, sep1) + sep2 + item.part2 + trailer;
            res.add(s);
        }
        return res;
    }

    public List<Item> getResult() {
        return this.items;
    }

    public static class Item {
        String part1;
        String part2;
        List<String> part1s = new ArrayList<String>();

        public Item(String part1, String part2) {
            this.part1 = part1;
            this.part2 = part2;
            this.part1s.add(part1);
        }
    }
}

