/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.velocity;

import fr.amapj.common.CollectionUtils;
import fr.amapj.common.FormatUtils;
import fr.amapj.common.ResourceUtils;
import fr.amapj.common.collections.G1D;
import fr.amapj.common.collections.M2;
import fr.amapj.common.periode.TypPeriode;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.reel.ContratCell;
import fr.amapj.model.models.fichierbase.Produit;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.model.models.permanence.periode.PeriodePermanenceDate;
import fr.amapj.service.services.edgenerator.excel.livraison.LivraisonAmapienCommon;
import fr.amapj.service.services.edgenerator.velocity.VCBuilder;
import fr.amapj.view.views.editionspe.bilanlivraison.BilanLivraisonEditorPart;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class VCBilanLivraison {
    public String nomPeriode;
    public String nomPeriodeTitre;
    public String tableauDateProduit;

    public void load(RdbLink em, Utilisateur utilisateur, TypPeriode typPeriode, Date startDate, Date endDate) {
        this.nomPeriode = this.s(new LivraisonAmapienCommon().getDescriptionPeriode(typPeriode, startDate, endDate));
        this.nomPeriodeTitre = this.s(new LivraisonAmapienCommon().getDescriptionPeriodeTitre(typPeriode, startDate, endDate));
        this.tableauDateProduit = this.computeTableauDateProduit(em, utilisateur, typPeriode, startDate, endDate);
    }

    public String computeTableauDateProduit(RdbLink em, Utilisateur utilisateur, TypPeriode typPeriode, Date startDate, Date endDate) {
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat df = FormatUtils.getFullDate();
        sb.append(ResourceUtils.toStringClass(BilanLivraisonEditorPart.class, "template/styles.html"));
        sb.append("<table id=\"bilan_livraison\">");
        sb.append("<tr><th class=\"date\">Date de livraison</th><th>Produits</th></tr>");
        List<M2.Pair<Date, List<ContratCell>, List<PeriodePermanenceDate>>> dateLivs = new LivraisonAmapienCommon().computeListDateLiv(em, utilisateur, startDate, endDate);
        for (M2.Pair<Date, List<ContratCell>, List<PeriodePermanenceDate>> dateLiv : dateLivs) {
            this.drawBlocDate((Date)dateLiv.key, (List)dateLiv.v1, (List)dateLiv.v2, df, sb);
        }
        sb.append("</table>");
        return sb.toString();
    }

    private void drawBlocDate(Date lig, List<ContratCell> values, List<PeriodePermanenceDate> perms, SimpleDateFormat df, StringBuilder buf) {
        buf.append("<tr>");
        String libColDate = df.format(lig);
        if (perms.size() != 0) {
            libColDate = "<b/>" + libColDate + "<br/><br/>PERMANENCE</b>";
        }
        buf.append("<td class=\"date\">");
        buf.append("<p style=\"margin:0.1em\">" + libColDate + "</p>");
        buf.append("</td>");
        String libProduit = this.getListeProduit(values);
        String libPermanence = CollectionUtils.asString(new LivraisonAmapienCommon().getInfoPermanence(perms), "", e -> "<p style=\"margin:0.1em\"><b>" + e + "</b></p>");
        buf.append("<td>");
        buf.append(String.valueOf(libProduit) + libPermanence);
        buf.append("</td>");
        buf.append("</tr>");
    }

    private String getListeProduit(List<ContratCell> values) {
        StringBuilder buf = new StringBuilder();
        List<G1D.Cell1<ModeleContrat, ContratCell>> livs = new LivraisonAmapienCommon().computeBlocDate(values);
        for (G1D.Cell1<ModeleContrat, ContratCell> liv : livs) {
            buf.append("<p style=\"margin:0.1em\">" + this.s(((ModeleContrat)liv.lig).nom) + "</p>");
            buf.append("<ul>");
            for (ContratCell cell : liv.values) {
                Produit p = cell.modeleContratProduit.produit;
                String content = String.valueOf(cell.qte) + " x " + p.nom + " , " + p.conditionnement;
                buf.append("<li>" + this.s(content) + "</li>");
            }
            buf.append("</ul>");
        }
        return buf.toString();
    }

    private String s(String value) {
        return VCBuilder.s(value);
    }

    public String getNomPeriode() {
        return this.nomPeriode;
    }

    public void setNomPeriode(String nomPeriode) {
        this.nomPeriode = nomPeriode;
    }

    public String getTableauDateProduit() {
        return this.tableauDateProduit;
    }

    public void setTableauDateProduit(String tableauDateProduit) {
        this.tableauDateProduit = tableauDateProduit;
    }

    public String getNomPeriodeTitre() {
        return this.nomPeriodeTitre;
    }

    public void setNomPeriodeTitre(String nomPeriodeTitre) {
        this.nomPeriodeTitre = nomPeriodeTitre;
    }
}

