/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.velocity;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.StringUtils;
import fr.amapj.common.velocity.VelocityTools;
import fr.amapj.common.velocity.VelocityVar;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.reel.Contrat;
import fr.amapj.service.services.edgenerator.velocity.CompactorTools;
import fr.amapj.service.services.edgenerator.velocity.VCBuilder;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.gestioncontrat.ModeleContratDTO;
import fr.amapj.service.services.gestioncontrat.ModeleContratSummaryDTO;
import fr.amapj.service.services.mescontrats.ContratColDTO;
import fr.amapj.service.services.mescontrats.ContratDTO;
import fr.amapj.service.services.mescontrats.ContratLigDTO;
import fr.amapj.service.services.mescontrats.DatePaiementDTO;
import fr.amapj.service.services.mescontrats.InfoPaiementDTO;
import fr.amapj.service.services.mescontrats.MesContratsService;
import fr.amapj.view.engine.widgets.CurrencyTextFieldConverter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class VCContrat {
    public String nom;
    public String description;
    public String dateDebut;
    public String dateFin;
    public String dateFinInscription;
    public String nbLivraison;
    public String saison;
    public VelocityVar libCheque;
    public String dateRemiseCheque;
    public VelocityVar nbCheque;
    public VelocityVar tableauDateProduit;
    public VelocityVar tableauDateProduitCompact;
    public VelocityVar tableauDateCheque;
    public VelocityVar montantProduit;
    public VelocityVar montantCheque;
    public VelocityVar montantAvoir;
    public VelocityVar listeDateProduit;
    public VelocityVar listeDateProduitCompact;
    public VelocityVar tableauOrListeDateProduit;
    public VelocityVar listeDateCheque;
    public VelocityVar listeDateChequeCompact;
    public VelocityVar amapienNbLivraison;
    public VelocityVar amapienNbProduit;
    public VelocityVar jokerNbMax;
    public VelocityVar jokerNbMin;
    public VelocityVar jokerTxt;
    public String signatureAmapien;
    public String signatureProducteur;
    private VelocityTools ctx;
    private Mode mode;
    private int mntTotal;

    public void load(ModeleContrat mc, Contrat c, ContratDTO contratDTO, RdbLink em, VelocityTools ctx) {
        this.ctx = ctx;
        this.mode = this.computeMode(c, contratDTO);
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        ModeleContratSummaryDTO sum = new GestionContratService().createModeleContratInfo(em, mc);
        ModeleContratDTO dto = new GestionContratService().loadModeleContrat(mc.getId());
        this.nom = this.s(dto.nom);
        this.description = this.s(dto.description);
        this.dateDebut = df.format(dto.dateDebut);
        this.dateFin = df.format(dto.dateFin);
        this.dateFinInscription = "";
        if (dto.dateFinInscription != null) {
            this.dateFinInscription = df.format(dto.dateFinInscription);
        }
        this.saison = this.getSaison(dto.dateDebut, dto.dateFin);
        this.nbLivraison = "" + sum.nbLivraison;
        this.libCheque = this.v("libCheque", this.s(dto.libCheque));
        this.dateRemiseCheque = "";
        if (dto.dateRemiseCheque != null) {
            this.dateRemiseCheque = df.format(dto.dateRemiseCheque);
        }
        this.jokerNbMax = this.v("jokerNbMax", "" + mc.jokerNbMax);
        this.jokerNbMin = this.v("jokerNbMin", "" + mc.jokerNbMin);
        this.jokerTxt = this.v("jokerTxt", this.computeJokerTxt(mc));
        contratDTO = this.computeContratDTO(mc, c, contratDTO);
        this.mntTotal = contratDTO.getMontantTotal();
        this.tableauDateProduit = this.v("tableauDateProduit", this.getTableauDateProduit(em, contratDTO, false));
        this.tableauDateProduitCompact = this.v("tableauDateProduitCompact", this.getTableauDateProduit(em, contratDTO, true));
        this.tableauDateCheque = this.v("tableauDateCheque", this.getTableauCheque(em, contratDTO));
        this.listeDateProduit = this.v("listeDateProduit", this.getListeDateProduit(em, contratDTO, false));
        this.listeDateProduitCompact = this.v("listeDateProduitCompact", this.getListeDateProduit(em, contratDTO, true));
        this.listeDateCheque = this.v("listeDateCheque", this.getListeDateCheque(em, contratDTO, false));
        this.listeDateChequeCompact = this.v("listeDateChequeCompact", this.getListeDateCheque(em, contratDTO, true));
        this.tableauOrListeDateProduit = this.v("tableauOrListeDateProduit", this.getTableauOrListeDateProduit(contratDTO));
        if (this.mode == Mode.STANDARD || this.mode == Mode.EN_SIGNATURE) {
            this.nbCheque = this.v("nbCheque", "" + contratDTO.paiement.datePaiements.stream().filter(e -> e.montant != 0).count());
            this.montantProduit = this.v("montantProduit", new CurrencyTextFieldConverter().convertToString(contratDTO.getMontantTotal()));
            this.montantCheque = this.v("montantCheque", new CurrencyTextFieldConverter().convertToString(contratDTO.paiement.getMontantTotalPaiement()));
            this.montantAvoir = this.v("montantAvoir", new CurrencyTextFieldConverter().convertToString(contratDTO.paiement.avoirInitial));
            this.amapienNbLivraison = this.v("amapienNbLivraison", "" + contratDTO.getNbLivraisonEffective());
            this.amapienNbProduit = this.v("amapienNbProduit", "" + contratDTO.getQteTotal());
        } else if (this.mode == Mode.VIERGE) {
            this.nbCheque = this.v("nbCheque", "");
            this.montantProduit = this.v("montantProduit", "");
            this.montantCheque = this.v("montantCheque", "");
            this.montantAvoir = this.v("montantAvoir", "");
            this.amapienNbLivraison = this.v("amapienNbLivraison", "");
            this.amapienNbProduit = this.v("amapienNbProduit", "");
        } else {
            throw new AmapjRuntimeException();
        }
        this.signatureAmapien = "<span style=\"font-size: 2pt;\">\u0142</span>";
        this.signatureProducteur = "<span style=\"font-size: 2pt;\">\u0140</span>";
    }

    private String getTableauOrListeDateProduit(ContratDTO contratDTO) {
        if (contratDTO.contratColumns.size() > 10) {
            return this.listeDateProduit.content;
        }
        return this.tableauDateProduit.content;
    }

    private ContratDTO computeContratDTO(ModeleContrat mc, Contrat c, ContratDTO contratDTO) {
        switch (this.mode) {
            case STANDARD: {
                return new MesContratsService().loadContrat(mc.getId(), c.getId());
            }
            case VIERGE: {
                return new MesContratsService().loadContrat(mc.getId(), null);
            }
            case EN_SIGNATURE: {
                return contratDTO;
            }
        }
        throw new AmapjRuntimeException();
    }

    private Mode computeMode(Contrat c, ContratDTO contratDTO) {
        if (c != null && contratDTO == null) {
            return Mode.STANDARD;
        }
        if (c == null && contratDTO == null) {
            return Mode.VIERGE;
        }
        if (c == null && contratDTO != null) {
            return Mode.EN_SIGNATURE;
        }
        throw new AmapjRuntimeException("c=" + c + "contratDto=" + contratDTO);
    }

    private String computeJokerTxt(ModeleContrat mc) {
        switch (mc.typJoker) {
            case SANS_JOKER: {
                return "Ce contrat n'accepte pas de jokers.";
            }
            case JOKER_ABSENCE: {
                return this.computeJokerTxt(mc, "absence (les paniers sont annul\u00e9s et non pay\u00e9s).");
            }
            case JOKER_REPORT: {
                return this.computeJokerTxt(mc, "report (les paniers sont report\u00e9s \u00e0 une autre date).");
            }
        }
        throw new AmapjRuntimeException("x=" + (Object)((Object)mc.typJoker));
    }

    private String computeJokerTxt(ModeleContrat mc, String lib) {
        if (mc.jokerNbMax == mc.jokerNbMin) {
            return "Ce contrat impose " + mc.jokerNbMin + " joker(s) en mode " + lib;
        }
        return "Ce contrat accepte entre " + mc.jokerNbMin + " et " + mc.jokerNbMax + " joker(s) en mode " + lib;
    }

    public String montantProduitTVA(double taux) {
        if (this.mntTotal == 0) {
            return "";
        }
        double montant = this.mntTotal;
        double mntTVA = montant - montant / (1.0 + taux / 100.0);
        int mntCentimes = (int)Math.round(mntTVA);
        return new CurrencyTextFieldConverter().convertToString(mntCentimes);
    }

    private String s(String value) {
        return VCBuilder.s(value);
    }

    private String getTableauDateProduit(RdbLink em, ContratDTO contratDTO, boolean compact) {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yy");
        StringBuffer buf = new StringBuffer();
        buf.append("<table style=\"border:1px solid black;border-collapse:collapse;width:100%;table-layout:fixed;text-align:center;\"><tbody>");
        buf.append("<tr>");
        buf.append("<td style=\"border:1px solid black;\">");
        buf.append("<p style=\"margin:0.1em\">DATE</p>");
        buf.append("</td>");
        List<ContratColDTO> contratColumns = this.filterCol(compact, contratDTO.contratColumns, contratDTO);
        for (ContratColDTO contratColDTO : contratColumns) {
            buf.append("<td style=\"border:1px solid black;\">");
            buf.append("<p style=\"margin:0.1em\">" + this.s(contratColDTO.nomProduit) + "</p>");
            buf.append("<p style=\"margin:0.1em\"><b>" + new CurrencyTextFieldConverter().convertToString(contratColDTO.prix) + "\u20ac </b></p>");
            buf.append("<p style=\"margin:0.1em\">" + this.s(contratColDTO.condtionnementProduit) + "</b></p>");
            buf.append("</td>");
        }
        buf.append("</tr>");
        List<ContratLigDTO> contratLigs = contratDTO.contratLigs;
        for (ContratLigDTO contratLigDTO : contratLigs) {
            if (compact && contratDTO.isEmptyLine(contratLigDTO.i)) continue;
            buf.append("<tr>");
            buf.append("<td style=\"border:1px solid black;\">");
            buf.append("<p style=\"margin:0.1em\">" + df.format(contratLigDTO.date) + "</p>");
            buf.append("</td>");
            for (ContratColDTO contratColDTO : contratColumns) {
                buf.append("<td style=\"border:1px solid black;\">");
                buf.append("<p style=\"margin:0.1em\">");
                int qte = contratDTO.cell[contratLigDTO.i][contratColDTO.j].qte;
                if (qte != 0) {
                    buf.append("" + qte);
                }
                buf.append("</p>");
                buf.append("</td>");
            }
            buf.append("</tr>");
        }
        buf.append("</tbody></table>");
        return buf.toString();
    }

    private List<ContratColDTO> filterCol(boolean compact, List<ContratColDTO> contratColumns, ContratDTO contratDTO) {
        if (!compact) {
            return contratColumns;
        }
        return contratColumns.stream().filter(e -> !contratDTO.isEmptyCol(e.j)).collect(Collectors.toList());
    }

    private String getTableauCheque(RdbLink em, ContratDTO contratDTO) {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yy");
        StringBuffer buf = new StringBuffer();
        InfoPaiementDTO paiement = contratDTO.paiement;
        if (paiement.avoirInitial != 0) {
            buf.append("<p>Avoir initial : " + new CurrencyTextFieldConverter().convertToString(paiement.avoirInitial) + " \u20ac</p>");
        }
        buf.append("<table style=\"border:1px solid black;border-collapse:collapse;width:100%;\"><tbody>");
        buf.append("<tr>");
        buf.append("<td style=\"border:1px solid black;width:50%\">");
        buf.append("<p style=\"margin:0.1em\">DATE DE DEBIT</p>");
        buf.append("</td>");
        buf.append("<td style=\"border:1px solid black;width:50%\">");
        buf.append("<p style=\"margin:0.1em\">MONTANT</p>");
        buf.append("</td>");
        buf.append("</tr>");
        for (DatePaiementDTO date : paiement.datePaiements) {
            if (date.montant == 0 && this.mode != Mode.VIERGE) continue;
            buf.append("<tr>");
            buf.append("<td style=\"border:1px solid black;width:50%\">");
            buf.append("<p style=\"margin:0.1em\">" + df.format(date.datePaiement) + "</p>");
            buf.append("</td>");
            buf.append("<td style=\"border:1px solid black;width:50%\">");
            buf.append("<p style=\"margin:0.1em\">");
            if (this.mode != Mode.VIERGE) {
                buf.append(new CurrencyTextFieldConverter().convertToString(date.montant) + " \u20ac");
            }
            buf.append("</p>");
            buf.append("</td>");
            buf.append("</tr>");
        }
        buf.append("</tbody></table>");
        return buf.toString();
    }

    private String getListeDateProduit(RdbLink em, ContratDTO contratDTO, boolean compact) {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yy");
        CompactorTools ct = new CompactorTools(compact);
        List<ContratColDTO> contratColumns = contratDTO.contratColumns;
        List<ContratLigDTO> contratLigs = contratDTO.contratLigs;
        int nbCol = contratColumns.size();
        int i = 0;
        for (ContratLigDTO contratLigDTO : contratLigs) {
            String s1 = df.format(contratLigDTO.date);
            ArrayList<String> s2 = new ArrayList<String>();
            int j = 0;
            while (j < nbCol) {
                if (contratDTO.cell[i][j].qte != 0) {
                    ContratColDTO contratColDTO = contratColumns.get(j);
                    StringBuffer buf = new StringBuffer();
                    buf.append(String.valueOf(contratDTO.cell[i][j].qte) + " ");
                    buf.append(String.valueOf(this.s(contratColDTO.nomProduit)) + " (");
                    buf.append(this.s(contratColDTO.condtionnementProduit));
                    buf.append(" - " + new CurrencyTextFieldConverter().convertToString(contratColDTO.prix) + " \u20ac)");
                    s2.add(buf.toString());
                }
                ++j;
            }
            ct.addLine(s1, StringUtils.asString(s2, ", "));
            ++i;
        }
        List<String> res = ct.getResult("Le ", "Les ", ", ", ": ", "");
        StringBuffer buf = new StringBuffer();
        buf.append("<ul style=\"margin:0pt;\">");
        for (String s : res) {
            buf.append("<li>");
            buf.append(s);
            buf.append("</li>");
        }
        buf.append("</ul>");
        return buf.toString();
    }

    private String getListeDateCheque(RdbLink em, ContratDTO contratDTO, boolean compact) {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yy");
        CompactorTools ct = new CompactorTools(compact);
        for (DatePaiementDTO dp : contratDTO.paiement.datePaiements) {
            if (dp.montant == 0) continue;
            String s1 = df.format(dp.datePaiement);
            String s2 = String.valueOf(new CurrencyTextFieldConverter().convertToString(dp.montant)) + " \u20ac";
            ct.addLine(s1, s2);
        }
        List<CompactorTools.Item> res = ct.getResult();
        StringBuffer buf = new StringBuffer();
        buf.append("<ul style=\"margin:0pt;\">");
        if (contratDTO.paiement.avoirInitial != 0) {
            buf.append("<li>Avoir initial : " + new CurrencyTextFieldConverter().convertToString(contratDTO.paiement.avoirInitial) + " \u20ac</li>");
        }
        for (CompactorTools.Item item : res) {
            buf.append("<li>");
            String str = String.valueOf(item.part1s.size()) + " ch\u00e8que";
            if (item.part1s.size() > 1) {
                str = String.valueOf(str) + "s";
            }
            str = String.valueOf(str) + " de <b>" + item.part2 + "</b> d\u00e9bit\u00e9";
            if (item.part1s.size() > 1) {
                str = String.valueOf(str) + "s";
            }
            str = String.valueOf(str) + " le";
            if (item.part1s.size() > 1) {
                str = String.valueOf(str) + "s";
            }
            str = String.valueOf(str) + " ";
            str = String.valueOf(str) + StringUtils.asString(item.part1s, ",");
            buf.append(str);
            buf.append("</li>");
        }
        buf.append("</ul>");
        return buf.toString();
    }

    private String getSaison(Date dateDebut, Date dateFin) {
        String s2;
        SimpleDateFormat df2 = new SimpleDateFormat("yyyy");
        String s1 = df2.format(dateDebut);
        if (s1.equals(s2 = df2.format(dateFin))) {
            return s1;
        }
        return String.valueOf(s1) + "-" + s2;
    }

    private VelocityVar v(String varName, String content) {
        VelocityVar var = this.ctx.createVar("contrat." + varName, content);
        return var;
    }

    public String getNom() {
        return this.nom;
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDateDebut() {
        return this.dateDebut;
    }

    public void setDateDebut(String dateDebut) {
        this.dateDebut = dateDebut;
    }

    public String getDateFin() {
        return this.dateFin;
    }

    public void setDateFin(String dateFin) {
        this.dateFin = dateFin;
    }

    public String getNbLivraison() {
        return this.nbLivraison;
    }

    public void setNbLivraison(String nbLivraison) {
        this.nbLivraison = nbLivraison;
    }

    public String getSaison() {
        return this.saison;
    }

    public void setSaison(String saison) {
        this.saison = saison;
    }

    public VelocityVar getLibCheque() {
        return this.libCheque;
    }

    public void setLibCheque(VelocityVar libCheque) {
        this.libCheque = libCheque;
    }

    public VelocityVar getNbCheque() {
        return this.nbCheque;
    }

    public void setNbCheque(VelocityVar nbCheque) {
        this.nbCheque = nbCheque;
    }

    public VelocityVar getTableauDateProduit() {
        return this.tableauDateProduit;
    }

    public void setTableauDateProduit(VelocityVar tableauDateProduit) {
        this.tableauDateProduit = tableauDateProduit;
    }

    public VelocityVar getListeDateProduit() {
        return this.listeDateProduit;
    }

    public void setListeDateProduit(VelocityVar listeDateProduit) {
        this.listeDateProduit = listeDateProduit;
    }

    public VelocityVar getListeDateProduitCompact() {
        return this.listeDateProduitCompact;
    }

    public void setListeDateProduitCompact(VelocityVar listeDateProduitCompact) {
        this.listeDateProduitCompact = listeDateProduitCompact;
    }

    public VelocityVar getMontantProduit() {
        return this.montantProduit;
    }

    public void setMontantProduit(VelocityVar montantProduit) {
        this.montantProduit = montantProduit;
    }

    public VelocityVar getMontantCheque() {
        return this.montantCheque;
    }

    public void setMontantCheque(VelocityVar montantCheque) {
        this.montantCheque = montantCheque;
    }

    public VelocityVar getMontantAvoir() {
        return this.montantAvoir;
    }

    public void setMontantAvoir(VelocityVar montantAvoir) {
        this.montantAvoir = montantAvoir;
    }

    public VelocityVar getAmapienNbLivraison() {
        return this.amapienNbLivraison;
    }

    public void setAmapienNbLivraison(VelocityVar amapienNbLivraison) {
        this.amapienNbLivraison = amapienNbLivraison;
    }

    public VelocityVar getAmapienNbProduit() {
        return this.amapienNbProduit;
    }

    public void setAmapienNbProduit(VelocityVar amapienNbProduit) {
        this.amapienNbProduit = amapienNbProduit;
    }

    public VelocityVar getTableauDateCheque() {
        return this.tableauDateCheque;
    }

    public void setTableauDateCheque(VelocityVar tableauDateCheque) {
        this.tableauDateCheque = tableauDateCheque;
    }

    public VelocityVar getListeDateCheque() {
        return this.listeDateCheque;
    }

    public void setListeDateCheque(VelocityVar listeDateCheque) {
        this.listeDateCheque = listeDateCheque;
    }

    public VelocityVar getListeDateChequeCompact() {
        return this.listeDateChequeCompact;
    }

    public void setListeDateChequeCompact(VelocityVar listeDateChequeCompact) {
        this.listeDateChequeCompact = listeDateChequeCompact;
    }

    public String getDateFinInscription() {
        return this.dateFinInscription;
    }

    public void setDateFinInscription(String dateFinInscription) {
        this.dateFinInscription = dateFinInscription;
    }

    public String getDateRemiseCheque() {
        return this.dateRemiseCheque;
    }

    public void setDateRemiseCheque(String dateRemiseCheque) {
        this.dateRemiseCheque = dateRemiseCheque;
    }

    public VelocityVar getJokerNbMax() {
        return this.jokerNbMax;
    }

    public void setJokerNbMax(VelocityVar jokerNbMax) {
        this.jokerNbMax = jokerNbMax;
    }

    public VelocityVar getJokerNbMin() {
        return this.jokerNbMin;
    }

    public void setJokerNbMin(VelocityVar jokerNbMin) {
        this.jokerNbMin = jokerNbMin;
    }

    public VelocityVar getJokerTxt() {
        return this.jokerTxt;
    }

    public void setJokerTxt(VelocityVar jokerTxt) {
        this.jokerTxt = jokerTxt;
    }

    public String getSignatureAmapien() {
        return this.signatureAmapien;
    }

    public void setSignatureAmapien(String signatureAmapien) {
        this.signatureAmapien = signatureAmapien;
    }

    public String getSignatureProducteur() {
        return this.signatureProducteur;
    }

    public void setSignatureProducteur(String signatureProducteur) {
        this.signatureProducteur = signatureProducteur;
    }

    public VelocityVar getTableauOrListeDateProduit() {
        return this.tableauOrListeDateProduit;
    }

    public void setTableauOrListeDateProduit(VelocityVar tableauOrListeDateProduit) {
        this.tableauOrListeDateProduit = tableauOrListeDateProduit;
    }

    public VelocityVar getTableauDateProduitCompact() {
        return this.tableauDateProduitCompact;
    }

    public void setTableauDateProduitCompact(VelocityVar tableauDateProduitCompact) {
        this.tableauDateProduitCompact = tableauDateProduitCompact;
    }

    public static enum Mode {
        STANDARD,
        VIERGE,
        EN_SIGNATURE;

    }
}

