/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.editionspe;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.GzipUtils;
import fr.amapj.common.LongUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.DbWrite;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.editionspe.AbstractEditionSpeJson;
import fr.amapj.model.models.editionspe.EditionSpecifique;
import fr.amapj.model.models.editionspe.TypEditionSpecifique;
import fr.amapj.model.models.editionspe.adhesion.BulletinAdhesionJson;
import fr.amapj.model.models.editionspe.bilanlivraison.BilanLivraisonJson;
import fr.amapj.model.models.editionspe.emargement.FeuilleEmargementJson;
import fr.amapj.model.models.editionspe.engagement.EngagementJson;
import fr.amapj.model.models.editionspe.etiquette.EtiquetteProducteurJson;
import fr.amapj.service.services.editionspe.EditionSpeDTO;
import fr.amapj.view.engine.popup.suppressionpopup.UnableToSuppressException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Query;

public class EditionSpeService {
    @DbRead
    public boolean needPlanningMensuel() {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Query q = em.createQuery("select count(p) from EditionSpecifique p WHERE p.typEditionSpecifique=:e");
            q.setParameter("e", (Object)TypEditionSpecifique.FEUILLE_EMARGEMENT);
            boolean bl = LongUtils.toInt(q.getSingleResult()) > 0;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return bl;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public boolean needEtiquette(Long idModeleContrat) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, idModeleContrat);
            boolean bl = mc.producteur.etiquette != null;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return bl;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public boolean ficheProducteurNeedEtiquette() {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Query q = em.createQuery("select count(p) from EditionSpecifique p WHERE p.typEditionSpecifique=:e");
            q.setParameter("e", (Object)TypEditionSpecifique.ETIQUETTE_PRODUCTEUR);
            boolean bl = LongUtils.toInt(q.getSingleResult()) > 0;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return bl;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public boolean fichePeriodeNeedBulletinAdhesion() {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Query q = em.createQuery("select count(p) from EditionSpecifique p WHERE p.typEditionSpecifique=:e");
            q.setParameter("e", (Object)TypEditionSpecifique.BULLETIN_ADHESION);
            boolean bl = LongUtils.toInt(q.getSingleResult()) > 0;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return bl;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public List<EditionSpeDTO> getAllEtiquettes() {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ArrayList<EditionSpeDTO> res = new ArrayList<EditionSpeDTO>();
            Query q = em.createQuery("select p from EditionSpecifique p");
            List ps = q.getResultList();
            for (EditionSpecifique p : ps) {
                EditionSpeDTO dto = this.createEtiquetteDTO(em, p);
                res.add(dto);
            }
            ArrayList<EditionSpeDTO> arrayList = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return arrayList;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private EditionSpeDTO createEtiquetteDTO(RdbLink em, EditionSpecifique p) {
        EditionSpeDTO dto = new EditionSpeDTO();
        dto.id = p.getId();
        dto.nom = p.nom;
        dto.typEditionSpecifique = p.typEditionSpecifique;
        return dto;
    }

    @DbWrite
    public Long update(AbstractEditionSpeJson speJson, boolean create) {
        try {
            EditionSpecifique p;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            if (create) {
                TypEditionSpecifique typEditionSpecifique = this.findTypEditionSpecifique(speJson);
                p = new EditionSpecifique();
                p.typEditionSpecifique = typEditionSpecifique;
            } else {
                p = em.find(EditionSpecifique.class, speJson.getId());
            }
            p.nom = speJson.getNom();
            Gson gson = new GsonBuilder().disableHtmlEscaping().create();
            String content = gson.toJson((Object)speJson);
            p.content = GzipUtils.compress(content);
            if (create) {
                em.persist(p);
            }
            Long l = p.id;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return l;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbWrite
    public void delete(Long id) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            EditionSpecifique p = em.find(EditionSpecifique.class, id);
            String str = this.getContrat(p, em);
            if (str != null) {
                throw new UnableToSuppressException("Cette \u00e9dition sp\u00e9cifique  est utilis\u00e9e par les contrats suivants :" + str);
            }
            em.remove(p);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    private String getContrat(EditionSpecifique e, RdbLink em) {
        em.createQuery("select p.nom from ModeleContrat p WHERE p.engagement=:e");
        em.setParameter("e", e);
        return em.result().asStringOrNull();
    }

    @DbRead
    public List<EditionSpecifique> getEtiquetteByType(TypEditionSpecifique typEditionSpecifique) {
        try {
            List ps;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Query q = em.createQuery("select p from EditionSpecifique p where p.typEditionSpecifique=:e ");
            q.setParameter("e", (Object)typEditionSpecifique);
            List list = ps = q.getResultList();
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return list;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbWrite
    public void dupliquer(EditionSpeDTO dto) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            EditionSpecifique to = new EditionSpecifique();
            to.nom = dto.nom;
            EditionSpecifique from = em.find(EditionSpecifique.class, dto.id);
            to.content = from.content;
            to.typEditionSpecifique = from.typEditionSpecifique;
            em.persist(to);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbRead
    public AbstractEditionSpeJson load(Long id) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            EditionSpecifique editionSpecifique = em.find(EditionSpecifique.class, id);
            Class<? extends AbstractEditionSpeJson> clazz = this.findClazz(editionSpecifique.typEditionSpecifique);
            String content = GzipUtils.uncompress(editionSpecifique.content);
            AbstractEditionSpeJson etiquetteDTO = (AbstractEditionSpeJson)new Gson().fromJson(content, clazz);
            etiquetteDTO.setId(editionSpecifique.id);
            etiquetteDTO.setNom(editionSpecifique.nom);
            AbstractEditionSpeJson abstractEditionSpeJson = etiquetteDTO;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return abstractEditionSpeJson;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private Class<? extends AbstractEditionSpeJson> findClazz(TypEditionSpecifique typ) {
        switch (typ) {
            case ETIQUETTE_PRODUCTEUR: {
                return EtiquetteProducteurJson.class;
            }
            case FEUILLE_EMARGEMENT: {
                return FeuilleEmargementJson.class;
            }
            case CONTRAT_ENGAGEMENT: {
                return EngagementJson.class;
            }
            case BULLETIN_ADHESION: {
                return BulletinAdhesionJson.class;
            }
            case BILAN_LIVRAISON: {
                return BilanLivraisonJson.class;
            }
        }
        throw new AmapjRuntimeException("Type non pris en compte");
    }

    private TypEditionSpecifique findTypEditionSpecifique(AbstractEditionSpeJson speJson) {
        if (speJson instanceof EtiquetteProducteurJson) {
            return TypEditionSpecifique.ETIQUETTE_PRODUCTEUR;
        }
        if (speJson instanceof FeuilleEmargementJson) {
            return TypEditionSpecifique.FEUILLE_EMARGEMENT;
        }
        if (speJson instanceof EngagementJson) {
            return TypEditionSpecifique.CONTRAT_ENGAGEMENT;
        }
        if (speJson instanceof BulletinAdhesionJson) {
            return TypEditionSpecifique.BULLETIN_ADHESION;
        }
        if (speJson instanceof BilanLivraisonJson) {
            return TypEditionSpecifique.BILAN_LIVRAISON;
        }
        throw new AmapjRuntimeException();
    }
}

