/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.gestioncontrat;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.CollectionUtils;
import fr.amapj.common.DateUtils;
import fr.amapj.common.SQLUtils;
import fr.amapj.model.engine.IdentifiableUtil;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.DbWrite;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.contrat.modele.EtatModeleContrat;
import fr.amapj.model.models.contrat.modele.GestionPaiement;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.modele.ModeleContratDate;
import fr.amapj.model.models.contrat.modele.ModeleContratDatePaiement;
import fr.amapj.model.models.contrat.modele.ModeleContratExclude;
import fr.amapj.model.models.contrat.modele.ModeleContratProduit;
import fr.amapj.model.models.contrat.reel.ContratCell;
import fr.amapj.model.models.cotisation.PeriodeCotisation;
import fr.amapj.model.models.editionspe.EditionSpecifique;
import fr.amapj.model.models.fichierbase.Producteur;
import fr.amapj.model.models.fichierbase.Produit;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.engine.tools.DbToDto;
import fr.amapj.service.engine.tools.DtoToDb;
import fr.amapj.service.services.archivage.ArchivageContratService;
import fr.amapj.service.services.archivage.tools.ArchivableState;
import fr.amapj.service.services.docengagement.DocEngagementGeneralService;
import fr.amapj.service.services.gestioncontrat.DateModeleContratDTO;
import fr.amapj.service.services.gestioncontrat.DatePaiementModeleContratDTO;
import fr.amapj.service.services.gestioncontrat.ExtPModeleContratService;
import fr.amapj.service.services.gestioncontrat.LigneContratDTO;
import fr.amapj.service.services.gestioncontrat.ModeleContratDTO;
import fr.amapj.service.services.gestioncontrat.ModeleContratSummaryDTO;
import fr.amapj.service.services.gestioncontrat.datebarree.DateBarreCheckService;
import fr.amapj.service.services.gestioncontratsigne.update.GestionContratSigneUpdateService;
import fr.amapj.service.services.mescontrats.ContratColDTO;
import fr.amapj.service.services.mescontrats.ContratDTO;
import fr.amapj.service.services.mescontrats.ContratLigDTO;
import fr.amapj.service.services.mespaiements.PaiementService;
import fr.amapj.service.services.notification.DeleteNotificationService;
import fr.amapj.service.services.parametres.ParametresArchivageDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.suppressionpopup.UnableToSuppressException;
import fr.amapj.view.views.gestioncontrat.editorpart.FrequenceLivraison;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Query;

public class GestionContratService {
    @DbRead
    public List<ModeleContratSummaryDTO> getModeleContratInfo(EtatModeleContrat ... etats) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Query q = em.createQuery("select mc from ModeleContrat mc WHERE mc.etat IN :etats");
            q.setParameter("etats", Arrays.asList(etats));
            List<ModeleContratSummaryDTO> list = DbToDto.transform(q, mc -> this.createModeleContratInfo(em, (ModeleContrat)mc));
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return list;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    public ModeleContratSummaryDTO createModeleContratInfo(RdbLink em, ModeleContrat mc) {
        ModeleContratSummaryDTO info = new ModeleContratSummaryDTO();
        info.id = mc.getId();
        info.nom = mc.nom;
        info.nomProducteur = mc.producteur.nom;
        info.producteurId = mc.producteur.getId();
        info.finInscription = mc.dateFinInscription;
        info.etat = mc.etat;
        info.periodeCotisationId = IdentifiableUtil.getId(mc.periodeCotisation);
        info.gestionDocEngagement = mc.gestionDocEngagement;
        List<ModeleContratDate> dates = this.getAllDates(em, mc);
        info.nbLivraison = dates.size() - this.getNbDateAnnulees(em, mc);
        info.nbInscrits = this.getNbInscrits(em, mc);
        if (dates.size() >= 1) {
            info.dateDebut = dates.get((int)0).dateLiv;
            info.dateFin = dates.get((int)(dates.size() - 1)).dateLiv;
        }
        info.nbProduit = this.getNbProduit(em, mc);
        return info;
    }

    public DateInfo getDateDebutFin(RdbLink em, ModeleContrat mc) {
        DateInfo di = new DateInfo();
        Query q = em.createQuery("select min(c.dateLiv),max(c.dateLiv),count(c.dateLiv) from ModeleContratDate c WHERE c.modeleContrat=:mc");
        q.setParameter("mc", (Object)mc);
        Object[] res = (Object[])q.getSingleResult();
        di.dateDebut = (Date)res[0];
        di.dateFin = (Date)res[1];
        di.nbDateLivs = SQLUtils.toInt(res[2]);
        return di;
    }

    @DbRead
    public int getNbInscrits(Long mcId) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, mcId);
            int n = this.getNbInscrits(em, mc);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return n;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private int getNbInscrits(RdbLink em, ModeleContrat mc) {
        Query q = em.createQuery("select count(c.id) from Contrat c WHERE c.modeleContrat=:mc");
        q.setParameter("mc", (Object)mc);
        return ((Long)q.getSingleResult()).intValue();
    }

    public int getNbDateAnnulees(RdbLink em, ModeleContrat mc) {
        Query q = em.createQuery("select count(p.id) from ModeleContratExclude p WHERE p.modeleContrat=:mc and p.produit is null");
        q.setParameter("mc", (Object)mc);
        return ((Long)q.getSingleResult()).intValue();
    }

    private int getNbProduit(RdbLink em, ModeleContrat mc) {
        return this.getAllProduit(em, mc).size();
    }

    public List<ModeleContratProduit> getAllProduit(RdbLink em, ModeleContrat mc) {
        Query q = em.createQuery("select mcp from ModeleContratProduit mcp where mcp.modeleContrat=:mc ORDER BY mcp.indx");
        q.setParameter("mc", (Object)mc);
        List prods = q.getResultList();
        return prods;
    }

    public List<ModeleContratDate> getAllDates(RdbLink em, ModeleContrat mc) {
        Query q = em.createQuery("select mcd from ModeleContratDate mcd where mcd.modeleContrat=:mc ORDER BY mcd.dateLiv,mcd.id");
        q.setParameter("mc", (Object)mc);
        List dates = q.getResultList();
        return dates;
    }

    public List<ModeleContratExclude> getAllExcludedDateProduit(RdbLink em, ModeleContrat mc) {
        Query q = em.createQuery("select mce from ModeleContratExclude mce where mce.modeleContrat=:mc");
        q.setParameter("mc", (Object)mc);
        List exclude = q.getResultList();
        return exclude;
    }

    @DbRead
    public List<LigneContratDTO> getInfoProduitModeleContrat(Long idProducteur) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ArrayList<LigneContratDTO> res = new ArrayList<LigneContratDTO>();
            Query q = em.createQuery("select p from Produit p WHERE p.producteur=:producteur order by p.id");
            q.setParameter("producteur", (Object)em.find(Producteur.class, idProducteur));
            List prods = q.getResultList();
            for (Produit prod : prods) {
                LigneContratDTO l = new LigneContratDTO();
                l.prix = new Integer(0);
                l.produitId = prod.getId();
                l.produitNom = prod.nom;
                l.produitConditionnement = prod.conditionnement;
                res.add(l);
            }
            ArrayList<LigneContratDTO> arrayList = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return arrayList;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public ModeleContratDTO loadModeleContrat(Long id) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, id);
            ModeleContratDTO info = new ModeleContratDTO();
            info.id = mc.getId();
            info.nom = mc.nom;
            info.description = mc.description;
            info.producteur = mc.producteur.getId();
            info.dateFinInscription = mc.dateFinInscription;
            info.retardataireAutorise = mc.retardataireAutorise;
            info.gestionPaiement = mc.gestionPaiement;
            info.saisiePaiementModifiable = mc.saisiePaiementModifiable;
            info.saisiePaiementProposition = mc.saisiePaiementProposition;
            info.montantChequeMiniCalculProposition = mc.montantChequeMiniCalculProposition;
            info.saisiePaiementCalculDate = mc.saisiePaiementCalculDate;
            info.strategiePaiement = mc.strategiePaiement;
            info.textPaiement = mc.textPaiement;
            info.affichageMontant = mc.affichageMontant;
            info.libCheque = mc.libCheque;
            info.dateRemiseCheque = mc.dateRemiseCheque;
            info.nature = mc.nature;
            info.cartePrepayeeDelai = mc.cartePrepayeeDelai;
            info.typJoker = mc.typJoker;
            info.jokerNbMin = mc.jokerNbMin;
            info.jokerNbMax = mc.jokerNbMax;
            info.jokerMode = mc.jokerMode;
            info.jokerDelai = mc.jokerDelai;
            info.idPeriodeCotisation = IdentifiableUtil.getId(mc.periodeCotisation);
            info.stockGestion = mc.stockGestion;
            info.stockIdentiqueDate = mc.stockIdentiqueDate;
            info.stockMultiContrat = mc.stockMultiContrat;
            info.idEngagement = IdentifiableUtil.getId(mc.engagement);
            info.gestionDocEngagement = mc.gestionDocEngagement;
            List<ModeleContratDate> dates = this.getAllDates(em, mc);
            for (ModeleContratDate date : dates) {
                DateModeleContratDTO dto = new DateModeleContratDTO();
                dto.dateLiv = date.dateLiv;
                info.dateLivs.add(dto);
            }
            if (dates.size() >= 1) {
                info.dateDebut = dates.get((int)0).dateLiv;
                info.dateFin = dates.get((int)(dates.size() - 1)).dateLiv;
            }
            List<ModeleContratProduit> prods = this.getAllProduit(em, mc);
            for (ModeleContratProduit prod : prods) {
                LigneContratDTO lig = new LigneContratDTO();
                lig.idModeleContratProduit = prod.getId();
                lig.produitId = prod.produit.getId();
                lig.produitNom = prod.produit.nom;
                lig.produitConditionnement = prod.produit.conditionnement;
                lig.prix = prod.prix;
                info.produits.add(lig);
            }
            info.frequence = this.guessFrequence(dates);
            List<ModeleContratDatePaiement> datePaiements = new PaiementService().getAllDatesPaiements(em, mc);
            for (ModeleContratDatePaiement date : datePaiements) {
                DatePaiementModeleContratDTO dto = new DatePaiementModeleContratDTO();
                dto.datePaiement = date.datePaiement;
                info.datePaiements.add(dto);
            }
            ModeleContratDTO modeleContratDTO = info;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return modeleContratDTO;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private FrequenceLivraison guessFrequence(List<ModeleContratDate> dates) {
        if (dates.size() == 0 || dates.size() == 1) {
            return FrequenceLivraison.UNE_SEULE_LIVRAISON;
        }
        int delta = DateUtils.getDeltaDay(dates.get((int)0).dateLiv, dates.get((int)1).dateLiv);
        if (delta == 7) {
            return FrequenceLivraison.UNE_FOIS_PAR_SEMAINE;
        }
        if (delta == 14) {
            return FrequenceLivraison.QUINZE_JOURS;
        }
        return FrequenceLivraison.UNE_FOIS_PAR_MOIS;
    }

    @DbWrite
    public Long saveNewModeleContrat(ModeleContratDTO modeleContrat) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            if (modeleContrat.dateLivs.size() == 0) {
                throw new AmapjRuntimeException("Vous ne pouvez pas cr\u00e9er un contrat avec 0 date de livraison");
            }
            if (modeleContrat.gestionPaiement == GestionPaiement.NON_GERE && modeleContrat.datePaiements.size() != 0) {
                throw new AmapjRuntimeException();
            }
            Producteur p = em.find(Producteur.class, modeleContrat.producteur);
            ModeleContrat mc = new ModeleContrat();
            mc.producteur = p;
            mc.nom = modeleContrat.nom;
            mc.description = modeleContrat.description;
            mc.dateFinInscription = modeleContrat.dateFinInscription;
            mc.retardataireAutorise = modeleContrat.retardataireAutorise;
            mc.nature = modeleContrat.nature;
            mc.cartePrepayeeDelai = modeleContrat.cartePrepayeeDelai;
            mc.typJoker = modeleContrat.typJoker;
            mc.jokerNbMin = modeleContrat.jokerNbMin;
            mc.jokerNbMax = modeleContrat.jokerNbMax;
            mc.jokerMode = modeleContrat.jokerMode;
            mc.jokerDelai = modeleContrat.jokerDelai;
            mc.periodeCotisation = IdentifiableUtil.findIdentifiableFromId(PeriodeCotisation.class, modeleContrat.idPeriodeCotisation, em);
            mc.gestionPaiement = modeleContrat.gestionPaiement;
            mc.textPaiement = modeleContrat.textPaiement;
            mc.affichageMontant = modeleContrat.affichageMontant;
            mc.dateRemiseCheque = modeleContrat.dateRemiseCheque;
            mc.libCheque = modeleContrat.libCheque;
            mc.saisiePaiementModifiable = modeleContrat.saisiePaiementModifiable;
            mc.saisiePaiementProposition = modeleContrat.saisiePaiementProposition;
            mc.montantChequeMiniCalculProposition = modeleContrat.montantChequeMiniCalculProposition;
            mc.strategiePaiement = modeleContrat.strategiePaiement;
            mc.saisiePaiementCalculDate = modeleContrat.saisiePaiementCalculDate;
            mc.stockGestion = modeleContrat.stockGestion;
            mc.stockIdentiqueDate = modeleContrat.stockIdentiqueDate;
            mc.stockMultiContrat = modeleContrat.stockMultiContrat;
            mc.gestionDocEngagement = modeleContrat.gestionDocEngagement;
            mc.engagement = em.findOrNull(EditionSpecifique.class, modeleContrat.idEngagement);
            em.persist(mc);
            for (DateModeleContratDTO date : modeleContrat.dateLivs) {
                ModeleContratDate md = new ModeleContratDate();
                md.modeleContrat = mc;
                md.dateLiv = date.dateLiv;
                em.persist(md);
            }
            List<LigneContratDTO> produits = modeleContrat.getProduits();
            int index = 0;
            for (LigneContratDTO lig : produits) {
                ModeleContratProduit mcp = new ModeleContratProduit();
                mcp.indx = index++;
                mcp.modeleContrat = mc;
                mcp.prix = lig.getPrix();
                mcp.produit = em.find(Produit.class, lig.produitId);
                em.persist(mcp);
            }
            for (DatePaiementModeleContratDTO datePaiement : modeleContrat.datePaiements) {
                ModeleContratDatePaiement md = new ModeleContratDatePaiement();
                md.modeleContrat = mc;
                md.datePaiement = datePaiement.datePaiement;
                em.persist(md);
            }
            new DocEngagementGeneralService().checkSizeAndSignatureDocumentEngagement(em, mc);
            Long l = mc.getId();
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return l;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbWrite
    public void deleteContrat(Long id) throws UnableToSuppressException {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, id);
            int nbInscrits = this.getNbInscrits(em, mc);
            if (nbInscrits > 0) {
                String str = "Vous ne pouvez plus supprimer ce contrat<br/>car " + nbInscrits + " adh\u00e9rents ont d\u00e9j\u00e0 souscrits \u00e0 ce contrat<br/><br/>." + "Si vous souhaitez r\u00e9ellement supprimer ce contrat,<br/>" + "allez tout d'abord dans \"Gestion des contrats sign\u00e9s\", puis vous cliquez sur le bouton \"Supprimer un contrat sign\u00e9\"" + "pour supprimer tous les contrats sign\u00e9s";
                throw new UnableToSuppressException(str);
            }
            this.suppressAllDatesPaiement(em, mc);
            this.deleteAllDateBarreesModeleContrat(em, mc);
            new DeleteNotificationService().deleteAllNotificationDoneModeleContrat(em, mc);
            this.suppressAllDates(em, mc);
            this.suppressAllProduits(em, mc);
            this.suppressStockInfo(em, mc);
            new ExtPModeleContratService().suppressExtendedParameters(em, mc);
            em.remove(mc);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    private void suppressStockInfo(RdbLink em, ModeleContrat mc) {
        Query q = em.createQuery("select pep from ProduitExtendedParam pep where pep.modeleContrat=:mc");
        q.setParameter("mc", (Object)mc);
        SQLUtils.deleteAll(em, q);
    }

    private void suppressAllProduits(RdbLink em, ModeleContrat mc) {
        Query q = em.createQuery("select mcp from ModeleContratProduit mcp where mcp.modeleContrat=:mc");
        q.setParameter("mc", (Object)mc);
        SQLUtils.deleteAll(em, q);
    }

    private void suppressAllDates(RdbLink em, ModeleContrat mc) {
        Query q = em.createQuery("select mcd from ModeleContratDate mcd where mcd.modeleContrat=:mc ORDER BY mcd.dateLiv");
        q.setParameter("mc", (Object)mc);
        SQLUtils.deleteAll(em, q);
    }

    private void suppressAllDatesPaiement(RdbLink em, ModeleContrat mc) {
        Query q = em.createQuery("select d from ModeleContratDatePaiement d WHERE d.modeleContrat=:mc");
        q.setParameter("mc", (Object)mc);
        SQLUtils.deleteAll(em, q);
    }

    @DbWrite
    public void updateEtat(EtatModeleContrat newValue, Long idModeleContrat) {
        try {
            ParametresArchivageDTO param;
            ArchivableState state;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            if (newValue == EtatModeleContrat.ARCHIVE && (state = new ArchivageContratService().computeArchivageState(idModeleContrat, param = new ParametresService().getParametresArchivage())).getStatus() == ArchivableState.AStatus.NON) {
                throw new AmapjRuntimeException("Ce contrat n'est pas archivable : " + CollectionUtils.asStdString(state.nonArchivables, e -> e));
            }
            ModeleContrat mc = em.find(ModeleContrat.class, idModeleContrat);
            mc.etat = newValue;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbWrite
    public void updateEnteteModeleContrat(ModeleContratDTO modeleContrat) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, modeleContrat.id);
            mc.dateFinInscription = modeleContrat.dateFinInscription;
            mc.retardataireAutorise = modeleContrat.retardataireAutorise;
            mc.nom = modeleContrat.nom;
            mc.description = modeleContrat.description;
            mc.cartePrepayeeDelai = modeleContrat.cartePrepayeeDelai;
            mc.nature = modeleContrat.nature;
            mc.periodeCotisation = IdentifiableUtil.findIdentifiableFromId(PeriodeCotisation.class, modeleContrat.idPeriodeCotisation, em);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbWrite
    public void updateDateModeleContrat(ModeleContratDTO modeleContrat) throws OnSaveException {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, modeleContrat.id);
            List newList = modeleContrat.dateLivs.stream().map(e -> e.dateLiv).collect(Collectors.toList());
            if (newList.size() == 0) {
                throw new OnSaveException("Vous ne pouvez pas cr\u00e9er un contrat avec 0 date de livraison");
            }
            List<ModeleContratDate> oldList = this.getAllDates(em, mc);
            DtoToDb.ListDiff<ModeleContratDate, Date, Date> diff = DtoToDb.diffList(oldList, newList, e -> e.dateLiv, e -> e);
            GestionContratSigneUpdateService update = new GestionContratSigneUpdateService();
            for (ModeleContratDate modeleContratDate : diff.toSuppress) {
                update.suppressOneDateLiv(modeleContratDate.getId());
            }
            for (DtoToDb.ElementToAdd elementToAdd : diff.toAdd) {
                update.addOneDateLiv(em, (Date)elementToAdd.dto, mc);
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbWrite
    public void updateDateBarreesModeleContrat(ContratDTO contratDTO) throws OnSaveException {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, contratDTO.modeleContratId);
            this.deleteAllDateBarreesModeleContrat(em, mc);
            int i = 0;
            while (i < contratDTO.contratLigs.size()) {
                ContratLigDTO ligDto = contratDTO.contratLigs.get(i);
                if (contratDTO.isFullExcludedLine(i)) {
                    ModeleContratExclude exclude = new ModeleContratExclude();
                    exclude.modeleContrat = mc;
                    exclude.date = em.find(ModeleContratDate.class, ligDto.modeleContratDateId);
                    exclude.produit = null;
                    em.persist(exclude);
                } else {
                    int j = 0;
                    while (j < contratDTO.contratColumns.size()) {
                        if (contratDTO.cell[i][j].excluded) {
                            ContratColDTO colDto = contratDTO.contratColumns.get(j);
                            ModeleContratExclude exclude = new ModeleContratExclude();
                            exclude.modeleContrat = mc;
                            exclude.date = em.find(ModeleContratDate.class, ligDto.modeleContratDateId);
                            exclude.produit = em.find(ModeleContratProduit.class, colDto.modeleContratProduitId);
                            em.persist(exclude);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            String msg = new DateBarreCheckService().checkCoherenceDateBarreesModeleContrat(mc.id);
            if (msg != null) {
                msg = "Incoh\u00e9rence pour le modele de contrat :" + mc.nom + "\n" + msg;
                throw new OnSaveException(msg);
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    public void deleteAllDateBarreesModeleContrat(RdbLink em, ModeleContrat mc) {
        List<ModeleContratExclude> excludes = this.getAllExcludedDateProduit(em, mc);
        for (ModeleContratExclude exclude : excludes) {
            em.remove(exclude);
        }
    }

    @DbWrite
    public void updateProduitModeleContrat(ModeleContratDTO modeleContrat) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, modeleContrat.id);
            List<ModeleContratProduit> dbList = this.getAllProduit(em, mc);
            List<LigneContratDTO> dtoList = modeleContrat.getProduits();
            if (dtoList.size() == 0) {
                throw new AmapjRuntimeException("Vous ne pouvez pas cr\u00e9er un contrat avec 0 produits");
            }
            DtoToDb.ListDiff<ModeleContratProduit, LigneContratDTO, Long> diff = DtoToDb.diffList(dbList, dtoList, e -> e.produit.getId(), e -> e.produitId);
            GestionContratSigneUpdateService update = new GestionContratSigneUpdateService();
            for (ModeleContratProduit modeleContratProduit : diff.toSuppress) {
                update.suppressOneProduit(modeleContratProduit.getId());
            }
            for (DtoToDb.ElementToAdd elementToAdd : diff.toAdd) {
                update.addOneProduit(em, ((LigneContratDTO)elementToAdd.dto).produitId, ((LigneContratDTO)elementToAdd.dto).prix, elementToAdd.index, mc);
            }
            for (DtoToDb.ElementToUpdate elementToUpdate : diff.toUpdate) {
                update.updateModeleContratProduit(em, ((ModeleContratProduit)elementToUpdate.db).getId(), ((LigneContratDTO)elementToUpdate.dto).prix, elementToUpdate.index);
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbWrite
    public void updateJoker(ModeleContratDTO modeleContrat) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, modeleContrat.id);
            new GestionContratSigneUpdateService().markAllContratAsModified(mc, em);
            mc.typJoker = modeleContrat.typJoker;
            mc.jokerNbMin = modeleContrat.jokerNbMin;
            mc.jokerNbMax = modeleContrat.jokerNbMax;
            mc.jokerMode = modeleContrat.jokerMode;
            mc.jokerDelai = modeleContrat.jokerDelai;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    public int getMontantCommande(RdbLink em, ModeleContrat mc) {
        Query q = em.createQuery("select sum(c.qte*c.modeleContratProduit.prix) from ContratCell c WHERE c.contrat.modeleContrat=:mc");
        q.setParameter("mc", (Object)mc);
        return SQLUtils.toInt(q.getSingleResult());
    }

    public int getMontantAvoir(RdbLink em, ModeleContrat mc) {
        Query q = em.createQuery("select sum(c.montantAvoir) from Contrat c WHERE c.modeleContrat=:mc");
        q.setParameter("mc", (Object)mc);
        return SQLUtils.toInt(q.getSingleResult());
    }

    @DbRead
    public String getDetailContrat(Long modeleContratDateId) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            String msg = "";
            Long user = 0L;
            RdbLink em = RdbLink.get();
            ModeleContratDate mcDate = em.find(ModeleContratDate.class, modeleContratDateId);
            Query q = em.createQuery("select c from ContratCell c WHERE c.modeleContratDate=:mcDate order by c.contrat.utilisateur.nom , c.contrat.utilisateur.prenom , c.modeleContratProduit.indx");
            q.setParameter("mcDate", (Object)mcDate);
            List cells = q.getResultList();
            for (ContratCell cell : cells) {
                int qte = cell.qte;
                Utilisateur u = cell.contrat.utilisateur;
                Produit produit = cell.modeleContratProduit.produit;
                if (!u.getId().equals(user)) {
                    user = u.getId();
                    if (msg.length() != 0) {
                        msg = String.valueOf(msg) + "</ul>";
                    }
                    msg = String.valueOf(msg) + "<b>" + u.nom + " " + u.prenom + "</b><ul>";
                }
                msg = String.valueOf(msg) + "<li>" + qte + " " + produit.nom + " , " + produit.conditionnement + "</li>";
            }
            if (msg.length() != 0) {
                msg = String.valueOf(msg) + "</ul>";
            }
            String string = msg;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return string;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbWrite
    public void updatePeriodeCotisationMasse(List<ModeleContratSummaryDTO> mcs) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            for (ModeleContratSummaryDTO mc : mcs) {
                ModeleContrat m = em.find(ModeleContrat.class, mc.id);
                m.periodeCotisation = IdentifiableUtil.findIdentifiableFromId(PeriodeCotisation.class, mc.periodeCotisationId, em);
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbWrite
    public void updateLimiteQuantiteModeleContrat(ModeleContratDTO dto) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, dto.id);
            mc.stockGestion = dto.stockGestion;
            mc.stockIdentiqueDate = dto.stockIdentiqueDate;
            mc.stockMultiContrat = dto.stockMultiContrat;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbWrite
    public void updateSignatureEnLigne(ModeleContratDTO modeleContrat) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, modeleContrat.id);
            mc.gestionDocEngagement = modeleContrat.gestionDocEngagement;
            mc.engagement = em.findOrNull(EditionSpecifique.class, modeleContrat.idEngagement);
            new DocEngagementGeneralService().checkSizeAndSignatureDocumentEngagement(em, mc);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    public static class DateInfo {
        public Date dateDebut;
        public Date dateFin;
        public int nbDateLivs;
    }
}

