/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.gestioncontrat.datebarree;

import fr.amapj.common.FormatUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.modele.ModeleContratExclude;
import fr.amapj.model.models.contrat.reel.Contrat;
import fr.amapj.model.models.contrat.reel.ContratCell;
import fr.amapj.model.models.fichierbase.Produit;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.TypedQuery;

public class DateBarreCheckService {
    @DbRead
    public String checkCoherenceDateBarreesModeleContrat(Long modeleContratId) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, modeleContratId);
            TypedQuery<ContratCell> q = em.createQuery("select cc from ContratCell cc where cc.contrat.modeleContrat=:mc", ContratCell.class);
            q.setParameter("mc", (Object)mc);
            List cells = q.getResultList();
            String string = this.checkAllCell(cells, em, mc);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return string;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public String checkCoherenceDateBarreesContrat(Long contratId) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Contrat c = em.find(Contrat.class, contratId);
            TypedQuery<ContratCell> q = em.createQuery("select cc from ContratCell cc where cc.contrat=:c", ContratCell.class);
            q.setParameter("c", (Object)c);
            List cells = q.getResultList();
            String string = this.checkAllCell(cells, em, c.modeleContrat);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return string;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private String checkAllCell(List<ContratCell> cells, RdbLink em, ModeleContrat mc) {
        List<ModeleContratExclude> excludeds = new GestionContratService().getAllExcludedDateProduit(em, mc);
        HashSet<String> exclude = new HashSet<String>();
        for (ModeleContratExclude modeleContratExclude : excludeds) {
            String ref = modeleContratExclude.date.id + "_";
            if (modeleContratExclude.produit != null) {
                ref = String.valueOf(ref) + modeleContratExclude.produit.id;
            }
            exclude.add(ref);
        }
        StringBuilder sb = new StringBuilder();
        for (ContratCell cell : cells) {
            String msg = this.checkOneCell(cell, exclude, em);
            if (msg == null) continue;
            sb.append(msg);
            sb.append("\n");
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    private String checkOneCell(ContratCell cell, Set<String> exclude, RdbLink em) {
        String ref = cell.modeleContratDate.id + "_";
        if (exclude.contains(ref)) {
            return this.checkOneCellError(cell, em);
        }
        if (exclude.contains(ref = String.valueOf(ref) + cell.modeleContratProduit.id)) {
            return this.checkOneCellError(cell, em);
        }
        return null;
    }

    private String checkOneCellError(ContratCell cell, RdbLink em) {
        Produit p = cell.modeleContratProduit.produit;
        String libProduit = String.valueOf(p.nom) + "," + p.conditionnement;
        return "L'utilisateur " + cell.contrat.utilisateur.nom + " " + cell.contrat.utilisateur.prenom + " a command\u00e9 \n" + "Date =" + FormatUtils.getStdDate().format(cell.modeleContratDate.dateLiv) + "\n" + "Produit =" + libProduit + "\n" + "Qte=" + cell.qte + "\n" + "Ceci est \u00e0 corriger car ce produit est barr\u00e9 pour cette date";
    }
}

