/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.gestioncontrat.reglesaisie;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.FormatUtils;
import fr.amapj.common.IdContainer;
import fr.amapj.common.StringUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.modele.ModeleContratDate;
import fr.amapj.model.models.contrat.modele.extendparam.reglesaisie.RegleSaisie;
import fr.amapj.model.models.contrat.modele.extendparam.reglesaisie.RegleSaisieModeleContrat;
import fr.amapj.model.models.fichierbase.Produit;
import fr.amapj.model.models.param.ChoixOuiNon;
import fr.amapj.service.engine.tools.DbToDto;
import fr.amapj.service.services.gestioncontrat.ExtPModeleContratService;
import fr.amapj.service.services.gestioncontrat.reglesaisie.RegleSaisieDTO;
import fr.amapj.service.services.gestioncontrat.reglesaisie.RegleSaisieModeleContratDTO;
import fr.amapj.service.services.gestioncontrat.reglesaisie.VerifRegleSaisieModeleContratDTO;
import fr.amapj.service.services.mescontrats.MonContratDTO;
import fr.amapj.view.views.saisiecontrat.SaisieContrat;
import java.text.SimpleDateFormat;
import java.util.stream.Collectors;

public class RegleSaisieModeleContratService {
    @DbRead
    public RegleSaisieModeleContratDTO getRegleSaisieModeleContratDTO(Long idModeleContrat) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, idModeleContrat);
            RegleSaisieModeleContratDTO regleSaisieModeleContratDTO = this.getRegleSaisieModeleContratDTO(em, mc);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return regleSaisieModeleContratDTO;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private RegleSaisieModeleContratDTO getRegleSaisieModeleContratDTO(RdbLink em, ModeleContrat mc) {
        RegleSaisieModeleContratDTO dto = new RegleSaisieModeleContratDTO();
        dto.idModeleContrat = mc.id;
        dto.idProducteur = mc.producteur.id;
        RegleSaisieModeleContrat regleSaisieModeleContrat = new ExtPModeleContratService().loadRegleSaisieModeleContrat(mc.id);
        dto.regleSaisies = DbToDto.convert(regleSaisieModeleContrat.regleSaisies, e -> this.createDto(em, (RegleSaisie)e));
        return dto;
    }

    private RegleSaisieDTO createDto(RdbLink em, RegleSaisie r) {
        RegleSaisieDTO dto = new RegleSaisieDTO();
        dto.produitId = r.produitIds.stream().findFirst().orElse(null);
        dto.produitIds = r.produitIds.stream().map(e -> new IdContainer((Long)e)).collect(Collectors.toList());
        dto.modeleContratDateId = r.modeleContratDateIds.stream().findFirst().orElse(null);
        dto.modeleContratDateIds = r.modeleContratDateIds.stream().map(e -> new IdContainer((Long)e)).collect(Collectors.toList());
        dto.contrainteDate = r.contrainteDate;
        dto.contrainteOperateur = r.contrainteOperateur;
        dto.contrainteProduit = r.contrainteProduit;
        dto.val = r.val;
        dto.libPersonnalise = r.libPersonnalise;
        dto.activateLibPersonnalise = r.libPersonnalise == null ? ChoixOuiNon.NON : ChoixOuiNon.OUI;
        dto.champApplication = r.champApplication;
        dto.libelle = this.getLib(r, em);
        return dto;
    }

    public String getLib(RegleSaisie r, RdbLink em) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.addDate(r, em));
        sb.append(this.addProduit(r, em));
        sb.append(this.addOperateurValeur(r));
        return sb.toString();
    }

    private String addDate(RegleSaisie r, RdbLink em) {
        switch (r.contrainteDate) {
            case POUR_CHAQUE_DATE: {
                return "Pour chaque date de livraison, ";
            }
            case POUR_TOUT_CONTRAT: {
                return "Sur la totalit\u00e9 du contrat, ";
            }
            case POUR_UNE_DATE: {
                return "Pour la date du " + this.computeDate(r, em);
            }
            case POUR_PLUSIEURS_DATES: {
                return "Pour les dates du " + this.computeDate(r, em);
            }
        }
        throw new AmapjRuntimeException();
    }

    private String computeDate(RegleSaisie r, RdbLink em) {
        SimpleDateFormat df = FormatUtils.getStdDate();
        StringBuilder sb = new StringBuilder();
        for (Long idDate : r.modeleContratDateIds) {
            ModeleContratDate mcd = em.find(ModeleContratDate.class, idDate);
            sb.append(df.format(mcd.dateLiv));
            sb.append(", ");
        }
        return sb.toString();
    }

    private String addProduit(RegleSaisie r, RdbLink em) {
        switch (r.contrainteProduit) {
            case POUR_UN_PRODUIT: {
                return "la quantit\u00e9 command\u00e9e du produit :" + this.computeProduit(r, em);
            }
            case POUR_PLUSIEURS_PRODUITS: {
                return "la somme des quantit\u00e9s command\u00e9es des produits :" + this.computeProduit(r, em);
            }
            case POUR_TOUS_PRODUITS: {
                return "la quantit\u00e9 command\u00e9e globale (tous produits confondus) ";
            }
        }
        throw new AmapjRuntimeException();
    }

    private String computeProduit(RegleSaisie r, RdbLink em) {
        StringBuilder sb = new StringBuilder();
        sb.append("<ul>");
        for (Long idProduit : r.produitIds) {
            Produit p = em.find(Produit.class, idProduit);
            sb.append("<li>" + this.s(p.nom) + ", " + this.s(p.conditionnement) + "</li>");
        }
        sb.append("</ul>");
        return sb.toString();
    }

    public String s(String value) {
        return StringUtils.s(value);
    }

    private String addOperateurValeur(RegleSaisie r) {
        switch (r.contrainteOperateur) {
            case EGAL: {
                return "doit \u00eatre \u00e9gale \u00e0 " + r.val;
            }
            case INFERIEUR_OU_EGAL: {
                return "doit \u00eatre inf\u00e9rieure ou \u00e9gale \u00e0 " + r.val;
            }
            case SUPERIEUR_OU_EGAL: {
                return "doit \u00eatre sup\u00e9rieure ou \u00e9gale \u00e0 " + r.val;
            }
            case MULTIPLE_DE: {
                return "doit \u00eatre un multiple de " + r.val;
            }
        }
        throw new AmapjRuntimeException();
    }

    @DbRead
    public String getLib(RegleSaisieDTO dto) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            RegleSaisie r = this.convertToRegleSaisie(dto);
            String string = this.getLib(r, em);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return string;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    public void saveRegleSaisieModeleContrat(RegleSaisieModeleContratDTO dto) {
        RegleSaisieModeleContrat rsmc = new RegleSaisieModeleContrat();
        for (RegleSaisieDTO rs : dto.regleSaisies) {
            rsmc.regleSaisies.add(this.convertToRegleSaisie(rs));
        }
        new ExtPModeleContratService().saveRegleSaisieModeleContrat(dto.idModeleContrat, rsmc);
    }

    private RegleSaisie convertToRegleSaisie(RegleSaisieDTO src) {
        RegleSaisie dest = new RegleSaisie();
        switch (src.contrainteProduit) {
            case POUR_TOUS_PRODUITS: {
                break;
            }
            case POUR_UN_PRODUIT: {
                dest.produitIds.add(src.produitId);
                break;
            }
            case POUR_PLUSIEURS_PRODUITS: {
                dest.produitIds.addAll(src.produitIds.stream().map(e -> e.id).collect(Collectors.toList()));
                break;
            }
            default: {
                throw new AmapjRuntimeException();
            }
        }
        switch (src.contrainteDate) {
            case POUR_CHAQUE_DATE: 
            case POUR_TOUT_CONTRAT: {
                break;
            }
            case POUR_UNE_DATE: {
                dest.modeleContratDateIds.add(src.modeleContratDateId);
                break;
            }
            case POUR_PLUSIEURS_DATES: {
                dest.modeleContratDateIds.addAll(src.modeleContratDateIds.stream().map(e -> e.id).collect(Collectors.toList()));
                break;
            }
            default: {
                throw new AmapjRuntimeException();
            }
        }
        dest.contrainteDate = src.contrainteDate;
        dest.contrainteOperateur = src.contrainteOperateur;
        dest.contrainteProduit = src.contrainteProduit;
        dest.val = src.val;
        dest.champApplication = src.champApplication;
        dest.libPersonnalise = src.activateLibPersonnalise == ChoixOuiNon.NON ? null : src.libPersonnalise;
        return dest;
    }

    public void insertInfoVerifSaisie(RdbLink em, ModeleContrat mc, MonContratDTO m, SaisieContrat.ModeSaisie modeSaisie) {
        if (mc.regleSaisieModeleContrat == null) {
            return;
        }
        m.verifRegleSaisieDTO = new VerifRegleSaisieModeleContratDTO();
        m.verifRegleSaisieDTO.contratDTO = m.contratDTO;
        m.verifRegleSaisieDTO.modeSaisie = modeSaisie;
        m.verifRegleSaisieDTO.regleSaisies = this.getRegleSaisieModeleContratDTO((RdbLink)em, (ModeleContrat)mc).regleSaisies;
    }
}

