/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.gestioncontratsigne;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.CollectionUtils;
import fr.amapj.common.DateUtils;
import fr.amapj.common.FormatUtils;
import fr.amapj.common.GenericUtils;
import fr.amapj.common.LongUtils;
import fr.amapj.common.SQLUtils;
import fr.amapj.common.collections.G1D;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.DbWrite;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.contrat.modele.EtatModeleContrat;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.modele.ModeleContratDate;
import fr.amapj.model.models.contrat.modele.ModeleContratExclude;
import fr.amapj.model.models.contrat.modele.ModeleContratProduit;
import fr.amapj.model.models.contrat.reel.Contrat;
import fr.amapj.model.models.contrat.reel.ContratCell;
import fr.amapj.model.models.contrat.reel.EtatPaiement;
import fr.amapj.model.models.fichierbase.EtatUtilisateur;
import fr.amapj.model.models.fichierbase.Produit;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.model.models.param.paramecran.PEGestionContratsSignes;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.gestioncontrat.LigneContratDTO;
import fr.amapj.service.services.gestioncontrat.ModeleContratDTO;
import fr.amapj.service.services.gestioncontratsigne.AnnulationDateLivraisonDTO;
import fr.amapj.service.services.gestioncontratsigne.ContratSigneDTO;
import fr.amapj.service.services.gestioncontratsigne.DeplacerDateLivraisonDTO;
import fr.amapj.service.services.gestioncontratsigne.InfoBarrerProduitDTO;
import fr.amapj.service.services.gestioncontratsigne.suivimodification.SuiviModificationContrat;
import fr.amapj.service.services.gestioncontratsigne.update.GestionContratSigneUpdateService;
import fr.amapj.service.services.mescontrats.ContratCellDTO;
import fr.amapj.service.services.mescontrats.ContratColDTO;
import fr.amapj.service.services.mescontrats.ContratDTO;
import fr.amapj.service.services.mescontrats.ContratLigDTO;
import fr.amapj.service.services.mescontrats.MesContratsService;
import fr.amapj.service.services.utilisateur.util.UtilisateurUtil;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.widgets.CurrencyTextFieldConverter;
import fr.amapj.view.views.saisiecontrat.abo.ContratAbo;
import fr.amapj.view.views.saisiecontrat.step1qte.abo.ContratAboManager;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

public class GestionContratSigneService {
    @DbRead
    public List<ContratSigneDTO> getAllContratSigne(Long idModeleContrat) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, idModeleContrat);
            ArrayList<ContratSigneDTO> res = new ArrayList<ContratSigneDTO>();
            Query q = em.createQuery("select c from Contrat c where c.modeleContrat=:mc order by c.utilisateur.nom, c.utilisateur.prenom");
            q.setParameter("mc", (Object)mc);
            List mcs = q.getResultList();
            for (Contrat contrat : mcs) {
                ContratSigneDTO mcInfo = this.createContratSigneInfo(em, contrat);
                res.add(mcInfo);
            }
            ArrayList<ContratSigneDTO> arrayList = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return arrayList;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    public ContratSigneDTO createContratSigneInfo(RdbLink em, Contrat contrat) {
        ContratSigneDTO info = new ContratSigneDTO();
        info.nomUtilisateur = contrat.utilisateur.nom;
        info.prenomUtilisateur = contrat.utilisateur.prenom;
        info.idUtilisateur = contrat.utilisateur.getId();
        info.idContrat = contrat.getId();
        info.idModeleContrat = contrat.modeleContrat.getId();
        info.dateCreation = contrat.dateCreation;
        info.dateModification = contrat.dateModification;
        info.mntCommande = this.getMontant(em, contrat);
        info.nbChequePromis = this.getNbCheque(em, contrat, EtatPaiement.A_FOURNIR);
        info.nbChequeRecus = this.getNbCheque(em, contrat, EtatPaiement.AMAP);
        info.nbChequeRemis = this.getNbCheque(em, contrat, EtatPaiement.PRODUCTEUR);
        int mntChequeRemis = this.getMontantChequeRemis(em, contrat);
        info.mntAvoirInitial = contrat.montantAvoir;
        info.mntSolde = info.mntAvoirInitial + mntChequeRemis - info.mntCommande;
        info.typInscriptionContrat = contrat.typInscriptionContrat;
        return info;
    }

    private int getMontantChequeRemis(RdbLink em, Contrat contrat) {
        Query q = em.createQuery("select sum(p.montant) from Paiement p WHERE p.etat=:etat and p.contrat=:c");
        q.setParameter("c", (Object)contrat);
        q.setParameter("etat", (Object)EtatPaiement.PRODUCTEUR);
        return LongUtils.toInt(q.getSingleResult());
    }

    private int getNbCheque(RdbLink em, Contrat contrat, EtatPaiement etatPaiement) {
        Query q = em.createQuery("select count(p) from Paiement p WHERE p.etat=:etat and p.contrat=:c");
        q.setParameter("etat", (Object)etatPaiement);
        q.setParameter("c", (Object)contrat);
        return ((Long)q.getSingleResult()).intValue();
    }

    public int getMontant(RdbLink em, Contrat contrat) {
        Query q = em.createQuery("select sum(c.qte * c.modeleContratProduit.prix) from ContratCell c WHERE c.contrat=:contrat");
        q.setParameter("contrat", (Object)contrat);
        return SQLUtils.toInt(q.getSingleResult());
    }

    @DbRead
    public List<ModeleContrat> getModeleContratCreationOrActif(Long idProducteur) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Query q = em.createQuery("select max(mcd.dateLiv),mcd.modeleContrat from ModeleContratDate mcd  where mcd.modeleContrat.producteur.id=:id and mcd.modeleContrat.etat !=:etat  GROUP BY mcd.modeleContrat ORDER BY max(mcd.dateLiv) desc , mcd.modeleContrat.id desc");
            q.setParameter("id", (Object)idProducteur);
            q.setParameter("etat", (Object)EtatModeleContrat.ARCHIVE);
            List mcs = q.getResultList();
            List<ModeleContrat> list = CollectionUtils.select(mcs, e -> (ModeleContrat)e[1]);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return list;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public List<Utilisateur> getUtilisateurSansContrat(Long idModeleContrat, PEGestionContratsSignes.GestionAjoutContrat gestionAjoutContrat) {
        try {
            List<Utilisateur> list;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, idModeleContrat);
            switch (gestionAjoutContrat) {
                case ACTIF_ET_COTISANT: {
                    if (mc.periodeCotisation == null) {
                        list = this.getAllUtilisateurActifSansContrat(em, mc);
                        break;
                    }
                    list = this.getAllUtilisateurCotisantSansContrat(em, mc);
                    break;
                }
                case ACTIF: {
                    list = this.getAllUtilisateurActifSansContrat(em, mc);
                    break;
                }
                case TOUS: {
                    em.createQuery("select u from Utilisateur u WHERE NOT EXISTS (select c from Contrat c where c.utilisateur = u and c.modeleContrat=:mc) ORDER BY u.nom,u.prenom");
                    em.setParameter("mc", mc);
                    list = em.result().list(Utilisateur.class);
                    break;
                }
                default: {
                    throw new AmapjRuntimeException();
                }
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return list;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private List<Utilisateur> getAllUtilisateurActifSansContrat(RdbLink em, ModeleContrat mc) {
        em.createQuery("select u from Utilisateur u WHERE u.etatUtilisateur=:etat AND NOT EXISTS (select c from Contrat c where c.utilisateur = u and c.modeleContrat=:mc) ORDER BY u.nom,u.prenom");
        em.setParameter("etat", (Object)EtatUtilisateur.ACTIF);
        em.setParameter("mc", mc);
        return em.result().list(Utilisateur.class);
    }

    private List<Utilisateur> getAllUtilisateurCotisantSansContrat(RdbLink em, ModeleContrat mc) {
        em.createQuery("select u from Utilisateur u WHERE  u.etatUtilisateur=:etat AND  NOT EXISTS (select c from Contrat c where c.utilisateur = u and c.modeleContrat=:mc) AND  EXISTS     ( select pcu from PeriodeCotisationUtilisateur pcu where pcu.utilisateur = u and pcu.periodeCotisation=:pc)  ORDER BY u.nom,u.prenom");
        em.setParameter("etat", (Object)EtatUtilisateur.ACTIF);
        em.setParameter("mc", mc);
        em.setParameter("pc", mc.periodeCotisation);
        return em.result().list(Utilisateur.class);
    }

    public List<ContratSigneDTO> getAvoirsInfo(RdbLink em, Long idModeleContrat) {
        ModeleContrat mc = em.find(ModeleContrat.class, idModeleContrat);
        ArrayList<ContratSigneDTO> res = new ArrayList<ContratSigneDTO>();
        Query q = em.createQuery("select c from Contrat c where c.modeleContrat=:mc and  c.montantAvoir>0 order by c.utilisateur.nom, c.utilisateur.prenom");
        q.setParameter("mc", (Object)mc);
        List mcs = q.getResultList();
        for (Contrat contrat : mcs) {
            ContratSigneDTO mcInfo = this.createAvoirInfo(em, contrat);
            res.add(mcInfo);
        }
        return res;
    }

    public ContratSigneDTO createAvoirInfo(RdbLink em, Contrat contrat) {
        ContratSigneDTO info = new ContratSigneDTO();
        info.nomUtilisateur = contrat.utilisateur.nom;
        info.prenomUtilisateur = contrat.utilisateur.prenom;
        info.mntAvoirInitial = contrat.montantAvoir;
        return info;
    }

    @DbRead
    public AnnulationDateLivraisonDTO getAnnulationDateLivraisonDTO(Long mcId) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            AnnulationDateLivraisonDTO dto = new AnnulationDateLivraisonDTO();
            dto.mcId = mcId;
            ModeleContrat mc = em.find(ModeleContrat.class, mcId);
            List<ModeleContratDate> dates = new GestionContratService().getAllDates(em, mc);
            for (ModeleContratDate modeleContratDate : dates) {
                if (!modeleContratDate.dateLiv.after(DateUtils.getDate())) continue;
                dto.dateDebut = modeleContratDate.dateLiv;
                break;
            }
            if (dto.dateDebut != null && dates.size() >= 1) {
                dto.dateFin = dates.get((int)(dates.size() - 1)).dateLiv;
            }
            AnnulationDateLivraisonDTO annulationDateLivraisonDTO = dto;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return annulationDateLivraisonDTO;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public ResBarrerDate getAnnulationInfo(AnnulationDateLivraisonDTO annulationDto) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            StringBuffer buf = new StringBuffer();
            ModeleContrat mc = em.find(ModeleContrat.class, annulationDto.mcId);
            Query q = em.createQuery("select d from ModeleContratDate d where  d.modeleContrat=:mc and  d.dateLiv >= :debut and  d.dateLiv <= :fin");
            q.setParameter("mc", (Object)mc);
            q.setParameter("debut", (Object)annulationDto.dateDebut);
            q.setParameter("fin", (Object)annulationDto.dateFin);
            List mcds = q.getResultList();
            SimpleDateFormat df = new SimpleDateFormat("EEEEE dd MMMMM yyyy");
            buf.append("Les quantit\u00e9s des " + mcds.size() + " dates de livraisons suivantes vont \u00eatre mises \u00e0 z\u00e9ro:<br/>");
            for (ModeleContratDate modeleContratDate : mcds) {
                buf.append(" - " + df.format(modeleContratDate.dateLiv) + "<br/>");
            }
            buf.append("<br/>");
            q = em.createQuery("select sum(c.qte),c.modeleContratProduit from ContratCell c where  c.contrat.modeleContrat=:mc and  c.modeleContratDate.dateLiv >= :debut and  c.modeleContratDate.dateLiv <= :fin  group by c.modeleContratProduit  order by c.modeleContratProduit.indx");
            q.setParameter("mc", (Object)mc);
            q.setParameter("debut", (Object)annulationDto.dateDebut);
            q.setParameter("fin", (Object)annulationDto.dateFin);
            List qtes = q.getResultList();
            buf.append("Les quantit\u00e9s suivantes vont \u00eatre mises \u00e0 z\u00e9ro: ( " + qtes.size() + " produits)<br/>");
            for (Object[] qte : qtes) {
                Produit prod = ((ModeleContratProduit)qte[1]).produit;
                buf.append(" - " + qte[0] + " " + prod.nom + " , " + prod.conditionnement + "<br/>");
            }
            buf.append("<br/>");
            q = em.createQuery("select distinct(c.contrat.utilisateur) from ContratCell c where  c.contrat.modeleContrat=:mc and  c.modeleContratDate.dateLiv >= :debut and  c.modeleContratDate.dateLiv <= :fin  order by c.contrat.utilisateur.nom, c.contrat.utilisateur.prenom");
            q.setParameter("mc", (Object)mc);
            q.setParameter("debut", (Object)annulationDto.dateDebut);
            q.setParameter("fin", (Object)annulationDto.dateFin);
            List utilisateurs = q.getResultList();
            buf.append(UtilisateurUtil.getUtilisateurImpactes(utilisateurs));
            ResBarrerDate resBarrerDate = new ResBarrerDate();
            resBarrerDate.msg = buf.toString();
            resBarrerDate.idModeleContratDates = CollectionUtils.select(mcds, e -> e.getId());
            ResBarrerDate resBarrerDate2 = resBarrerDate;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return resBarrerDate2;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbWrite
    public void performAnnulationDateLivraison(AnnulationDateLivraisonDTO annulationDto, ResBarrerDate resBarrerDate) throws OnSaveException {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, annulationDto.mcId);
            Query q = em.createQuery("select c from ContratCell c where  c.contrat.modeleContrat=:mc and  c.modeleContratDate.dateLiv >= :debut and  c.modeleContratDate.dateLiv <= :fin");
            q.setParameter("mc", (Object)mc);
            q.setParameter("debut", (Object)annulationDto.dateDebut);
            q.setParameter("fin", (Object)annulationDto.dateFin);
            List mcs = q.getResultList();
            Date now = DateUtils.getDate();
            for (ContratCell contratCell : mcs) {
                contratCell.contrat.dateModification = now;
                em.remove(contratCell);
            }
            ContratDTO contratDTO = new MesContratsService().loadContrat(annulationDto.mcId, null);
            for (Long idModeleContratDate : resBarrerDate.idModeleContratDates) {
                int index = CollectionUtils.findIndex(contratDTO.contratLigs, e -> e.modeleContratDateId == idModeleContratDate);
                int nbCol = contratDTO.contratColumns.size();
                int j = 0;
                while (j < nbCol) {
                    contratDTO.cell[index][j].excluded = true;
                    ++j;
                }
            }
            new GestionContratService().updateDateBarreesModeleContrat(contratDTO);
            String details = resBarrerDate.msg;
            SuiviModificationContrat.logModification("Barrer une ou plusieurs dates de livraison", mc, details);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbRead
    public List<String> getAllMails(Long idModeleContrat) {
        try {
            List mails;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, idModeleContrat);
            Query q = em.createQuery("select c.utilisateur.email from Contrat c WHERE c.modeleContrat=:mc ORDER BY c.utilisateur.nom, c.utilisateur.prenom");
            q.setParameter("mc", (Object)mc);
            List list = mails = q.getResultList();
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return list;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public List<Utilisateur> getAllUtilisateur(Long idModeleContrat) {
        try {
            List mails;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, idModeleContrat);
            Query q = em.createQuery("select c.utilisateur from Contrat c WHERE c.modeleContrat=:mc ORDER BY c.utilisateur.nom, c.utilisateur.prenom");
            q.setParameter("mc", (Object)mc);
            List list = mails = q.getResultList();
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return list;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public DeplacerDateLivraisonDTO getDeplacerDateLivraisonDTO(Long mcId) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            DeplacerDateLivraisonDTO dto = new DeplacerDateLivraisonDTO();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, mcId);
            List<ModeleContratDate> mcds = new GestionContratService().getAllDates(em, mc);
            for (ModeleContratDate mcd : mcds) {
                DeplacerDateLivraisonDTO.ModifDateLivraisonDTO mdl = new DeplacerDateLivraisonDTO.ModifDateLivraisonDTO();
                mdl.dateLiv = mcd.dateLiv;
                mdl.idModeleContratDate = mcd.getId();
                dto.dateLivraisonDTOs.add(mdl);
            }
            DeplacerDateLivraisonDTO deplacerDateLivraisonDTO = dto;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return deplacerDateLivraisonDTO;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbWrite
    public void performDeplacerDateLivraison(DeplacerDateLivraisonDTO deplacerDto) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            ModeleContratDate mcd = em.find(ModeleContratDate.class, deplacerDto.selected.idModeleContratDate);
            mcd.dateLiv = deplacerDto.actualDate;
            new GestionContratSigneUpdateService().markAllContratAsModified(mcd.modeleContrat, em);
            String details = "La date " + FormatUtils.getStdDate().format(deplacerDto.selected.dateLiv) + " est d\u00e9plac\u00e9e au " + FormatUtils.getStdDate().format(deplacerDto.actualDate);
            SuiviModificationContrat.logModification("D\u00e9placer une date de livraison", mcd.modeleContrat, details);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbRead
    public String getDeplacerInfo(Long idModeleContratDate) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ModeleContratDate mcd = em.find(ModeleContratDate.class, idModeleContratDate);
            Query q = em.createQuery("select distinct(c.contrat.utilisateur) from ContratCell c where  c.modeleContratDate = :mcd  order by c.contrat.utilisateur.nom, c.contrat.utilisateur.prenom");
            q.setParameter("mcd", (Object)mcd);
            List utilisateurs = q.getResultList();
            String string = UtilisateurUtil.getUtilisateurImpactes(utilisateurs);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return string;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public String getModifPrixInfo(ModeleContratDTO modeleContrat) {
        try {
            String string;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            StringBuffer buf1 = new StringBuffer();
            ArrayList<Long> mcps = new ArrayList<Long>();
            CurrencyTextFieldConverter ctc = new CurrencyTextFieldConverter();
            for (LigneContratDTO lig : modeleContrat.produits) {
                ModeleContratProduit mcp = em.find(ModeleContratProduit.class, lig.idModeleContratProduit);
                if (mcp.prix == lig.prix) continue;
                buf1.append("<li>Le prix du \"" + mcp.produit.nom + "," + mcp.produit.conditionnement + "\" passe de " + ctc.convertToString(mcp.prix) + " \u20ac \u00e0  " + ctc.convertToString(lig.prix) + " \u20ac</li>");
                mcps.add(mcp.getId());
            }
            StringBuffer buf = new StringBuffer();
            if (mcps.size() == 0) {
                buf.append("Aucun prix n'a \u00e9t\u00e9 modifi\u00e9.");
                string = buf.toString();
            } else {
                buf.append("Les prix de " + mcps.size() + " produits ont \u00e9t\u00e9 modifi\u00e9s.<br/>Voici le d\u00e9tail des modifications :<ul>");
                buf.append(buf1);
                buf.append("</ul><br/><br/>");
                Query q = em.createQuery("select distinct(c.contrat.utilisateur) from ContratCell c where  c.modeleContratProduit.id IN :mcps  order by c.contrat.utilisateur.nom, c.contrat.utilisateur.prenom");
                q.setParameter("mcps", mcps);
                List utilisateurs = q.getResultList();
                buf.append(UtilisateurUtil.getUtilisateurImpactes(utilisateurs));
                string = buf.toString();
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return string;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbWrite
    public void performModifPrix(ModeleContratDTO modeleContrat) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, modeleContrat.id);
            new GestionContratSigneUpdateService().markAllContratAsModified(mc, em);
            for (LigneContratDTO lig : modeleContrat.produits) {
                ModeleContratProduit mcp = em.find(ModeleContratProduit.class, lig.idModeleContratProduit);
                mcp.prix = lig.prix;
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbRead
    public List<Produit> getProduitHorsContrat(Long idModeleContrat) {
        try {
            List us;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, idModeleContrat);
            Query q = em.createQuery("select p from Produit p WHERE p.producteur=:prod and NOT EXISTS (select mcp from ModeleContratProduit mcp where mcp.produit = p and mcp.modeleContrat=:mc) ORDER BY p.nom,p.conditionnement");
            q.setParameter("mc", (Object)mc);
            q.setParameter("prod", (Object)mc.producteur);
            List list = us = q.getResultList();
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return list;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbWrite
    public void performAjoutProduit(ModeleContratDTO modeleContrat) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, modeleContrat.id);
            new GestionContratSigneUpdateService().markAllContratAsModified(mc, em);
            Query q = em.createQuery("select max(mcp.indx) from ModeleContratProduit mcp WHERE mcp.modeleContrat=:mc");
            q.setParameter("mc", (Object)mc);
            int index = SQLUtils.toInt(q.getSingleResult()) + 1;
            for (LigneContratDTO lig : modeleContrat.getProduits()) {
                ModeleContratProduit mcp = new ModeleContratProduit();
                mcp.indx = index++;
                mcp.modeleContrat = mc;
                mcp.prix = lig.getPrix();
                mcp.produit = em.find(Produit.class, lig.produitId);
                em.persist(mcp);
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbRead
    public String getSuppressProduitInfo(Long idModeleContrat, List<Long> modeleContratProduitsToSuppress) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            StringBuffer buf = new StringBuffer();
            buf.append(" " + modeleContratProduitsToSuppress.size() + " produits vont \u00eatre supprim\u00e9s.<br/>Voici la liste des produits supprim\u00e9s :<ul>");
            for (Long idModeleContratProduit : modeleContratProduitsToSuppress) {
                ModeleContratProduit mcp = em.find(ModeleContratProduit.class, idModeleContratProduit);
                Produit produit = mcp.produit;
                buf.append("<li>" + produit.nom + "," + produit.conditionnement + "</li>");
            }
            buf.append("</ul><br/>");
            Query q = em.createQuery("select distinct(c.contrat.utilisateur) from ContratCell c where  c.modeleContratProduit.id IN :ps  order by c.contrat.utilisateur.nom, c.contrat.utilisateur.prenom");
            q.setParameter("ps", modeleContratProduitsToSuppress);
            List utilisateurs = q.getResultList();
            buf.append(UtilisateurUtil.getUtilisateurImpactes(utilisateurs));
            String string = buf.toString();
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return string;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbWrite
    public void performSupressProduit(Long idModeleContrat, List<Long> modeleContratProduitsToSuppress) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, idModeleContrat);
            new GestionContratSigneUpdateService().markAllContratAsModified(mc, em);
            for (Long mcpId : modeleContratProduitsToSuppress) {
                ModeleContratProduit mcp = em.find(ModeleContratProduit.class, mcpId);
                Query q = em.createQuery("select cc from ContratCell cc where cc.modeleContratProduit=:mcp");
                q.setParameter("mcp", (Object)mcp);
                List ccs = q.getResultList();
                for (ContratCell contratCell : ccs) {
                    em.remove(contratCell);
                }
                q = em.createQuery("select mce from ModeleContratExclude mce where mce.produit=:mcp");
                q.setParameter("mcp", (Object)mcp);
                List mces = q.getResultList();
                for (ModeleContratExclude mce : mces) {
                    em.remove(mce);
                }
                em.remove(mcp);
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbWrite
    public void performModifProduitOrdreContrat(ModeleContratDTO modeleContrat) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, modeleContrat.id);
            new GestionContratSigneUpdateService().markAllContratAsModified(mc, em);
            int index = 0;
            for (LigneContratDTO lig : modeleContrat.getProduits()) {
                ModeleContratProduit mcp = em.find(ModeleContratProduit.class, lig.idModeleContratProduit);
                mcp.indx = index++;
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbRead
    public ResBarrerProduit getBarrerProduitInfo(ContratDTO newContratDTO) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            StringBuffer buf = new StringBuffer();
            ContratDTO oldContratDTO = new MesContratsService().loadContrat(newContratDTO.modeleContratId, null);
            InfoBarrerProduitDTO infos = this.compareGrilleBarre(oldContratDTO.cell, newContratDTO.cell, newContratDTO, em);
            buf.append(infos.computeStringInfo());
            buf.append("<br/>");
            List<ContratCell> toDelete = this.getAllContratCellToDelete(infos.cellChanges, em);
            buf.append(this.computeQteMiseAzero(toDelete));
            buf.append("<br/>");
            List<Utilisateur> utilisateurs = CollectionUtils.selectDistinct(toDelete, e -> e.contrat.utilisateur);
            CollectionUtils.sort(utilisateurs, e -> e.nom, e -> e.prenom);
            buf.append(UtilisateurUtil.getUtilisateurImpactes(utilisateurs));
            ResBarrerProduit res = new ResBarrerProduit();
            res.msg = buf.toString();
            res.idContratCellToDeletes = CollectionUtils.select(toDelete, e -> e.getId());
            ResBarrerProduit resBarrerProduit = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return resBarrerProduit;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private List<ContratCell> getAllContratCellToDelete(List<InfoBarrerProduitDTO.CellChange> cellChanges, RdbLink em) {
        ArrayList<ContratCell> res = new ArrayList<ContratCell>();
        for (InfoBarrerProduitDTO.CellChange cellChange : cellChanges) {
            Query q = em.createQuery("select c from ContratCell c where  c.modeleContratProduit.id =:mcpid and  c.modeleContratDate.id =:mcdid");
            q.setParameter("mcpid", (Object)cellChange.modeleContratProduit.getId());
            q.setParameter("mcdid", (Object)cellChange.modeleContratDate.getId());
            res.addAll(q.getResultList());
        }
        return res;
    }

    private String computeQteMiseAzero(List<ContratCell> toDelete) {
        G1D<Produit, ContratCell> c1 = new G1D<Produit, ContratCell>();
        c1.fill(toDelete);
        c1.groupBy(e -> e.modeleContratProduit.produit);
        c1.sortLigAdvanced(e -> e.modeleContratProduit.indx, true);
        c1.compute();
        List produits = c1.getKeys();
        StringBuilder buf = new StringBuilder();
        buf.append("Les quantit\u00e9s suivantes vont \u00eatre mises \u00e0 z\u00e9ro: ( " + produits.size() + " produits)<br/>");
        int i = 0;
        while (i < produits.size()) {
            Produit prod = (Produit)produits.get(i);
            List cells = c1.getCell(i);
            int qte = CollectionUtils.accumulateInt(cells, e -> e.qte);
            buf.append(" - " + qte + " " + prod.nom + " , " + prod.conditionnement + "<br/>");
            ++i;
        }
        buf.append("<br/>");
        return buf.toString();
    }

    private InfoBarrerProduitDTO compareGrilleBarre(ContratCellDTO[][] oldC, ContratCellDTO[][] newC, ContratDTO contratDTO, RdbLink em) {
        InfoBarrerProduitDTO info = new InfoBarrerProduitDTO();
        int nbLig = contratDTO.contratLigs.size();
        int nbCol = contratDTO.contratColumns.size();
        int j = 0;
        while (j < nbCol) {
            ContratColDTO col = contratDTO.contratColumns.get(j);
            int i = 0;
            while (i < nbLig) {
                ContratLigDTO lig = contratDTO.contratLigs.get(i);
                this.processDiffSate(i, j, oldC, newC, info, col, lig, em);
                ++i;
            }
            ++j;
        }
        return info;
    }

    private void processDiffSate(int i, int j, ContratCellDTO[][] oldC, ContratCellDTO[][] newC, InfoBarrerProduitDTO info, ContratColDTO col, ContratLigDTO lig, RdbLink em) {
        boolean newState;
        boolean oldState = false;
        if (oldC != null) {
            oldState = oldC[i][j].excluded;
        }
        if (oldState == (newState = newC[i][j].excluded)) {
            return;
        }
        ModeleContratDate mcd = em.find(ModeleContratDate.class, lig.modeleContratDateId);
        ModeleContratProduit mcp = em.find(ModeleContratProduit.class, col.modeleContratProduitId);
        if (newState) {
            info.addCellChange(InfoBarrerProduitDTO.DiffState.NO_MORE_DISPO, mcd, mcp);
        } else {
            info.addCellChange(InfoBarrerProduitDTO.DiffState.NOW_DISPO, mcd, mcp);
        }
    }

    @DbWrite
    public void performBarrerProduitInfo(ResBarrerProduit resBarrerProduit, ContratDTO newContratDTO) throws OnSaveException {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            Date now = DateUtils.getDate();
            for (Long idContratCell : resBarrerProduit.idContratCellToDeletes) {
                ContratCell contratCell = em.find(ContratCell.class, idContratCell);
                contratCell.contrat.dateModification = now;
                em.remove(contratCell);
            }
            new GestionContratService().updateDateBarreesModeleContrat(newContratDTO);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbRead
    public String getModifJokerInfo(ModeleContratDTO modeleContrat) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, modeleContrat.id);
            StringBuilder buf = new StringBuilder();
            TypedQuery<Contrat> q = em.createQuery("select c from Contrat c  where c.modeleContrat=:mc order by c.utilisateur.nom, c.utilisateur.prenom", Contrat.class);
            q.setParameter("mc", (Object)mc);
            List cs = q.getResultList();
            ArrayList<Utilisateur> utilisateurs = new ArrayList<Utilisateur>();
            for (Contrat c : cs) {
                String msg = this.isJokerConforme(c, modeleContrat);
                if (msg == null) continue;
                Utilisateur u = c.utilisateur;
                buf.append("Le contrat de " + u.nom + " " + u.prenom + " est non conforme :" + msg + "<br/>");
                utilisateurs.add(u);
            }
            buf.append("<br/><br/>");
            buf.append(UtilisateurUtil.getUtilisateurImpactes(utilisateurs));
            String string = buf.toString();
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return string;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private String isJokerConforme(Contrat c, ModeleContratDTO modeleContrat) {
        ContratDTO dto = new MesContratsService().loadContrat(c.modeleContrat.id, c.getId());
        dto.typJoker = modeleContrat.typJoker;
        dto.jokerNbMin = modeleContrat.jokerNbMin;
        dto.jokerNbMax = modeleContrat.jokerNbMax;
        GenericUtils.Ret<ContratAbo> r = new ContratAboManager().computeContratAboExistingContrat(dto, c.aboInfo);
        if (r.isOK()) {
            return null;
        }
        return r.msg();
    }

    @DbRead
    public boolean checkIfUserHasContrat(Long idModeleContrat, Long userId) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            em.createQuery("select count(c) from Contrat c WHERE c.utilisateur.id=:uId and c.modeleContrat.id=:mId");
            em.setParameter("uId", userId);
            em.setParameter("mId", idModeleContrat);
            boolean bl = em.result().singleInt() > 0;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return bl;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public boolean checkIfUserHasAdhesion(Long idModeleContrat, Long userId) {
        try {
            boolean bl;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, idModeleContrat);
            if (mc.periodeCotisation == null) {
                bl = true;
            } else {
                em.createQuery("select count(pcu) from PeriodeCotisationUtilisateur pcu where pcu.utilisateur.id = :userId and pcu.periodeCotisation=:pc");
                em.setParameter("userId", userId);
                em.setParameter("pc", mc.periodeCotisation);
                bl = em.result().singleInt() > 0;
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return bl;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    public static class ResBarrerDate {
        public String msg;
        public List<Long> idModeleContratDates;
    }

    public static class ResBarrerProduit {
        public String msg;
        public List<Long> idContratCellToDeletes;
    }
}

