/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.gestioncontratsigne.suivimodification;

import fr.amapj.common.DateUtils;
import fr.amapj.common.FormatUtils;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.service.services.mescontrats.ContratDTO;
import fr.amapj.service.services.session.SessionManager;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SuiviModificationContrat {
    private static final Logger logger = LogManager.getLogger();

    public static void logModification(String libOperation, ModeleContrat mc, String details) {
        String fullMessage = "Suivi des modifications sur un contrat \nNature de la modification : " + libOperation + "\n" + "Nom de l'utilisateur qui a fait la modification :" + SessionManager.getSessionParameters().userNom + " " + SessionManager.getSessionParameters().userPrenom + "\n" + "Date et heure de la modification " + FormatUtils.getTimeStd().format(DateUtils.getDate()) + "\n" + "Nom du contrat : " + mc.nom + " id=" + mc.id + "\n" + "Producteur : " + mc.producteur.nom + " id=" + mc.producteur.id + "\n" + "D\u00e9tails :" + details;
        logger.info(fullMessage);
    }

    public static void logModification(String libOperation, ContratDTO c, String details) {
        String fullMessage = "Suivi des modifications sur un contrat \nNature de la modification : " + libOperation + "\n" + "Nom de l'utilisateur qui a fait la modification :" + SessionManager.getSessionParameters().userNom + " " + SessionManager.getSessionParameters().userPrenom + "\n" + "Date et heure de la modification " + FormatUtils.getTimeStd().format(DateUtils.getDate()) + "\n" + "Nom du contrat : " + c.nom + " id=" + c.modeleContratId + "\n" + "D\u00e9tails :" + details;
        logger.info(fullMessage);
    }

    public static <T> String listeDate(List<T> dates, Function<T, Date> f1) {
        SimpleDateFormat df = FormatUtils.getStdDate();
        return dates.stream().map(e -> df.format((Date)f1.apply(e))).collect(Collectors.joining(","));
    }
}

