/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.gestioncontratsigne.update;

import fr.amapj.common.DateUtils;
import fr.amapj.common.SQLUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbWrite;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.modele.ModeleContratDate;
import fr.amapj.model.models.contrat.modele.ModeleContratProduit;
import fr.amapj.model.models.contrat.reel.Contrat;
import fr.amapj.model.models.fichierbase.Produit;
import fr.amapj.service.services.gestioncontrat.DateModeleContratDTO;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.gestioncontrat.ModeleContratDTO;
import fr.amapj.service.services.gestioncontratsigne.suivimodification.SuiviModificationContrat;
import fr.amapj.service.services.mescontrats.ContratLigDTO;
import fr.amapj.service.services.notification.DeleteNotificationService;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import java.util.Date;
import java.util.List;
import javax.persistence.Query;

public class GestionContratSigneUpdateService {
    @DbWrite
    public void addDates(ModeleContratDTO modeleContratDTO) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, modeleContratDTO.id);
            for (DateModeleContratDTO date : modeleContratDTO.dateLivs) {
                this.addOneDateLiv(em, date.dateLiv, mc);
            }
            this.markAllContratAsModified(mc, em);
            String details = "Liste des dates ajout\u00e9es : " + SuiviModificationContrat.listeDate(modeleContratDTO.dateLivs, e -> e.dateLiv);
            SuiviModificationContrat.logModification("Ajouter des dates de livraison", mc, details);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    public void addOneDateLiv(RdbLink em, Date datLiv, ModeleContrat mc) {
        ModeleContratDate md = new ModeleContratDate();
        md.modeleContrat = mc;
        md.dateLiv = datLiv;
        em.persist(md);
    }

    @DbWrite
    public void suppressOneDateLiv(Long idModeleContratDate) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            this.suppressOneDateLiv(em, idModeleContratDate);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    private void suppressOneDateLiv(RdbLink em, Long idModeleContratDate) {
        ModeleContratDate mcd = em.find(ModeleContratDate.class, idModeleContratDate);
        this.deleteAllDateBarrees(em, mcd);
        new DeleteNotificationService().deleteAllNotificationDoneModeleContratDate(em, mcd);
        em.remove(mcd);
    }

    private void deleteAllDateBarrees(RdbLink em, ModeleContratDate mcd) {
        Query q = em.createQuery("select mce from ModeleContratExclude mce WHERE mce.date=:mcd");
        q.setParameter("mcd", (Object)mcd);
        SQLUtils.deleteAll(em, q);
    }

    @DbWrite
    public void suppressOneProduit(Long idModeleContratProduit) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            ModeleContratProduit mcp = em.find(ModeleContratProduit.class, idModeleContratProduit);
            this.deleteAllProduitBarres(em, mcp);
            em.remove(mcp);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    private void deleteAllProduitBarres(RdbLink em, ModeleContratProduit mcp) {
        Query q = em.createQuery("select mce from ModeleContratExclude mce WHERE mce.produit=:mcp");
        q.setParameter("mcp", (Object)mcp);
        SQLUtils.deleteAll(em, q);
    }

    public void addOneProduit(RdbLink em, Long produitId, Integer prix, int index, ModeleContrat mc) {
        ModeleContratProduit mcp = new ModeleContratProduit();
        mcp.indx = index;
        mcp.modeleContrat = mc;
        mcp.prix = prix;
        mcp.produit = em.find(Produit.class, produitId);
        em.persist(mcp);
    }

    public void updateModeleContratProduit(RdbLink em, Long idModeleContratProduit, Integer prix, int index) {
        ModeleContratProduit mcp = em.find(ModeleContratProduit.class, idModeleContratProduit);
        mcp.indx = index;
        mcp.prix = prix;
    }

    @DbWrite
    public void suppressManyDateLivs(List<ContratLigDTO> dateToSuppress, Long idModeleContrat) throws OnSaveException {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, idModeleContrat);
            this.markAllContratAsModified(mc, em);
            for (ContratLigDTO contratLigDTO : dateToSuppress) {
                this.suppressOneDateLiv(em, contratLigDTO.modeleContratDateId);
            }
            if (new GestionContratService().getAllDates(em, mc).size() == 0) {
                throw new OnSaveException("Vous ne pouvez pas supprimer toutes les dates d'un contrat");
            }
            String details = "Liste des dates supprim\u00e9es : " + SuiviModificationContrat.listeDate(dateToSuppress, e -> e.date);
            SuiviModificationContrat.logModification("Supprimer une ou plusieurs dates de livraison", mc, details);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    public void markAllContratAsModified(ModeleContrat mc, RdbLink em) {
        Date now = DateUtils.getDate();
        em.createQuery("select c from Contrat c WHERE c.modeleContrat=:mc");
        em.setParameter("mc", mc);
        List<Contrat> cs = em.result().list(Contrat.class);
        for (Contrat contrat : cs) {
            contrat.dateModification = now;
        }
    }
}

