/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.gestioncotisation;

import fr.amapj.common.CollectionUtils;
import fr.amapj.common.DateUtils;
import fr.amapj.common.LongUtils;
import fr.amapj.common.SQLUtils;
import fr.amapj.model.engine.IdentifiableUtil;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.DbWrite;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.cotisation.EtatPaiementAdhesion;
import fr.amapj.model.models.cotisation.PeriodeCotisation;
import fr.amapj.model.models.cotisation.PeriodeCotisationUtilisateur;
import fr.amapj.model.models.editionspe.EditionSpecifique;
import fr.amapj.model.models.fichierbase.EtatUtilisateur;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.engine.tools.DbToDto;
import fr.amapj.service.services.archivage.tools.SuppressionState;
import fr.amapj.service.services.gestioncotisation.BilanAdhesionDTO;
import fr.amapj.service.services.gestioncotisation.PeriodeCotisationDTO;
import fr.amapj.service.services.gestioncotisation.PeriodeCotisationUtilisateurDTO;
import fr.amapj.service.services.parametres.ParametresArchivageDTO;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.suppressionpopup.UnableToSuppressException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GestionCotisationService {
    private static final Logger logger = LogManager.getLogger();

    @DbRead
    public List<PeriodeCotisation> getAllEnCours() {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            TypedQuery<PeriodeCotisation> q = em.createQuery("select p from PeriodeCotisation p WHERE p.dateFin>=:d ORDER BY p.dateFin", PeriodeCotisation.class);
            Date d = DateUtils.getDateWithNoTime();
            q.setParameter("d", (Object)d);
            List list = q.getResultList();
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return list;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public List<PeriodeCotisationDTO> getAll() {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            TypedQuery<PeriodeCotisation> q = em.createQuery("select a from PeriodeCotisation a", PeriodeCotisation.class);
            List<PeriodeCotisationDTO> list = DbToDto.convert(q, e -> this.createPeriodeCotisationDto(em, (PeriodeCotisation)e));
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return list;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public PeriodeCotisationDTO load(Long idPeriodeCotisation) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            PeriodeCotisation a = em.find(PeriodeCotisation.class, idPeriodeCotisation);
            PeriodeCotisationDTO periodeCotisationDTO = this.createPeriodeCotisationDto(em, a);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return periodeCotisationDTO;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    public PeriodeCotisationDTO createPeriodeCotisationDto(RdbLink em, PeriodeCotisation a) {
        PeriodeCotisationDTO dto = new PeriodeCotisationDTO();
        dto.id = a.getId();
        dto.nom = a.nom;
        dto.montantMini = a.montantMini;
        dto.montantConseille = a.montantConseille;
        dto.textPaiement = a.textPaiement;
        dto.libCheque = a.libCheque;
        dto.dateDebut = a.dateDebut;
        dto.dateFin = a.dateFin;
        dto.idBulletinAdhesion = IdentifiableUtil.getId(a.bulletinAdhesion);
        dto.nbAdhesion = this.getNbAdhesion(em, a);
        dto.mntTotalAdhesion = this.getMntTotalAdhesion(em, a);
        dto.nbPaiementDonnes = this.getNbPaiement(em, a, EtatPaiementAdhesion.ENCAISSE);
        dto.nbPaiementARecuperer = this.getNbPaiement(em, a, EtatPaiementAdhesion.A_FOURNIR);
        return dto;
    }

    public PeriodeCotisationUtilisateurDTO createPeriodeCotisationUtilisateurDto(RdbLink em, PeriodeCotisationUtilisateur a) {
        PeriodeCotisationUtilisateurDTO dto = new PeriodeCotisationUtilisateurDTO();
        dto.dateAdhesion = a.dateAdhesion;
        dto.dateReceptionCheque = a.dateReceptionCheque;
        dto.etatPaiementAdhesion = a.etatPaiementAdhesion;
        dto.id = a.getId();
        dto.idUtilisateur = a.utilisateur.getId();
        dto.nomUtilisateur = a.utilisateur.nom;
        dto.prenomUtilisateur = a.utilisateur.prenom;
        dto.montantAdhesion = a.montantAdhesion;
        dto.typePaiementAdhesion = a.typePaiementAdhesion;
        dto.idPeriodeCotisation = a.periodeCotisation.getId();
        dto.periodeNom = a.periodeCotisation.nom;
        dto.periodeDateDebut = a.periodeCotisation.dateDebut;
        dto.periodeDateFin = a.periodeCotisation.dateFin;
        return dto;
    }

    private int getNbAdhesion(RdbLink em, PeriodeCotisation pc) {
        Query q = em.createQuery("select count(p.id) from PeriodeCotisationUtilisateur p WHERE p.periodeCotisation=:pc");
        q.setParameter("pc", (Object)pc);
        return LongUtils.toInt(q.getSingleResult());
    }

    private int getMntTotalAdhesion(RdbLink em, PeriodeCotisation pc) {
        Query q = em.createQuery("select sum(p.montantAdhesion) from PeriodeCotisationUtilisateur p WHERE p.periodeCotisation=:pc");
        q.setParameter("pc", (Object)pc);
        return LongUtils.toInt(q.getSingleResult());
    }

    private int getNbPaiement(RdbLink em, PeriodeCotisation pc, EtatPaiementAdhesion epc) {
        Query q = em.createQuery("select count(p.id) from PeriodeCotisationUtilisateur p WHERE p.periodeCotisation=:pc and p.etatPaiementAdhesion=:epc");
        q.setParameter("pc", (Object)pc);
        q.setParameter("epc", (Object)epc);
        return LongUtils.toInt(q.getSingleResult());
    }

    @DbWrite
    public Long createOrUpdate(PeriodeCotisationDTO dto) throws OnSaveException {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            PeriodeCotisation a = dto.id == null ? new PeriodeCotisation() : em.find(PeriodeCotisation.class, dto.id);
            a.nom = dto.nom;
            a.montantMini = dto.montantMini;
            a.montantConseille = dto.montantConseille;
            a.textPaiement = dto.textPaiement;
            a.libCheque = dto.libCheque;
            a.dateDebut = dto.dateDebut;
            a.dateFin = dto.dateFin;
            a.bulletinAdhesion = IdentifiableUtil.findIdentifiableFromId(EditionSpecifique.class, dto.idBulletinAdhesion, em);
            if (dto.id == null) {
                em.persist(a);
            }
            Long l = a.id;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return l;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbWrite
    public void delete(Long id) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            PeriodeCotisation p = em.find(PeriodeCotisation.class, id);
            int r = this.countPeriodeCotisationUtilisateur(em, p);
            if (r > 0) {
                throw new UnableToSuppressException("Il y a des utilisateurs inscrits sur cette p\u00e9riode de cotisation :  " + r + " inscrits.");
            }
            String str = this.countPeriodeCotisationContrat(em, p);
            if (str != null) {
                throw new UnableToSuppressException("Certains contrats font r\u00e9f\u00e9rence \u00e0 cette p\u00e9riode de cotisation. Noms des contrats : " + str);
            }
            em.remove(p);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    private String countPeriodeCotisationContrat(RdbLink em, PeriodeCotisation p) {
        TypedQuery<ModeleContrat> q = em.createQuery("select mc from ModeleContrat mc WHERE mc.periodeCotisation=:p", ModeleContrat.class);
        q.setParameter("p", (Object)p);
        List ls = q.getResultList();
        if (ls.size() == 0) {
            return null;
        }
        return CollectionUtils.asStdString(ls, e -> e.nom);
    }

    private int countPeriodeCotisationUtilisateur(RdbLink em, PeriodeCotisation p) {
        Query q = em.createQuery("select count(pu) from PeriodeCotisationUtilisateur pu WHERE pu.periodeCotisation=:p");
        q.setParameter("p", (Object)p);
        return LongUtils.toInt(q.getSingleResult());
    }

    @DbRead
    public List<PeriodeCotisationUtilisateurDTO> getPeriodeCotisation(Long idUtilisateur) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            TypedQuery<PeriodeCotisationUtilisateur> q = em.createQuery("select pu from PeriodeCotisationUtilisateur pu WHERE pu.utilisateur.id=:idUtilisateur ORDER BY pu.periodeCotisation.dateFin desc", PeriodeCotisationUtilisateur.class);
            q.setParameter("idUtilisateur", (Object)idUtilisateur);
            List<PeriodeCotisationUtilisateurDTO> list = DbToDto.convert(q, e -> this.createPeriodeCotisationUtilisateurDto(em, (PeriodeCotisationUtilisateur)e));
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return list;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public BilanAdhesionDTO loadBilanAdhesion(Long idPeriodeCotisation) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            BilanAdhesionDTO res = new BilanAdhesionDTO();
            RdbLink em = RdbLink.get();
            PeriodeCotisation p = em.find(PeriodeCotisation.class, idPeriodeCotisation);
            res.periodeCotisationDTO = this.createPeriodeCotisationDto(em, p);
            Query q = em.createQuery("select pu from PeriodeCotisationUtilisateur pu WHERE pu.periodeCotisation=:p order by pu.utilisateur.nom, pu.utilisateur.prenom");
            q.setParameter("p", (Object)p);
            List periodeCotisationUtilisateurs = q.getResultList();
            for (PeriodeCotisationUtilisateur pcu : periodeCotisationUtilisateurs) {
                PeriodeCotisationUtilisateurDTO pcuDTO = this.createPeriodeCotisationUtilisateurDto(em, pcu);
                res.utilisateurDTOs.add(pcuDTO);
            }
            BilanAdhesionDTO bilanAdhesionDTO = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return bilanAdhesionDTO;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public List<Utilisateur> getAllUtilisateurSansAdhesion(Long idPeriodeCotisation) {
        try {
            List us;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Query q = em.createQuery("select u from Utilisateur u where  u.etatUtilisateur=:etat and  u.id not in (select p.utilisateur.id from PeriodeCotisationUtilisateur p where p.periodeCotisation.id=:idPeriode)  order by u.nom,u.prenom");
            q.setParameter("etat", (Object)EtatUtilisateur.ACTIF);
            q.setParameter("idPeriode", (Object)idPeriodeCotisation);
            List list = us = q.getResultList();
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return list;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public List<Utilisateur> getAllUtilisateurAvecAdhesion(Long idPeriodeCotisation) {
        try {
            List us;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            PeriodeCotisation p = em.find(PeriodeCotisation.class, idPeriodeCotisation);
            Query q = em.createQuery("select pu.utilisateur from PeriodeCotisationUtilisateur pu WHERE pu.periodeCotisation=:p  AND  pu.utilisateur.etatUtilisateur=:etat  order by pu.utilisateur.nom, pu.utilisateur.prenom");
            q.setParameter("p", (Object)p);
            q.setParameter("etat", (Object)EtatUtilisateur.ACTIF);
            List list = us = q.getResultList();
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return list;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbWrite
    public void createOrUpdateCotisation(boolean create, PeriodeCotisationUtilisateurDTO dto) {
        try {
            PeriodeCotisationUtilisateur pcu;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            if (!create) {
                pcu = em.find(PeriodeCotisationUtilisateur.class, dto.id);
            } else {
                pcu = new PeriodeCotisationUtilisateur();
                pcu.periodeCotisation = em.find(PeriodeCotisation.class, dto.idPeriodeCotisation);
                pcu.utilisateur = em.find(Utilisateur.class, dto.idUtilisateur);
                pcu.dateAdhesion = DateUtils.getDate();
            }
            pcu.etatPaiementAdhesion = dto.etatPaiementAdhesion;
            pcu.montantAdhesion = dto.montantAdhesion;
            pcu.typePaiementAdhesion = dto.typePaiementAdhesion;
            if (pcu.dateReceptionCheque == null && dto.etatPaiementAdhesion == EtatPaiementAdhesion.ENCAISSE) {
                pcu.dateReceptionCheque = DateUtils.getDate();
            }
            if (create) {
                em.persist(pcu);
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    public String computeSuppressionLib(ParametresArchivageDTO param) {
        String str = "Il est souhaitable de supprimer une p\u00e9riode d'adh\u00e9sion qui remplit les conditions suivantes : <ul><li>la date de fin de cette p\u00e9riode d'adh\u00e9sion est plus vieille que " + param.suppressionPeriodeCotisation + " jours</li>" + "<li>tous les contrats faisant r\u00e9f\u00e9rence \u00e0 cette p\u00e9riode d'adh\u00e9sion ont \u00e9t\u00e9 supprim\u00e9s</li>" + "</ul><br/>";
        return str;
    }

    @DbRead
    public SuppressionState computeSuppressionState(PeriodeCotisationDTO dto, ParametresArchivageDTO param) {
        try {
            PeriodeCotisation p;
            String str;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            SuppressionState res = new SuppressionState();
            Date ref2 = DateUtils.getDateWithNoTime();
            ref2 = DateUtils.addDays(ref2, -param.suppressionPeriodeCotisation);
            if (dto.dateFin.after(ref2)) {
                res.nonSupprimables.add("La date de fin de cette p\u00e9riode d'adh\u00e9sion est trop r\u00e9cente");
            }
            if ((str = this.countPeriodeCotisationContrat(em, p = em.find(PeriodeCotisation.class, dto.id))) != null) {
                res.nonSupprimables.add("Certains contrats font r\u00e9f\u00e9rence \u00e0 cette p\u00e9riode de cotisation. Noms des contrats : " + str);
            }
            SuppressionState suppressionState = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return suppressionState;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    public List<PeriodeCotisationDTO> getAllPeriodeCotisationSupprimables(ParametresArchivageDTO param) {
        List<PeriodeCotisationDTO> ps = this.getAll();
        ArrayList<PeriodeCotisationDTO> res = new ArrayList<PeriodeCotisationDTO>();
        for (PeriodeCotisationDTO p : ps) {
            SuppressionState state = this.computeSuppressionState(p, param);
            if (state.getStatus() != SuppressionState.SStatus.OUI_SANS_RESERVE) continue;
            res.add(p);
        }
        res.sort(Comparator.comparing(e -> e.dateFin));
        return res;
    }

    @DbWrite
    public void deleteWithInscrits(Long id) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            PeriodeCotisation p = em.find(PeriodeCotisation.class, id);
            Query q = em.createQuery("select pu from PeriodeCotisationUtilisateur pu WHERE pu.periodeCotisation=:p");
            q.setParameter("p", (Object)p);
            SQLUtils.deleteAll(em, q);
            em.remove(p);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbRead
    public List<PeriodeCotisationUtilisateurDTO> getAllForAjouterEnMasse(Long idPeriodeCotisation) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            ArrayList<PeriodeCotisationUtilisateurDTO> res = new ArrayList<PeriodeCotisationUtilisateurDTO>();
            List<Utilisateur> us = this.getAllUtilisateurSansAdhesion(idPeriodeCotisation);
            for (Utilisateur u : us) {
                PeriodeCotisationUtilisateurDTO dto = new PeriodeCotisationUtilisateurDTO();
                dto.idUtilisateur = u.id;
                dto.nomUtilisateur = u.nom;
                dto.prenomUtilisateur = u.prenom;
                dto.idPeriodeCotisation = idPeriodeCotisation;
                res.add(dto);
            }
            ArrayList<PeriodeCotisationUtilisateurDTO> arrayList = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return arrayList;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }
}

