/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.historiquecontrats;

import fr.amapj.common.DateUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.reel.Contrat;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.gestioncontrat.ModeleContratSummaryDTO;
import fr.amapj.service.services.gestioncontratsigne.GestionContratSigneService;
import fr.amapj.service.services.historiquecontrats.HistoriqueContratDTO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Query;

public class HistoriqueContratsService {
    @DbRead
    public List<HistoriqueContratDTO> getHistoriqueContrats(Long userId) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            Date now = DateUtils.getDate();
            RdbLink em = RdbLink.get();
            GestionContratSigneService gestionContratSigneService = new GestionContratSigneService();
            ArrayList<HistoriqueContratDTO> res = new ArrayList<HistoriqueContratDTO>();
            Utilisateur user = em.find(Utilisateur.class, userId);
            Query q = em.createQuery("select c from Contrat c WHERE c.utilisateur=:u");
            q.setParameter("u", (Object)user);
            List contrats = q.getResultList();
            for (Contrat contrat : contrats) {
                ModeleContrat mc = contrat.modeleContrat;
                if (!this.isHistorique(contrat, em, now)) continue;
                ModeleContratSummaryDTO summaryDTO = new GestionContratService().createModeleContratInfo(em, mc);
                HistoriqueContratDTO dto = new HistoriqueContratDTO();
                dto.nomContrat = contrat.modeleContrat.nom;
                dto.nomProducteur = contrat.modeleContrat.producteur.nom;
                dto.dateDebut = summaryDTO.dateDebut;
                dto.dateFin = summaryDTO.dateFin;
                dto.dateCreation = contrat.dateCreation;
                dto.dateModification = contrat.dateModification;
                dto.montant = gestionContratSigneService.getMontant(em, contrat);
                dto.idContrat = contrat.getId();
                dto.idModeleContrat = mc.getId();
                dto.idUtilisateur = userId;
                res.add(dto);
            }
            ArrayList<HistoriqueContratDTO> arrayList = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return arrayList;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    public boolean isHistorique(Contrat contrat, RdbLink em, Date now) {
        Query q = em.createQuery("select count(cc) from ContratCell cc WHERE cc.contrat=:c and cc.modeleContratDate.dateLiv>=:d");
        q.setParameter("c", (Object)contrat);
        Date d = DateUtils.suppressTime(now);
        d = DateUtils.addDays(d, -5);
        q.setParameter("d", (Object)d);
        long count = (Long)q.getSingleResult();
        return count == 0L;
    }
}

