/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.importdonnees;

import fr.amapj.common.DateUtils;
import fr.amapj.common.SQLUtils;
import fr.amapj.common.StringUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.DbWrite;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.fichierbase.Producteur;
import fr.amapj.model.models.fichierbase.ProducteurNotificationRetardataire;
import fr.amapj.model.models.fichierbase.ProducteurStockGestion;
import fr.amapj.model.models.fichierbase.Produit;
import fr.amapj.model.models.param.ChoixOuiNon;
import fr.amapj.service.engine.tools.DbToDto;
import fr.amapj.service.services.importdonnees.ImportProduitProducteurDTO;
import fr.amapj.service.services.produit.ProduitService;
import fr.amapj.service.services.web.WebPageDTO;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

public class ImportDonneesService {
    @DbWrite
    public void insertDataProduits(List<ImportProduitProducteurDTO> prods) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            for (ImportProduitProducteurDTO importProduitProducteurDTO : prods) {
                this.insertDataProduits(em, importProduitProducteurDTO);
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    private void insertDataProduits(RdbLink em, ImportProduitProducteurDTO dto) {
        TypedQuery<Producteur> q = em.createQuery("select p from Producteur p WHERE p.nom=:nom", Producteur.class);
        q.setParameter("nom", (Object)dto.producteur);
        Producteur p = SQLUtils.oneOrZero(q);
        if (p == null) {
            p = new Producteur();
            p.nom = dto.producteur;
            p.delaiModifContrat = 3;
            p.feuilleDistributionGrille = ChoixOuiNon.OUI;
            p.feuilleDistributionListe = ChoixOuiNon.NON;
            p.dateCreation = DateUtils.getDate();
            p.gestionStock = ProducteurStockGestion.NON;
            p.notificationRetardataire = ProducteurNotificationRetardataire.NO;
            em.persist(p);
        }
        TypedQuery<Produit> q1 = em.createQuery("select p from Produit p WHERE p.producteur=:producteur AND p.nom=:nom AND p.conditionnement=:conditionnement ", Produit.class);
        q1.setParameter("producteur", (Object)p);
        q1.setParameter("nom", (Object)dto.produit);
        q1.setParameter("conditionnement", (Object)dto.conditionnement);
        Produit pr = SQLUtils.oneOrZero(q1);
        if (pr == null) {
            pr = new Produit();
            pr.conditionnement = dto.conditionnement;
            pr.nom = dto.produit;
            pr.producteur = p;
            em.persist(pr);
        }
        this.processDescription(pr.id, dto.description);
    }

    private void processDescription(Long idProduit, String description) {
        if (description == null || description.trim().length() == 0) {
            return;
        }
        WebPageDTO dto = new WebPageDTO();
        dto.content = StringUtils.s(description);
        new ProduitService().saveWebPage(idProduit, dto);
    }

    @DbRead
    public List<ImportProduitProducteurDTO> getAllProduits() {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Query q = em.createQuery("select p from Produit p order by p.producteur.nom,p.nom,p.conditionnement");
            List<ImportProduitProducteurDTO> list = DbToDto.transform(q, e -> this.createImportProduitProducteurDTO((Produit)e));
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return list;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private ImportProduitProducteurDTO createImportProduitProducteurDTO(Produit prod) {
        ImportProduitProducteurDTO dto = new ImportProduitProducteurDTO();
        dto.producteur = prod.producteur.nom;
        dto.produit = prod.nom;
        dto.conditionnement = prod.conditionnement;
        dto.idProduit = prod.id;
        return dto;
    }

    @DbRead
    public List<ImportProduitProducteurDTO> getAllProduits(Long idProducteur) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Query q = em.createQuery("select p from Produit p where p.producteur.id=:id order by p.producteur.nom,p.nom,p.conditionnement");
            q.setParameter("id", (Object)idProducteur);
            List<ImportProduitProducteurDTO> list = DbToDto.transform(q, e -> this.createImportProduitProducteurDTO((Produit)e));
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return list;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }
}

