/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.listeproducteurreferent;

import fr.amapj.common.CollectionUtils;
import fr.amapj.common.StringUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.fichierbase.EtatProducteur;
import fr.amapj.model.models.fichierbase.Producteur;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.model.models.param.ChoixOuiNon;
import fr.amapj.service.services.listeproducteurreferent.DetailProducteurDTO;
import fr.amapj.service.services.listeproducteurreferent.DetailRequestDTO;
import fr.amapj.service.services.producteur.ProducteurService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.TypedQuery;

public class ListeProducteurReferentService {
    @DbRead
    public List<DetailProducteurDTO> getAllProducteurs(DetailRequestDTO request) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ArrayList<DetailProducteurDTO> res = new ArrayList<DetailProducteurDTO>();
            TypedQuery<Producteur> q = em.createQuery("select p from Producteur p where p.etat = :etat", Producteur.class);
            q.setParameter("etat", (Object)EtatProducteur.ACTIF);
            for (Producteur producteur : q.getResultList()) {
                DetailProducteurDTO dto = this.createDetailProducteurDTO(producteur, request, em);
                res.add(dto);
            }
            CollectionUtils.collatorSort(res, e -> e.nom);
            ArrayList<DetailProducteurDTO> arrayList = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return arrayList;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public DetailProducteurDTO getOneProducteur(Long idProducteur, DetailRequestDTO request) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Producteur p = em.find(Producteur.class, idProducteur);
            DetailProducteurDTO detailProducteurDTO = this.createDetailProducteurDTO(p, request, em);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return detailProducteurDTO;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private DetailProducteurDTO createDetailProducteurDTO(Producteur producteur, DetailRequestDTO request, RdbLink em) {
        DetailProducteurDTO dto = new DetailProducteurDTO();
        dto.nom = producteur.nom;
        dto.description = producteur.description;
        List<Utilisateur> referents = new ProducteurService().getProducteurReferent(em, producteur).stream().map(e -> e.referent).collect(Collectors.toList());
        List<Utilisateur> producteurs = new ProducteurService().getProducteurUtilisateur(em, producteur).stream().map(e -> e.utilisateur).collect(Collectors.toList());
        dto.contacts = "<b>Contacts :</b><br/>" + this.formatProducteur(producteurs, request) + this.formatReferent(referents, request);
        return dto;
    }

    private String formatProducteur(List<Utilisateur> utilisateurs, DetailRequestDTO request) {
        if (utilisateurs.size() == 0) {
            return "";
        }
        String str = CollectionUtils.asString(utilisateurs, " et ", e -> this.formatUtilisateur((Utilisateur)e, detailRequestDTO.producteurEmail, detailRequestDTO.producteurTel1, detailRequestDTO.producteurTel2));
        if (utilisateurs.size() == 1) {
            return "Le producteur est " + this.s(str) + "<br/>";
        }
        return "Les producteurs sont  " + this.s(str) + "<br/>";
    }

    private String formatReferent(List<Utilisateur> utilisateurs, DetailRequestDTO request) {
        if (utilisateurs.size() == 0) {
            return "";
        }
        String str = CollectionUtils.asString(utilisateurs, " et ", e -> this.formatUtilisateur((Utilisateur)e, detailRequestDTO.referentEmail, detailRequestDTO.referentTel1, detailRequestDTO.referentTel2));
        if (utilisateurs.size() == 1) {
            return "Le r\u00e9f\u00e9rent est " + this.s(str) + "<br/>";
        }
        return "Les r\u00e9f\u00e9rents sont  " + this.s(str) + "<br/>";
    }

    private String formatUtilisateur(Utilisateur u, ChoixOuiNon email, ChoixOuiNon tel1, ChoixOuiNon tel2) {
        ArrayList<String> strs = new ArrayList<String>();
        if (email == ChoixOuiNon.OUI && u.email.length() > 3) {
            strs.add("Email : " + u.email);
        }
        if (tel1 == ChoixOuiNon.OUI && u.numTel1 != null && u.numTel1.trim().length() > 2) {
            strs.add("Tel1 : " + u.numTel1);
        }
        if (tel2 == ChoixOuiNon.OUI && u.numTel2 != null && u.numTel2.trim().length() > 2) {
            strs.add("Tel2 : " + u.numTel2);
        }
        if (strs.size() == 0) {
            return String.valueOf(u.prenom) + " " + u.nom;
        }
        return String.valueOf(u.prenom) + " " + u.nom + " (" + CollectionUtils.asString(strs, " ,") + ")";
    }

    private String s(String str) {
        return StringUtils.s(str);
    }
}

