/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.logview;

import com.vaadin.server.StreamResource;
import fr.amapj.common.SequenceFileInputStream;
import fr.amapj.service.services.appinstance.LogAccessDTO;
import fr.amapj.view.engine.ui.AmapJLogManager;
import java.io.InputStream;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class AllLogFileResource
implements StreamResource.StreamSource {
    private Supplier<List<LogAccessDTO>> logFileNameSuppliers;

    public AllLogFileResource(Supplier<List<LogAccessDTO>> logFileNameSuppliers) {
        this.logFileNameSuppliers = logFileNameSuppliers;
    }

    public InputStream getStream() {
        List<LogAccessDTO> logFileNames = this.logFileNameSuppliers.get();
        List<String> fullLogFileNames = logFileNames.stream().sorted(Comparator.comparing(e -> e.dateIn)).map(e -> AmapJLogManager.getFullFileName(e.logFileName)).collect(Collectors.toList());
        return new SequenceFileInputStream(fullLogFileNames);
    }
}

