/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.mailer;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import fr.amapj.common.DateUtils;
import fr.amapj.model.engine.db.DbManager;
import fr.amapj.service.services.parametres.ParametresDTO;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MailerCounter {
    private static final Logger logger = LogManager.getLogger();
    private static final MailerCounter instance = new MailerCounter();
    private LoadingCache<MailKey, MailCount> cache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).build((CacheLoader)new CacheLoader<MailKey, MailCount>(){

        public MailCount load(MailKey key) {
            return new MailCount();
        }
    });

    private MailerCounter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAllowed(ParametresDTO param) {
        MailKey key = new MailKey();
        key.dbName = DbManager.get().getCurrentDb().getDbName();
        key.date = DateUtils.getDateWithNoTime();
        MailCount mailCount = (MailCount)MailerCounter.instance.cache.getUnchecked((Object)key);
        logger.info("Check nb mails " + mailCount.nbMail);
        logger.info("Cache size " + MailerCounter.instance.cache.size());
        if (mailCount.nbMail < param.sendingMailNbMax) {
            MailCount mailCount2 = mailCount;
            synchronized (mailCount2) {
                ++mailCount.nbMail;
            }
            return true;
        }
        return false;
    }

    public static int getNbMails(String dbName) {
        MailKey key = new MailKey();
        key.dbName = dbName;
        key.date = DateUtils.getDateWithNoTime();
        MailCount mailCount = (MailCount)MailerCounter.instance.cache.getIfPresent((Object)key);
        if (mailCount == null) {
            return 0;
        }
        return mailCount.nbMail;
    }

    public static int getNbMails() {
        return MailerCounter.getNbMails(DbManager.get().getCurrentDb().getDbName());
    }

    public static class MailCount {
        public int nbMail;
    }

    public static class MailKey {
        public String dbName;
        public Date date;

        public boolean equals(Object o) {
            MailKey k = (MailKey)o;
            return this.dbName.equals(k.dbName) && this.date.equals(k.date);
        }

        public int hashCode() {
            return this.dbName.hashCode();
        }
    }
}

