/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.mesadhesions;

import fr.amapj.common.CollectorUtils;
import fr.amapj.common.DateUtils;
import fr.amapj.common.SQLUtils;
import fr.amapj.model.engine.IdentifiableUtil;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.DbWrite;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.contrat.reel.Contrat;
import fr.amapj.model.models.cotisation.EtatPaiementAdhesion;
import fr.amapj.model.models.cotisation.PeriodeCotisation;
import fr.amapj.model.models.cotisation.PeriodeCotisationUtilisateur;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.services.gestioncotisation.GestionCotisationService;
import fr.amapj.service.services.mesadhesions.AdhesionDTO;
import fr.amapj.service.services.mesadhesions.MesAdhesionDTO;
import fr.amapj.view.engine.popup.suppressionpopup.UnableToSuppressException;
import java.util.Comparator;
import java.util.List;
import javax.persistence.TypedQuery;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MesAdhesionsService {
    private static final Logger logger = LogManager.getLogger();

    @DbRead
    public MesAdhesionDTO computeAdhesionInfo(Long userId) {
        try {
            AdhesionDTO dto;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Utilisateur user = em.find(Utilisateur.class, userId);
            MesAdhesionDTO mesAdhesionDTO = new MesAdhesionDTO();
            List<PeriodeCotisation> ps = new GestionCotisationService().getAllEnCours();
            logger.debug("Nombre de periodes de cotisation en cours = {} ", (Object)ps.size());
            TypedQuery<PeriodeCotisationUtilisateur> q2 = em.createQuery("select pu from PeriodeCotisationUtilisateur pu WHERE pu.utilisateur=:u", PeriodeCotisationUtilisateur.class);
            q2.setParameter("u", (Object)user);
            List pcus = q2.getResultList();
            for (PeriodeCotisation periodeCotisation : ps) {
                PeriodeCotisationUtilisateur pcu = this.findMatching(periodeCotisation, pcus);
                dto = this.createAdhesionDTO(em, periodeCotisation, pcu, userId);
                if (pcu == null) {
                    mesAdhesionDTO.nouvelles.add(dto);
                    continue;
                }
                mesAdhesionDTO.enCours.add(dto);
            }
            for (PeriodeCotisationUtilisateur pcu : pcus) {
                PeriodeCotisation periodeCotisation = this.findMatching(pcu, ps);
                if (periodeCotisation != null) continue;
                periodeCotisation = em.find(PeriodeCotisation.class, pcu.periodeCotisation.id);
                dto = this.createAdhesionDTO(em, periodeCotisation, pcu, userId);
                mesAdhesionDTO.archives.add(dto);
            }
            mesAdhesionDTO.nouvelles.sort(Comparator.comparing(e -> e.dateFin).reversed());
            mesAdhesionDTO.enCours.sort(Comparator.comparing(e -> e.dateFin).reversed());
            mesAdhesionDTO.archives.sort(Comparator.comparing(e -> e.dateFin).reversed());
            MesAdhesionDTO mesAdhesionDTO2 = mesAdhesionDTO;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return mesAdhesionDTO2;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private PeriodeCotisationUtilisateur findMatching(PeriodeCotisation p, List<PeriodeCotisationUtilisateur> pcus) {
        return (PeriodeCotisationUtilisateur)pcus.stream().filter(e -> e.periodeCotisation.id.equals(periodeCotisation.id)).collect(CollectorUtils.oneOrZero());
    }

    private PeriodeCotisation findMatching(PeriodeCotisationUtilisateur pcu, List<PeriodeCotisation> ps) {
        return (PeriodeCotisation)ps.stream().filter(e -> e.id.equals(periodeCotisationUtilisateur.periodeCotisation.id)).collect(CollectorUtils.oneOrZero());
    }

    private AdhesionDTO createAdhesionDTO(RdbLink em, PeriodeCotisation p, PeriodeCotisationUtilisateur pcu, Long idUtilisateur) {
        AdhesionDTO dto = new AdhesionDTO();
        dto.isModifiable = this.computeIsModifiable(pcu);
        dto.isSupprimable = this.computeIsSupprimable(pcu, em);
        dto.idUtilisateur = idUtilisateur;
        dto.idPeriode = p.id;
        dto.nomPeriode = p.nom;
        dto.montantMini = p.montantMini;
        dto.montantConseille = p.montantConseille;
        dto.dateDebut = p.dateDebut;
        dto.dateFin = p.dateFin;
        dto.libCheque = p.libCheque;
        dto.textPaiement = p.textPaiement;
        if (pcu != null) {
            dto.idPeriodeUtilisateur = pcu.id;
            dto.montantAdhesion = pcu.montantAdhesion;
            dto.etatPaiementAdhesion = pcu.etatPaiementAdhesion;
            dto.typePaiementAdhesion = pcu.typePaiementAdhesion;
        }
        dto.idBulletin = IdentifiableUtil.getId(p.bulletinAdhesion);
        return dto;
    }

    private boolean computeIsModifiable(PeriodeCotisationUtilisateur pcu) {
        if (pcu == null) {
            return false;
        }
        return pcu.etatPaiementAdhesion != EtatPaiementAdhesion.ENCAISSE;
    }

    private boolean computeIsSupprimable(PeriodeCotisationUtilisateur pcu, RdbLink em) {
        if (pcu == null) {
            return false;
        }
        if (pcu.etatPaiementAdhesion == EtatPaiementAdhesion.ENCAISSE) {
            return false;
        }
        TypedQuery<Contrat> q = em.createQuery("select count(c) from Contrat c WHERE c.modeleContrat.periodeCotisation=:p and c.utilisateur=:u", Contrat.class);
        q.setParameter("p", (Object)pcu.periodeCotisation);
        q.setParameter("u", (Object)pcu.utilisateur);
        long nb = SQLUtils.count(q);
        return nb <= 0L;
    }

    @DbWrite
    public void createOrUpdateAdhesion(AdhesionDTO dto, int montant) {
        try {
            PeriodeCotisationUtilisateur pcu;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            if (dto.idPeriodeUtilisateur != null) {
                pcu = em.find(PeriodeCotisationUtilisateur.class, dto.idPeriodeUtilisateur);
            } else {
                pcu = new PeriodeCotisationUtilisateur();
                pcu.periodeCotisation = em.find(PeriodeCotisation.class, dto.idPeriode);
                pcu.utilisateur = em.find(Utilisateur.class, dto.idUtilisateur);
            }
            pcu.dateAdhesion = DateUtils.getDate();
            pcu.montantAdhesion = montant;
            if (dto.idPeriodeUtilisateur == null) {
                em.persist(pcu);
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbWrite
    public void deleteAdhesion(Long idItemToSuppress, boolean isTresorier) throws UnableToSuppressException {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            PeriodeCotisationUtilisateur pcu = em.find(PeriodeCotisationUtilisateur.class, idItemToSuppress);
            if (!isTresorier && !this.computeIsSupprimable(pcu, em)) {
                throw new UnableToSuppressException("Impossible de supprimer cette adhesion");
            }
            em.remove(pcu);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }
}

