/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.mescontrats;

import fr.amapj.common.CollectionUtils;
import fr.amapj.model.models.contrat.modele.GestionDocEngagement;
import fr.amapj.model.models.contrat.modele.JokerMode;
import fr.amapj.model.models.contrat.modele.NatureContrat;
import fr.amapj.model.models.contrat.modele.TypJoker;
import fr.amapj.model.models.contrat.reel.TypInscriptionContrat;
import fr.amapj.service.services.mescontrats.ContratCellDTO;
import fr.amapj.service.services.mescontrats.ContratColDTO;
import fr.amapj.service.services.mescontrats.ContratLigDTO;
import fr.amapj.service.services.mescontrats.DocEngagementDTO;
import fr.amapj.service.services.mescontrats.InfoPaiementDTO;
import fr.amapj.view.engine.grid.integergrid.IntegerGridCell;
import fr.amapj.view.views.saisiecontrat.SaisieContrat;
import fr.amapj.view.views.saisiecontrat.abo.ContratAbo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ContratDTO {
    public Long contratId;
    public Long modeleContratId;
    public String nom;
    public Date dateFinInscription;
    public List<ContratLigDTO> contratLigs = new ArrayList<ContratLigDTO>();
    public List<ContratColDTO> contratColumns = new ArrayList<ContratColDTO>();
    public ContratCellDTO[][] cell;
    public InfoPaiementDTO paiement;
    public NatureContrat nature;
    public TypJoker typJoker;
    public int jokerNbMin = 0;
    public int jokerNbMax = 0;
    public JokerMode jokerMode;
    public int jokerDelai;
    public GestionDocEngagement gestionDocEngagement;
    public DocEngagementDTO docEngagementDTO;
    public ContratAbo contratAbo;
    public TypInscriptionContrat typInscriptionContrat;
    public SaisieContrat.ModeSaisie modeSaisie;

    public boolean isEmpty() {
        int i = 0;
        while (i < this.contratLigs.size()) {
            if (!this.isEmptyLine(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEmptyLine(int i) {
        int j = 0;
        while (j < this.contratColumns.size()) {
            if (this.cell[i][j].qte != 0) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public boolean isEmptyCol(int j) {
        int i = 0;
        while (i < this.contratLigs.size()) {
            if (this.cell[i][j].qte != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getQteTotal() {
        int qte = 0;
        int j = 0;
        while (j < this.contratColumns.size()) {
            int i = 0;
            while (i < this.contratLigs.size()) {
                qte += this.cell[i][j].qte;
                ++i;
            }
            ++j;
        }
        return qte;
    }

    public int getNbLivraisonEffective() {
        int nb = 0;
        int i = 0;
        while (i < this.contratLigs.size()) {
            if (!this.isEmptyLine(i)) {
                ++nb;
            }
            ++i;
        }
        return nb;
    }

    public int getMontantTotal() {
        int mnt = 0;
        int j = 0;
        while (j < this.contratColumns.size()) {
            int prix = this.contratColumns.get((int)j).prix;
            int i = 0;
            while (i < this.contratLigs.size()) {
                mnt += this.cell[i][j].qte * prix;
                ++i;
            }
            ++j;
        }
        return mnt;
    }

    public int getMontantTotalBefore(Date dateRef) {
        if (dateRef == null) {
            return this.getMontantTotal();
        }
        int mnt = 0;
        int i = 0;
        while (i < this.contratLigs.size()) {
            if (this.contratLigs.get((int)i).date.before(dateRef)) {
                int j = 0;
                while (j < this.contratColumns.size()) {
                    int prix = this.contratColumns.get((int)j).prix;
                    mnt += this.cell[i][j].qte * prix;
                    ++j;
                }
            }
            ++i;
        }
        return mnt;
    }

    public int getMontantOf(Date dateRef) {
        if (dateRef == null) {
            return 0;
        }
        int mnt = 0;
        int i = 0;
        while (i < this.contratLigs.size()) {
            if (this.contratLigs.get((int)i).date.equals(dateRef)) {
                int j = 0;
                while (j < this.contratColumns.size()) {
                    int prix = this.contratColumns.get((int)j).prix;
                    mnt += this.cell[i][j].qte * prix;
                    ++j;
                }
            }
            ++i;
        }
        return mnt;
    }

    public boolean isFullExcludedLine(int lineNumber) {
        int j = 0;
        while (j < this.contratColumns.size()) {
            if (!this.cell[lineNumber][j].excluded) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public List<ContratLigDTO> computeDateBarrees() {
        return CollectionUtils.filter(this.contratLigs, e -> this.isFullExcludedLine(e.i));
    }

    public boolean isExcluded(int i, int j) {
        return this.cell[i][j].excluded;
    }

    public boolean hasOneOrMoreExcluded() {
        int j = 0;
        while (j < this.contratColumns.size()) {
            int i = 0;
            while (i < this.contratLigs.size()) {
                if (this.cell[i][j].excluded) {
                    return true;
                }
                ++i;
            }
            ++j;
        }
        return false;
    }

    public boolean[][] extractExcluded() {
        boolean[][] res = new boolean[this.contratLigs.size()][this.contratColumns.size()];
        int j = 0;
        while (j < this.contratColumns.size()) {
            int i = 0;
            while (i < this.contratLigs.size()) {
                res[i][j] = this.cell[i][j].excluded;
                ++i;
            }
            ++j;
        }
        return res;
    }

    public void excludeThisLine(int lineNumber) {
        int j = 0;
        while (j < this.contratColumns.size()) {
            this.cell[lineNumber][j].excluded = true;
            ++j;
        }
    }

    public void enableThisLine(int lineNumber) {
        int j = 0;
        while (j < this.contratColumns.size()) {
            this.cell[lineNumber][j].excluded = false;
            ++j;
        }
    }

    public void copyInExcluded(boolean[][] box) {
        int j = 0;
        while (j < this.contratColumns.size()) {
            int i = 0;
            while (i < this.contratLigs.size()) {
                this.cell[i][j].excluded = box[i][j];
                ++i;
            }
            ++j;
        }
    }

    public int[][] extractQte() {
        int[][] res = new int[this.contratLigs.size()][this.contratColumns.size()];
        int j = 0;
        while (j < this.contratColumns.size()) {
            int i = 0;
            while (i < this.contratLigs.size()) {
                res[i][j] = this.cell[i][j].qte;
                ++i;
            }
            ++j;
        }
        return res;
    }

    public ContratLigDTO findLig(Date date) {
        for (ContratLigDTO lig : this.contratLigs) {
            if (!lig.date.equals(date)) continue;
            return lig;
        }
        return null;
    }

    public IntegerGridCell[][] extractCells() {
        IntegerGridCell[][] res = new IntegerGridCell[this.contratLigs.size()][this.contratColumns.size()];
        int j = 0;
        while (j < this.contratColumns.size()) {
            int prix = this.contratColumns.get((int)j).prix;
            int i = 0;
            while (i < this.contratLigs.size()) {
                IntegerGridCell c = new IntegerGridCell();
                c.qte = this.cell[i][j].qte;
                c.prix = prix;
                if (this.cell[i][j].excluded && c.qte == 0) {
                    c.isStaticText = true;
                    c.staticText = "XXXXXX";
                } else if (!this.cell[i][j].available && c.qte == 0) {
                    c.isStaticText = true;
                    c.staticText = "Non disponible";
                } else {
                    c.isStaticText = false;
                }
                res[i][j] = c;
                ++i;
            }
            ++j;
        }
        return res;
    }

    public boolean isFullNotAvailableLine(int ligIndex) {
        int j = 0;
        while (j < this.contratColumns.size()) {
            if (!this.cell[ligIndex][j].excluded && this.cell[ligIndex][j].available) {
                return false;
            }
            ++j;
        }
        return true;
    }
}

