/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.mescontrats;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.DateUtils;
import fr.amapj.model.models.contrat.modele.JokerMode;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.modele.ModeleContratDate;
import fr.amapj.model.models.contrat.modele.NatureContrat;
import fr.amapj.model.models.contrat.modele.RetardataireAutorise;
import fr.amapj.model.models.contrat.modele.TypJoker;
import fr.amapj.model.models.contrat.reel.Contrat;
import fr.amapj.model.models.contrat.reel.TypInscriptionContrat;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;

public class ContratStatusService {
    public boolean isInscriptionNonTerminee(ModeleContrat modeleContrat, Date now) {
        Date dateFinInscription = modeleContrat.dateFinInscription;
        Date d = DateUtils.addHour(dateFinInscription, 23);
        d = DateUtils.addMinute(d, 59);
        return d.after(now);
    }

    public boolean isDateModifiable(ModeleContratDate mcd, Date now) {
        NatureContrat nature = mcd.modeleContrat.nature;
        switch (nature) {
            case ABONNEMENT: {
                return this.isDateModifiableAbonnement(mcd, now);
            }
            case LIBRE: {
                return this.isDateModifiableLibre(mcd, now);
            }
            case CARTE_PREPAYEE: {
                return this.isDateModifiableCartePrepayee(mcd, now);
            }
        }
        throw new AmapjRuntimeException();
    }

    private boolean isDateModifiableAbonnement(ModeleContratDate mcd, Date now) {
        return this.isDateModifiableAbonnementInscription(mcd, now) || this.isDateModifiableAbonnementJoker(mcd, now) || this.isDateModifiableAbonnementRetardataire(mcd, now);
    }

    private boolean isDateModifiableAbonnementInscription(ModeleContratDate mcd, Date now) {
        return this.isInscriptionNonTerminee(mcd.modeleContrat, now);
    }

    private boolean isDateModifiableAbonnementJoker(ModeleContratDate mcd, Date now) {
        return this.isDateModifiableAbonnementJoker(mcd.dateLiv, now, mcd.modeleContrat);
    }

    public boolean isDateModifiableAbonnementJoker(Date mcd, Date now, ModeleContrat mc) {
        if (mc.typJoker == TypJoker.SANS_JOKER) {
            return false;
        }
        if (mc.jokerMode == JokerMode.INSCRIPTION || mc.jokerNbMax == 0) {
            return false;
        }
        LocalDate limit = DateUtils.asLocalDate(mcd);
        limit = limit.plusDays(-mc.jokerDelai);
        return DateUtils.asLocalDate(now).isBefore(limit);
    }

    private boolean isDateModifiableAbonnementRetardataire(ModeleContratDate mcd, Date now) {
        Date d = DateUtils.addDays(mcd.dateLiv, -mcd.modeleContrat.producteur.delaiModifContrat);
        return d.after(now);
    }

    private boolean isDateModifiableLibre(ModeleContratDate mcd, Date now) {
        return this.isDateModifiableLibreInscription(mcd, now) || this.isDateModifiableLibreRetardataire(mcd, now);
    }

    private boolean isDateModifiableLibreInscription(ModeleContratDate mcd, Date now) {
        return this.isInscriptionNonTerminee(mcd.modeleContrat, now);
    }

    private boolean isDateModifiableLibreRetardataire(ModeleContratDate mcd, Date now) {
        Date d = DateUtils.addDays(mcd.dateLiv, -mcd.modeleContrat.producteur.delaiModifContrat);
        return d.after(now);
    }

    public boolean isDateModifiableCartePrepayee(ModeleContratDate mcd, Date now) {
        int cartePrepayeeDelai = mcd.modeleContrat.cartePrepayeeDelai;
        Date d = DateUtils.addDays(mcd.dateLiv, -cartePrepayeeDelai);
        return d.after(now);
    }

    public boolean isDateModifiableByRetardataire(ModeleContratDate mcd, Date now) {
        if (mcd.modeleContrat.retardataireAutorise == RetardataireAutorise.NON) {
            return false;
        }
        NatureContrat nature = mcd.modeleContrat.nature;
        switch (nature) {
            case ABONNEMENT: {
                return this.isDateModifiableAbonnementRetardataire(mcd, now);
            }
            case LIBRE: {
                return this.isDateModifiableLibreRetardataire(mcd, now);
            }
            case CARTE_PREPAYEE: {
                return false;
            }
        }
        throw new AmapjRuntimeException();
    }

    public boolean isInscriptionRetardatairePossible(ModeleContrat modeleContrat, Date now, List<ModeleContratDate> dates) {
        for (ModeleContratDate modeleContratDate : dates) {
            if (!this.isDateModifiableByRetardataire(modeleContratDate, now)) continue;
            return true;
        }
        return false;
    }

    public boolean isContratRetardataireModifiable(Contrat c, Date now) {
        if (c.typInscriptionContrat == TypInscriptionContrat.STANDARD) {
            return false;
        }
        Date limit = DateUtils.addDays(DateUtils.suppressTime(c.dateCreation), 1);
        return now.before(limit);
    }
}

