/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.mescontrats;

import fr.amapj.common.DateUtils;
import fr.amapj.common.SQLUtils;
import fr.amapj.model.engine.IdentifiableUtil;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.DbWrite;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.modele.ModeleContratDate;
import fr.amapj.model.models.contrat.modele.ModeleContratDatePaiement;
import fr.amapj.model.models.contrat.modele.ModeleContratExclude;
import fr.amapj.model.models.contrat.modele.ModeleContratProduit;
import fr.amapj.model.models.contrat.modele.NatureContrat;
import fr.amapj.model.models.contrat.reel.Contrat;
import fr.amapj.model.models.contrat.reel.ContratCell;
import fr.amapj.model.models.contrat.reel.EtatPaiement;
import fr.amapj.model.models.contrat.reel.Paiement;
import fr.amapj.model.models.cotisation.PeriodeCotisation;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.services.docengagement.signonline.core.CoreDocEngagementSignOnLineService;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.gestioncontrat.datebarree.DateBarreCheckService;
import fr.amapj.service.services.gestioncontrat.reglesaisie.RegleSaisieModeleContratService;
import fr.amapj.service.services.mescontrats.ContratCellDTO;
import fr.amapj.service.services.mescontrats.ContratColDTO;
import fr.amapj.service.services.mescontrats.ContratDTO;
import fr.amapj.service.services.mescontrats.ContratLigDTO;
import fr.amapj.service.services.mescontrats.DatePaiementDTO;
import fr.amapj.service.services.mescontrats.InfoPaiementDTO;
import fr.amapj.service.services.mescontrats.MonContratDTO;
import fr.amapj.service.services.mescontrats.inscription.InscriptionDTO;
import fr.amapj.service.services.mescontrats.inscription.InscriptionService;
import fr.amapj.service.services.producteur.ProducteurService;
import fr.amapj.service.services.remiseproducteur.RemiseProducteurService;
import fr.amapj.service.services.stockservice.verifstock.VerifStockDTO;
import fr.amapj.service.services.stockservice.verifstock.VerifStockService;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.suppressionpopup.UnableToSuppressException;
import fr.amapj.view.engine.widgets.CurrencyTextFieldConverter;
import fr.amapj.view.views.saisiecontrat.SaisieContrat;
import fr.amapj.view.views.saisiecontrat.abo.ContratAboGuesser;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

public class MesContratsService {
    @DbRead
    public MonContratDTO loadMonContratDTO(Long modeleContratId, Long contratId, SaisieContrat.ModeSaisie modeSaisie) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Date now = DateUtils.getDate();
            ModeleContrat mc = em.find(ModeleContrat.class, modeleContratId);
            Contrat contrat = null;
            if (contratId != null) {
                contrat = em.find(Contrat.class, contratId);
            }
            List<ModeleContratDate> dates = new GestionContratService().getAllDates(em, mc);
            MonContratDTO m = new MonContratDTO();
            m.contratDTO = this.buildFullContratDTO(em, mc, contrat, dates);
            new VerifStockService().insertInfoStock(em, mc, m, modeSaisie);
            new RegleSaisieModeleContratService().insertInfoVerifSaisie(em, mc, m, modeSaisie);
            m.inscriptionDTO = new InscriptionDTO();
            new InscriptionService(m.contratDTO, modeSaisie, now, contrat, mc, m.inscriptionDTO).buildInscriptionDTO();
            MonContratDTO monContratDTO = m;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return monContratDTO;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public ContratDTO loadContrat(Long modeleContratId, Long contratId) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, modeleContratId);
            Contrat contrat = null;
            if (contratId != null) {
                contrat = em.find(Contrat.class, contratId);
            }
            List<ModeleContratDate> dates = new GestionContratService().getAllDates(em, mc);
            ContratDTO contratDTO = this.buildFullContratDTO(em, mc, contrat, dates);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return contratDTO;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private ContratDTO buildFullContratDTO(RdbLink em, ModeleContrat mc, Contrat contrat, List<ModeleContratDate> dates) {
        ContratDTO dto = new ContratDTO();
        dto.modeleContratId = mc.getId();
        dto.nom = mc.nom;
        dto.dateFinInscription = mc.dateFinInscription;
        dto.nature = mc.nature;
        dto.typJoker = mc.typJoker;
        dto.jokerNbMin = mc.jokerNbMin;
        dto.jokerNbMax = mc.jokerNbMax;
        dto.jokerMode = mc.jokerMode;
        dto.jokerDelai = mc.jokerDelai;
        List<ModeleContratProduit> prods = new GestionContratService().getAllProduit(em, mc);
        for (ModeleContratProduit prod : prods) {
            ContratColDTO col = new ContratColDTO();
            col.modeleContratProduitId = prod.getId();
            col.nomProduit = prod.produit.nom;
            col.condtionnementProduit = prod.produit.conditionnement;
            col.produitId = prod.produit.id;
            col.prix = prod.prix;
            col.j = dto.contratColumns.size();
            col.produitWebPageId = IdentifiableUtil.getId(prod.produit.webPage);
            dto.contratColumns.add(col);
        }
        for (ModeleContratDate date : dates) {
            ContratLigDTO lig = new ContratLigDTO();
            lig.date = date.dateLiv;
            lig.modeleContratDateId = date.getId();
            lig.i = dto.contratLigs.size();
            dto.contratLigs.add(lig);
        }
        List<ModeleContratExclude> excludeds = new GestionContratService().getAllExcludedDateProduit(em, mc);
        dto.cell = new ContratCellDTO[dto.contratLigs.size()][dto.contratColumns.size()];
        int i = 0;
        while (i < dto.contratLigs.size()) {
            int j = 0;
            while (j < dto.contratColumns.size()) {
                dto.cell[i][j] = new ContratCellDTO();
                dto.cell[i][j].excluded = false;
                dto.cell[i][j].available = true;
                ++j;
            }
            ++i;
        }
        for (ModeleContratExclude exclude : excludeds) {
            this.insertExcluded(dto, exclude.date.getId(), exclude.produit);
        }
        dto.paiement = new InfoPaiementDTO();
        dto.paiement.gestionPaiement = mc.gestionPaiement;
        dto.paiement.saisiePaiementModifiable = mc.saisiePaiementModifiable;
        dto.paiement.saisiePaiementProposition = mc.saisiePaiementProposition;
        dto.paiement.montantChequeMiniCalculProposition = mc.montantChequeMiniCalculProposition;
        dto.paiement.textPaiement = mc.textPaiement;
        dto.paiement.affichageMontant = mc.affichageMontant;
        dto.paiement.libCheque = mc.libCheque;
        dto.paiement.referentsRemiseCheque = new ProducteurService().getReferents(em, mc.producteur);
        List<RemiseProducteurService.ModeleContratDatePaiementInfo> datePaiements = new RemiseProducteurService().getAllDatesPaiementsInfo(em, mc);
        for (RemiseProducteurService.ModeleContratDatePaiementInfo date : datePaiements) {
            DatePaiementDTO lig = new DatePaiementDTO();
            lig.datePaiement = date.modeleContratDatePaiement.datePaiement;
            lig.idModeleContratDatePaiement = date.modeleContratDatePaiement.getId();
            lig.montant = 0;
            lig.etatPaiement = date.remiseDone ? EtatPaiement.PRODUCTEUR : EtatPaiement.A_FOURNIR;
            lig.idPaiement = null;
            dto.paiement.datePaiements.add(lig);
        }
        dto.gestionDocEngagement = mc.gestionDocEngagement;
        if (contrat != null) {
            dto.contratId = contrat.id;
            dto.typInscriptionContrat = contrat.typInscriptionContrat;
            List<ContratCell> qtes = this.getAllQte(em, contrat);
            for (ContratCell qte : qtes) {
                this.insert(dto, qte.modeleContratDate.getId(), qte.modeleContratProduit.getId(), qte.qte);
            }
            dto.paiement.avoirInitial = contrat.montantAvoir;
            for (DatePaiementDTO lig : dto.paiement.datePaiements) {
                Paiement paiement = this.getPaiement(lig.idModeleContratDatePaiement, contrat, em);
                if (paiement == null) continue;
                lig.idPaiement = paiement.getId();
                lig.montant = paiement.montant;
                lig.etatPaiement = paiement.etat;
            }
        }
        return dto;
    }

    private Paiement getPaiement(Long mcdp, Contrat c, RdbLink em) {
        TypedQuery<Paiement> q = em.createQuery("select p from Paiement p WHERE p.contrat=:c and p.modeleContratDatePaiement.id =:mcdp ", Paiement.class);
        q.setParameter("c", (Object)c);
        q.setParameter("mcdp", (Object)mcdp);
        return SQLUtils.oneOrZero(q);
    }

    private void insertExcluded(ContratDTO dto, Long modeleContratDateId, ModeleContratProduit modeleContratProduit) {
        if (modeleContratProduit == null) {
            int lig = this.findLigIndex(dto, modeleContratDateId);
            dto.excludeThisLine(lig);
        } else {
            int lig = this.findLigIndex(dto, modeleContratDateId);
            int col = this.findColIndex(dto, modeleContratProduit.getId());
            dto.cell[lig][col].excluded = true;
        }
    }

    private void insert(ContratDTO dto, Long modeleContratDateId, Long modeleContratProduitId, int qte) {
        int lig = this.findLigIndex(dto, modeleContratDateId);
        int col = this.findColIndex(dto, modeleContratProduitId);
        dto.cell[lig][col].qte = qte;
    }

    private int findLigIndex(ContratDTO dto, Long modeleContratDateId) {
        int index = 0;
        for (ContratLigDTO lig : dto.contratLigs) {
            if (lig.modeleContratDateId.equals(modeleContratDateId)) {
                return index;
            }
            ++index;
        }
        throw new RuntimeException("Erreur inattendue");
    }

    private int findColIndex(ContratDTO dto, Long modeleContratProduitId) {
        int index = 0;
        for (ContratColDTO col : dto.contratColumns) {
            if (col.modeleContratProduitId.equals(modeleContratProduitId)) {
                return index;
            }
            ++index;
        }
        throw new RuntimeException("Erreur inattendue");
    }

    public List<ContratCell> getAllQte(RdbLink em, Contrat c) {
        TypedQuery<ContratCell> q = em.createQuery("select cc from ContratCell cc where cc.contrat=:c", ContratCell.class);
        q.setParameter("c", (Object)c);
        return q.getResultList();
    }

    @DbWrite
    public Long saveNewContrat(ContratDTO contratDTO, Long userId) throws OnSaveException {
        try {
            String msg;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            Date now = DateUtils.getDate();
            if (contratDTO.isEmpty()) {
                throw new OnSaveException("Il est impossible de sauvegarder un contrat vide");
            }
            ModeleContrat mc = em.find(ModeleContrat.class, contratDTO.modeleContratId);
            Contrat c = null;
            if (contratDTO.contratId == null) {
                c = new Contrat();
                c.dateCreation = now;
                c.modeleContrat = mc;
                c.utilisateur = em.find(Utilisateur.class, userId);
                c.typInscriptionContrat = contratDTO.typInscriptionContrat;
                em.persist(c);
            } else {
                c = em.find(Contrat.class, contratDTO.contratId);
                c.dateModification = now;
            }
            ContratCell[][] matrix = this.getAllQteAsMatrix(em, c, contratDTO);
            int nbLigs = contratDTO.contratLigs.size();
            int nbCols = contratDTO.contratColumns.size();
            int i = 0;
            while (i < nbLigs) {
                int j = 0;
                while (j < nbCols) {
                    ContratCell dbCell = matrix[i][j];
                    ContratColDTO colDto = contratDTO.contratColumns.get(j);
                    ContratLigDTO ligDto = contratDTO.contratLigs.get(i);
                    int qteDto = contratDTO.cell[i][j].qte;
                    this.updateCellInDb(em, dbCell, qteDto, ligDto, colDto, c);
                    ++j;
                }
                ++i;
            }
            for (DatePaiementDTO datePaiementDTO : contratDTO.paiement.datePaiements) {
                ModeleContratDatePaiement mcdp = em.find(ModeleContratDatePaiement.class, datePaiementDTO.idModeleContratDatePaiement);
                Paiement p = null;
                if (datePaiementDTO.idPaiement != null) {
                    p = em.find(Paiement.class, datePaiementDTO.idPaiement);
                }
                this.insertPaiement(p, datePaiementDTO, c, mcdp, em, contratDTO);
            }
            if (mc.nature == NatureContrat.ABONNEMENT) {
                c.aboInfo = contratDTO.contratAbo != null ? contratDTO.contratAbo.getAboInfo() : new ContratAboGuesser(contratDTO).guessContratAboInfo();
            }
            if ((msg = new DateBarreCheckService().checkCoherenceDateBarreesContrat(c.id)) != null) {
                throw new OnSaveException(msg);
            }
            VerifStockDTO stockContainer = new VerifStockService().loadVerifStock(em, mc, contratDTO, c.id);
            stockContainer.setQteMe(contratDTO);
            if (!stockContainer.isStockSuffisant()) {
                List<String> ls = new VerifStockService().computePrettyMessage(stockContainer);
                throw new OnSaveException(ls);
            }
            new CoreDocEngagementSignOnLineService().saveDocEngagementSigneByAmapien(contratDTO.docEngagementDTO, c, em, now);
            Long l = c.getId();
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return l;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    private void insertPaiement(Paiement p, DatePaiementDTO datePaiementDTO, Contrat c, ModeleContratDatePaiement mcdp, RdbLink em, ContratDTO contratDTO) throws OnSaveException {
        if (p == null) {
            if (datePaiementDTO.montant != 0) {
                this.checkRemiseNonFaite(mcdp, em);
                p = new Paiement();
                p.contrat = c;
                p.modeleContratDatePaiement = mcdp;
                p.montant = datePaiementDTO.montant;
                em.persist(p);
            }
        } else if (datePaiementDTO.montant != p.montant) {
            if (p.etat == EtatPaiement.PRODUCTEUR) {
                SimpleDateFormat df = new SimpleDateFormat("MMMMM yyyy");
                throw new OnSaveException("La remise des ch\u00e8ques  a \u00e9t\u00e9 faite au producteur pour le mois de " + df.format(p.modeleContratDatePaiement.datePaiement) + ". Vous ne pouvez donc pas modifier le montant du paiement pour cette date");
            }
            if (p.etat == EtatPaiement.AMAP && contratDTO.modeSaisie == SaisieContrat.ModeSaisie.STANDARD) {
                SimpleDateFormat df = new SimpleDateFormat("MMMMM yyyy");
                throw new OnSaveException("Le ch\u00e8que pour le mois de " + df.format(p.modeleContratDatePaiement.datePaiement) + " est marqu\u00e9 comme r\u00e9ceptionn\u00e9 \u00e0 l'AMAP . Vous ne pouvez donc pas modifier le montant du paiement pour cette date");
            }
            if (datePaiementDTO.montant == 0) {
                em.remove(p);
            } else {
                p.montant = datePaiementDTO.montant;
            }
        }
    }

    private void checkRemiseNonFaite(ModeleContratDatePaiement mcdp, RdbLink em) throws OnSaveException {
        Query q = em.createQuery("select r from RemiseProducteur r WHERE r.datePaiement=:mcdp");
        q.setParameter("mcdp", (Object)mcdp);
        List rps = q.getResultList();
        if (rps.size() > 0) {
            SimpleDateFormat df = new SimpleDateFormat("MMMMM yyyy");
            throw new OnSaveException("La remise des ch\u00e8ques  a \u00e9t\u00e9 faite au producteur pour le mois de " + df.format(mcdp.datePaiement) + ". Vous ne devez donc pas mettre de paiement pour cette date");
        }
    }

    private void updateCellInDb(RdbLink em, ContratCell dbCell, int qteDto, ContratLigDTO ligDto, ContratColDTO colDto, Contrat c) {
        if (qteDto == 0) {
            if (dbCell != null) {
                em.remove(dbCell);
            }
        } else if (dbCell == null) {
            ContratCell cl = new ContratCell();
            cl.contrat = c;
            cl.modeleContratDate = em.find(ModeleContratDate.class, ligDto.modeleContratDateId);
            cl.modeleContratProduit = em.find(ModeleContratProduit.class, colDto.modeleContratProduitId);
            cl.qte = qteDto;
            em.persist(cl);
        } else {
            dbCell.qte = qteDto;
        }
    }

    private ContratCell[][] getAllQteAsMatrix(RdbLink em, Contrat c, ContratDTO dto) {
        ContratCell[][] res = new ContratCell[dto.contratLigs.size()][dto.contratColumns.size()];
        List<ContratCell> ligs = this.getAllQte(em, c);
        for (ContratCell lig : ligs) {
            int i = this.getIndexLig(lig, dto);
            int j = this.getIndexCol(lig, dto);
            res[i][j] = lig;
        }
        return res;
    }

    private int getIndexLig(ContratCell lig, ContratDTO contratDTO) {
        int i = 0;
        for (ContratLigDTO dto : contratDTO.contratLigs) {
            if (dto.modeleContratDateId.equals(lig.modeleContratDate.getId())) {
                return i;
            }
            ++i;
        }
        throw new RuntimeException("Erreur inattendue");
    }

    private int getIndexCol(ContratCell lig, ContratDTO contratDTO) {
        int j = 0;
        for (ContratColDTO dto : contratDTO.contratColumns) {
            if (dto.modeleContratProduitId.equals(lig.modeleContratProduit.getId())) {
                return j;
            }
            ++j;
        }
        throw new RuntimeException("Erreur inattendue");
    }

    @DbWrite
    public void deleteContrat(Long contratId) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            Contrat c = em.find(Contrat.class, contratId);
            List<ContratCell> qtes = this.getAllQte(em, c);
            for (ContratCell contratLig : qtes) {
                em.remove(contratLig);
            }
            List<Paiement> ps = this.getAllPaiements(em, c);
            for (Paiement paiement : ps) {
                if (paiement.etat.equals((Object)EtatPaiement.A_FOURNIR)) {
                    em.remove(paiement);
                    continue;
                }
                String str = "Il existe un paiement de " + new CurrencyTextFieldConverter().convertToString(paiement.montant) + " \u20ac";
                str = paiement.etat.equals((Object)EtatPaiement.AMAP) ? String.valueOf(str) + " qui est receptionn\u00e9 \u00e0 l'AMAP. Il faut rendre le ch\u00e8que \u00e0 l'AMAPIEN ," + "modifier l'\u00e9tat du ch\u00e8que dans R\u00e9ception des ch\u00e8ques , et vous pourrez ensuite supprimer le contrat" : String.valueOf(str) + " qui a \u00e9t\u00e9 donn\u00e9 au producteur (remise). Il n'est plus possible supprimer le contrat.";
                throw new UnableToSuppressException(str);
            }
            new CoreDocEngagementSignOnLineService().deleteDocEngagementSigne(em, c);
            em.remove(c);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    private List<Paiement> getAllPaiements(RdbLink em, Contrat c) {
        Query q = em.createQuery("select p from Paiement p WHERE p.contrat=:c order by p.modeleContratDatePaiement.datePaiement");
        q.setParameter("c", (Object)c);
        List paiements = q.getResultList();
        return paiements;
    }

    public List<Utilisateur> getUtilisateur(RdbLink em, ModeleContrat mc) {
        Query q = em.createQuery("select u from Utilisateur u WHERE EXISTS (select c from Contrat c where c.utilisateur = u and c.modeleContrat=:mc) ORDER BY u.nom,u.prenom");
        q.setParameter("mc", (Object)mc);
        List us = q.getResultList();
        return us;
    }

    @DbWrite
    public void saveAvoirInitial(Long idContrat, int mntAvoir) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            Contrat c = em.find(Contrat.class, idContrat);
            c.montantAvoir = mntAvoir;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    public Contrat getContrat(Long modeleContratId, RdbLink em, Utilisateur utilisateur) {
        ModeleContrat mc = em.find(ModeleContrat.class, modeleContratId);
        Query q = em.createQuery("select c from Contrat c where c.utilisateur =:u and c.modeleContrat=:mc");
        q.setParameter("mc", (Object)mc);
        q.setParameter("u", (Object)utilisateur);
        List cs = q.getResultList();
        if (cs.size() != 1) {
            throw new RuntimeException("Erreur inattendue pour " + utilisateur.nom + utilisateur.prenom);
        }
        return (Contrat)cs.get(0);
    }

    @DbRead
    public String checkIfAccessAllowed(ContratDTO contratDTO, Long userId) {
        try {
            String string;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            if (userId == null) {
                string = null;
            } else {
                PeriodeCotisation periodeCotisation = em.find(ModeleContrat.class, (Object)contratDTO.modeleContratId).periodeCotisation;
                Utilisateur u = em.find(Utilisateur.class, userId);
                if (periodeCotisation == null) {
                    string = null;
                } else {
                    Query q = em.createQuery("select count(pu) from PeriodeCotisationUtilisateur pu WHERE pu.periodeCotisation=:p and pu.utilisateur=:u");
                    q.setParameter("p", (Object)periodeCotisation);
                    q.setParameter("u", (Object)u);
                    long nb = SQLUtils.count(q);
                    string = nb == 0L ? "Vous devez \u00eatre cotisant sur la p\u00e9riode " + periodeCotisation.nom + " pour pouvoir vous inscrire sur ce contrat.<br/><br/>Pour cela, merci d'aller \u00e0 la page \"Mes adh\u00e9sions\"" : null;
                }
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return string;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }
}

