/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.mescontrats.inscription;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.DateUtils;
import fr.amapj.common.GenericUtils;
import fr.amapj.model.models.contrat.modele.GestionPaiement;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.modele.NatureContrat;
import fr.amapj.model.models.contrat.reel.Contrat;
import fr.amapj.model.models.contrat.reel.TypInscriptionContrat;
import fr.amapj.service.services.mescontrats.ContratDTO;
import fr.amapj.service.services.mescontrats.ContratLigDTO;
import fr.amapj.service.services.mescontrats.ContratStatusService;
import fr.amapj.service.services.mescontrats.DatePaiementDTO;
import fr.amapj.service.services.mescontrats.inscription.InscriptionDTO;
import fr.amapj.service.services.mescontrats.inscription.abo.ICAbonnementDTO;
import fr.amapj.service.services.mescontrats.inscription.abo.ICAbonnementService;
import fr.amapj.service.services.mescontrats.inscription.carteprepayee.ICCartePrepayeeService;
import fr.amapj.service.services.mescontrats.inscription.libre.ICLibreDTO;
import fr.amapj.service.services.mescontrats.inscription.libre.ICLibreService;
import fr.amapj.view.views.saisiecontrat.SaisieContrat;
import fr.amapj.view.views.saisiecontrat.abo.ContratAbo;
import fr.amapj.view.views.saisiecontrat.step1qte.abo.ContratAboManager;
import fr.amapj.view.views.saisiecontrat.step1qte.utils.QtePopupType;
import java.util.Date;
import java.util.List;

public class InscriptionService {
    private ContratDTO contratDTO;
    private SaisieContrat.ModeSaisie modeSaisie;
    private Date now;
    private Contrat c;
    private ModeleContrat mc;
    private InscriptionDTO inscriptionDTO;
    private boolean isRetardataire;

    public InscriptionService(ContratDTO contratDTO, SaisieContrat.ModeSaisie modeSaisie, Date now, Contrat c, ModeleContrat mc, InscriptionDTO inscriptionDTO) {
        this.contratDTO = contratDTO;
        this.modeSaisie = modeSaisie;
        this.now = now;
        this.c = c;
        this.mc = mc;
        this.inscriptionDTO = inscriptionDTO;
        this.isRetardataire = false;
    }

    public void buildInscriptionDTO() {
        this.contratDTO.modeSaisie = this.modeSaisie;
        this.inscriptionDTO.onLoadPaiementEqualCommande = this.contratDTO.getMontantTotal() == this.contratDTO.paiement.getMontantTotalPaiement();
        switch (this.contratDTO.nature) {
            case LIBRE: {
                this.computeLibre();
                break;
            }
            case CARTE_PREPAYEE: {
                this.computeCartePrepayee();
                break;
            }
            case ABONNEMENT: {
                this.computeAbonnement();
                break;
            }
            default: {
                throw new AmapjRuntimeException();
            }
        }
        if (this.c == null) {
            TypInscriptionContrat typInscriptionContrat = this.contratDTO.typInscriptionContrat = this.isRetardataire ? TypInscriptionContrat.RETARDATAIRE : TypInscriptionContrat.STANDARD;
        }
        if (!this.isNbQteLigModifiableOK()) {
            this.error("Il n'est plus possible de modifier ce contrat (aucune date n'est modifiable)");
            return;
        }
        this.computePaiementInfo();
        if (!this.isNbPaiementModifiableOK()) {
            this.error("Il n'est plus possible de modifier ce contrat car aucun paiement n'est modifiable.");
            return;
        }
    }

    private void computeLibre() {
        switch (this.modeSaisie) {
            case STANDARD: {
                this.libreStandard();
                return;
            }
            case FOR_TEST: 
            case QTE_SEUL: 
            case QTE_CHEQUE_REFERENT: {
                this.inscriptionDTO.popupType = QtePopupType.POPUP_LIBRE;
                this.fullModifiable();
                return;
            }
            case READ_ONLY: 
            case CHEQUE_SEUL: {
                this.inscriptionDTO.popupType = QtePopupType.POPUP_LIBRE;
                this.noModifiable();
                return;
            }
        }
        throw new AmapjRuntimeException();
    }

    private void libreStandard() {
        ICLibreDTO icLibre = new ICLibreService().computeLibre(this.contratDTO, this.now, this.c, this.mc);
        switch (icLibre.status) {
            case STANDARD: {
                this.inscriptionDTO.popupType = QtePopupType.POPUP_LIBRE;
                this.fullModifiable();
                return;
            }
            case RETARDAIRE: {
                this.isRetardataire = true;
                this.inscriptionDTO.popupType = QtePopupType.POPUP_LIBRE;
                this.modifiableFrom(icLibre.startDateRetardataire);
                return;
            }
            case NONE: {
                this.error("Il est trop tard pour modifier ce contrat ou pour s'inscrire.");
                return;
            }
        }
        throw new AmapjRuntimeException();
    }

    private void computeCartePrepayee() {
        switch (this.modeSaisie) {
            case STANDARD: {
                this.cartePrepayeeStandard();
                return;
            }
            case FOR_TEST: 
            case QTE_SEUL: 
            case QTE_CHEQUE_REFERENT: {
                this.inscriptionDTO.popupType = QtePopupType.POPUP_LIBRE;
                this.fullModifiable();
                return;
            }
            case READ_ONLY: 
            case CHEQUE_SEUL: {
                this.inscriptionDTO.popupType = QtePopupType.POPUP_LIBRE;
                this.noModifiable();
                return;
            }
        }
        throw new AmapjRuntimeException();
    }

    private void cartePrepayeeStandard() {
        Date startDate = new ICCartePrepayeeService().computeCartePrepayee(this.contratDTO, this.now, this.c, this.mc);
        if (startDate == null) {
            this.error("Il est trop tard pour modifier ce contrat ou pour s'inscrire.");
            return;
        }
        this.inscriptionDTO.popupType = QtePopupType.POPUP_LIBRE;
        this.modifiableFrom(startDate);
    }

    private void computeAbonnement() {
        switch (this.modeSaisie) {
            case STANDARD: {
                this.abonnementStandard();
                return;
            }
            case FOR_TEST: {
                this.inscriptionDTO.popupType = QtePopupType.POPUP_ABO;
                this.contratDTO.contratAbo = new ContratAboManager().computeContratAboNewContrat(this.contratDTO, null);
                this.fullModifiable();
                return;
            }
            case QTE_SEUL: 
            case QTE_CHEQUE_REFERENT: {
                this.inscriptionDTO.popupType = QtePopupType.POPUP_LIBRE;
                this.fullModifiable();
                return;
            }
            case READ_ONLY: {
                this.abonnementReadOnly();
                return;
            }
            case CHEQUE_SEUL: {
                this.inscriptionDTO.popupType = QtePopupType.POPUP_LIBRE;
                this.noModifiable();
                return;
            }
            case JOKER: {
                this.abonnementJoker();
                return;
            }
        }
        throw new AmapjRuntimeException();
    }

    private void abonnementStandard() {
        ICAbonnementDTO ic = new ICAbonnementService().computeAbonnement(this.contratDTO, this.now, this.c, this.mc);
        switch (ic.status) {
            case STANDARD: {
                this.fullModifiable();
                this.abonnementStandardCreateFacadeAbo(ic);
                return;
            }
            case RETARDAIRE: {
                this.modifiableFrom(ic.startDateRetardataire);
                this.isRetardataire = true;
                this.abonnementStandardCreateFacadeAbo(ic);
                return;
            }
            case JOKER_OU_NONE: {
                this.error("Il est trop tard pour modifier ce contrat ou pour s'inscrire.");
                return;
            }
        }
        throw new AmapjRuntimeException();
    }

    private void abonnementStandardCreateFacadeAbo(ICAbonnementDTO ic) {
        this.inscriptionDTO.popupType = QtePopupType.POPUP_ABO;
        if (this.c == null) {
            this.contratDTO.contratAbo = new ContratAboManager().computeContratAboNewContrat(this.contratDTO, ic.startDateRetardataire);
            return;
        }
        GenericUtils.Ret<ContratAbo> ret = new ContratAboManager().computeContratAboExistingContrat(this.contratDTO, this.c.aboInfo);
        if (ret.isOK()) {
            this.contratDTO.contratAbo = ret.get();
        } else {
            this.error("Vous ne pouvez pas modifier ce contrat car il a  \u00e9t\u00e9 modifi\u00e9 par le r\u00e9f\u00e9rent. D\u00e9tails : " + ret.msg());
        }
    }

    private void abonnementReadOnly() {
        GenericUtils.Ret<ContratAbo> ret = new ContratAboManager().computeContratAboExistingContrat(this.contratDTO, this.c.aboInfo);
        if (ret.isOK()) {
            this.contratDTO.contratAbo = ret.get();
            this.inscriptionDTO.popupType = QtePopupType.POPUP_ABO;
            this.noModifiable();
        } else {
            this.inscriptionDTO.popupType = QtePopupType.POPUP_LIBRE;
            this.noModifiable();
        }
    }

    private void abonnementJoker() {
        GenericUtils.Ret<ContratAbo> ret = new ContratAboManager().computeContratAboExistingContrat(this.contratDTO, this.c.aboInfo);
        if (!ret.isOK()) {
            this.error("Vous ne pouvez pas modifier vos jokers car ceux ci ont \u00e9t\u00e9 modifi\u00e9s par le r\u00e9f\u00e9rent. D\u00e9tails : " + ret.msg());
            return;
        }
        this.contratDTO.contratAbo = ret.get();
        for (ContratLigDTO lig : this.contratDTO.contratLigs) {
            lig.isModifiable = new ContratStatusService().isDateModifiableAbonnementJoker(lig.date, this.now, this.mc);
        }
    }

    private void error(String message) {
        this.inscriptionDTO.popupType = null;
        this.inscriptionDTO.errorMessage = message;
    }

    private void fullModifiable() {
        for (ContratLigDTO lig : this.contratDTO.contratLigs) {
            lig.isModifiable = true;
        }
    }

    private void noModifiable() {
        for (ContratLigDTO lig : this.contratDTO.contratLigs) {
            lig.isModifiable = false;
        }
    }

    private void modifiableFrom(Date startDate) {
        for (ContratLigDTO lig : this.contratDTO.contratLigs) {
            boolean bl = lig.isModifiable = lig.date.after(startDate) || lig.date.equals(startDate);
        }
    }

    private void computePaiementInfo() {
        for (DatePaiementDTO datePaiementDTO : this.contratDTO.paiement.datePaiements) {
            datePaiementDTO.isModifiable = this.computeDatePaiementModifiable(datePaiementDTO);
        }
        this.setNonModifableDateInPast();
    }

    private boolean computeDatePaiementModifiable(DatePaiementDTO datePaiement) {
        switch (this.modeSaisie) {
            case STANDARD: {
                switch (datePaiement.etatPaiement) {
                    case A_FOURNIR: {
                        return true;
                    }
                    case AMAP: 
                    case PRODUCTEUR: {
                        return false;
                    }
                }
                throw new AmapjRuntimeException();
            }
            case FOR_TEST: {
                return true;
            }
            case READ_ONLY: {
                return false;
            }
            case CHEQUE_SEUL: 
            case QTE_CHEQUE_REFERENT: {
                switch (datePaiement.etatPaiement) {
                    case A_FOURNIR: 
                    case AMAP: {
                        return true;
                    }
                    case PRODUCTEUR: {
                        return false;
                    }
                }
                throw new AmapjRuntimeException();
            }
            case JOKER: 
            case QTE_SEUL: {
                return false;
            }
        }
        throw new AmapjRuntimeException();
    }

    private void setNonModifableDateInPast() {
        Date ref = DateUtils.addDays(this.now, 5);
        if (this.modeSaisie != SaisieContrat.ModeSaisie.STANDARD) {
            return;
        }
        if (this.contratDTO.paiement.getNbModifiable() <= 1) {
            return;
        }
        if (this.isRetardataire || this.contratDTO.nature == NatureContrat.CARTE_PREPAYEE) {
            List<DatePaiementDTO> datePaiements = this.contratDTO.paiement.datePaiements;
            int i = 0;
            while (i < datePaiements.size() - 1) {
                DatePaiementDTO datePaiementDTO = datePaiements.get(i);
                if (datePaiementDTO.isModifiable && datePaiementDTO.datePaiement.before(ref)) {
                    datePaiementDTO.isModifiable = false;
                }
                ++i;
            }
        }
    }

    private boolean isNbQteLigModifiableOK() {
        if (this.modeSaisie != SaisieContrat.ModeSaisie.STANDARD) {
            return true;
        }
        long nb = this.contratDTO.contratLigs.stream().filter(e -> e.isModifiable).count();
        return nb != 0L;
    }

    private boolean isNbPaiementModifiableOK() {
        if (this.modeSaisie != SaisieContrat.ModeSaisie.STANDARD) {
            return true;
        }
        if (this.mc.gestionPaiement == GestionPaiement.NON_GERE) {
            return true;
        }
        int nb = this.contratDTO.paiement.getNbModifiable();
        return nb != 0;
    }
}

