/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.mescontrats.inscription.retardataire;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.DateUtils;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.modele.RetardataireAutorise;
import fr.amapj.model.models.contrat.reel.Contrat;
import fr.amapj.service.services.mescontrats.ContratDTO;
import fr.amapj.service.services.mescontrats.ContratLigDTO;
import java.util.Date;

public class RetardataireService {
    public Date computeICRetardataireDTO(ContratDTO contratDTO, Date now, Contrat c, ModeleContrat mc) {
        if (c != null) {
            switch (c.typInscriptionContrat) {
                case STANDARD: {
                    return null;
                }
                case RETARDATAIRE: {
                    Date limit = DateUtils.addDays(DateUtils.suppressTime(c.dateCreation), 1);
                    if (now.before(limit)) {
                        return this.computeICRetardataireDTOInternal(contratDTO, now, c, mc);
                    }
                    return null;
                }
            }
            throw new AmapjRuntimeException("c=" + (Object)((Object)c.typInscriptionContrat));
        }
        if (mc.retardataireAutorise == RetardataireAutorise.NON) {
            return null;
        }
        return this.computeICRetardataireDTOInternal(contratDTO, now, c, mc);
    }

    private Date computeICRetardataireDTOInternal(ContratDTO contratDTO, Date now, Contrat c, ModeleContrat mc) {
        int retardataireDelai = mc.producteur.delaiModifContrat;
        int i = 0;
        while (i < contratDTO.contratLigs.size()) {
            ContratLigDTO lig = contratDTO.contratLigs.get(i);
            if (this.retardataireLigModifiable(lig, now, retardataireDelai)) {
                return lig.date;
            }
            ++i;
        }
        return null;
    }

    private boolean retardataireLigModifiable(ContratLigDTO lig, Date now, int retardataireDelai) {
        Date d = DateUtils.addDays(lig.date, -retardataireDelai);
        return d.after(now);
    }
}

