/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.mescontrats.small;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.DateUtils;
import fr.amapj.common.SQLUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.contrat.modele.EtatModeleContrat;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.modele.ModeleContratDate;
import fr.amapj.model.models.contrat.modele.NatureContrat;
import fr.amapj.model.models.contrat.modele.TypJoker;
import fr.amapj.model.models.contrat.reel.Contrat;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.mescontrats.ContratStatusService;
import fr.amapj.service.services.mescontrats.small.SmallContratDTO;
import fr.amapj.service.services.mescontrats.small.inscription.InscriptionButton;
import fr.amapj.service.services.mescontrats.small.inscription.SmallInscriptionDTO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

public class SmallContratsService {
    @DbRead
    public List<SmallContratDTO> getMesContrats(Long userId) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ArrayList<SmallContratDTO> res = new ArrayList<SmallContratDTO>();
            Utilisateur user = em.find(Utilisateur.class, userId);
            Date now = DateUtils.getDate();
            Date d = DateUtils.suppressTime(now);
            d = DateUtils.addDays(d, -5);
            TypedQuery<ModeleContrat> q = em.createQuery("select distinct(mcd.modeleContrat) from ModeleContratDate mcd WHERE  mcd.modeleContrat.etat=:etat AND  mcd.dateLiv>=:d ", ModeleContrat.class);
            q.setParameter("etat", (Object)EtatModeleContrat.ACTIF);
            q.setParameter("d", (Object)d);
            List mcs = q.getResultList();
            for (ModeleContrat modeleContrat : mcs) {
                TypedQuery<Contrat> q2 = em.createQuery("select c from Contrat c where c.modeleContrat=:mc AND c.utilisateur=:u", Contrat.class);
                q2.setParameter("mc", (Object)modeleContrat);
                q2.setParameter("u", (Object)user);
                Contrat c = SQLUtils.oneOrZero(q2);
                List<ModeleContratDate> dates = new GestionContratService().getAllDates(em, modeleContrat);
                SmallContratDTO contratDTO = this.buildBasicContratDTO(em, modeleContrat, c, dates);
                SmallInscriptionDTO inscriptionDTO = this.buildInscriptionDTO(em, modeleContrat, c, now, dates, contratDTO);
                if (inscriptionDTO == null) continue;
                contratDTO.inscriptionDTO = inscriptionDTO;
                res.add(contratDTO);
            }
            ArrayList<SmallContratDTO> arrayList = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return arrayList;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private SmallContratDTO buildBasicContratDTO(RdbLink em, ModeleContrat mc, Contrat c, List<ModeleContratDate> dates) {
        int nbLivraison = dates.size() - new GestionContratService().getNbDateAnnulees(em, mc);
        Date dateDebut = dates.get((int)0).dateLiv;
        Date dateFin = dates.get((int)(dates.size() - 1)).dateLiv;
        SmallContratDTO dto = new SmallContratDTO();
        dto.contratId = c == null ? null : c.id;
        dto.modeleContratId = mc.getId();
        dto.nom = mc.nom;
        dto.description = mc.description;
        dto.nomProducteur = mc.producteur.nom;
        dto.dateFinInscription = mc.dateFinInscription;
        dto.nbLivraison = nbLivraison;
        dto.dateDebut = dateDebut;
        dto.dateFin = dateFin;
        dto.nature = mc.nature;
        return dto;
    }

    private SmallInscriptionDTO buildInscriptionDTO(RdbLink em, ModeleContrat modeleContrat, Contrat c, Date now, List<ModeleContratDate> dates, SmallContratDTO contratDTO) {
        SimpleDateFormat df = new SimpleDateFormat("EEEEE dd MMMMM yyyy");
        switch (modeleContrat.nature) {
            case ABONNEMENT: 
            case LIBRE: {
                return this.computeAboEtLibre(df, modeleContrat, now, c, dates, contratDTO);
            }
            case CARTE_PREPAYEE: {
                return this.computeCartePrepayee(df, modeleContrat, em, now, c, dates, contratDTO);
            }
        }
        throw new AmapjRuntimeException();
    }

    private SmallInscriptionDTO computeAboEtLibre(SimpleDateFormat df, ModeleContrat modeleContrat, Date now, Contrat c, List<ModeleContratDate> dates, SmallContratDTO contratDTO) {
        SmallInscriptionDTO dto = new SmallInscriptionDTO();
        if (c == null) {
            if (new ContratStatusService().isInscriptionNonTerminee(modeleContrat, now)) {
                dto.buttons = new InscriptionButton[]{InscriptionButton.SINCRIRE};
                dto.isRetardataire = false;
                dto.libContrat = this.formatLibelleStandard(df, contratDTO, true);
                return dto;
            }
            if (new ContratStatusService().isInscriptionRetardatairePossible(modeleContrat, now, dates)) {
                dto.buttons = new InscriptionButton[]{InscriptionButton.SINCRIRE};
                dto.isRetardataire = true;
                dto.libContrat = this.formatLibelleRetardataire(df, contratDTO, true);
                return dto;
            }
            return null;
        }
        if (new ContratStatusService().isInscriptionNonTerminee(modeleContrat, now)) {
            dto.buttons = new InscriptionButton[]{InscriptionButton.MODIFIER, InscriptionButton.SUPPRIMER, InscriptionButton.VOIR};
            dto.isRetardataire = false;
            dto.libContrat = this.formatLibelleStandard(df, contratDTO, false);
            return dto;
        }
        if (new ContratStatusService().isContratRetardataireModifiable(c, now)) {
            dto.buttons = new InscriptionButton[]{InscriptionButton.MODIFIER, InscriptionButton.SUPPRIMER, InscriptionButton.VOIR};
            dto.isRetardataire = true;
            dto.libContrat = this.formatLibelleRetardataire(df, contratDTO, false);
            return dto;
        }
        if (modeleContrat.nature == NatureContrat.ABONNEMENT && modeleContrat.typJoker != TypJoker.SANS_JOKER && modeleContrat.jokerNbMax > 0) {
            dto.buttons = new InscriptionButton[]{InscriptionButton.JOKER, InscriptionButton.VOIR};
            dto.isRetardataire = false;
            dto.libContrat = this.formatLibelleJoker(df, contratDTO);
            return dto;
        }
        dto.buttons = new InscriptionButton[]{InscriptionButton.VOIR};
        dto.isRetardataire = false;
        dto.libContrat = this.formatLibelleNone(df, contratDTO);
        return dto;
    }

    private SmallInscriptionDTO computeCartePrepayee(SimpleDateFormat df, ModeleContrat modeleContrat, RdbLink em, Date now, Contrat c, List<ModeleContratDate> dates, SmallContratDTO contratDTO) {
        Date nextDateLiv = this.getNextDateLivraison(dates, now, modeleContrat.cartePrepayeeDelai);
        Date nextDateLivModifiable = this.getNextDateLivModifiable(dates, now);
        SmallInscriptionDTO dto = new SmallInscriptionDTO();
        if (c == null) {
            if (nextDateLivModifiable != null) {
                dto.buttons = new InscriptionButton[]{InscriptionButton.SINCRIRE};
                dto.isRetardataire = false;
                dto.libContrat = this.formatLibelleContratCartePrepayee(df, contratDTO, nextDateLiv, nextDateLivModifiable, modeleContrat);
                return dto;
            }
            return null;
        }
        if (nextDateLivModifiable != null) {
            dto.buttons = this.computeIsContratPrepayeeSupprimable(now, c, em) ? new InscriptionButton[]{InscriptionButton.MODIFIER, InscriptionButton.SUPPRIMER, InscriptionButton.VOIR} : new InscriptionButton[]{InscriptionButton.MODIFIER, InscriptionButton.VOIR};
            dto.isRetardataire = false;
            dto.libContrat = this.formatLibelleContratCartePrepayee(df, contratDTO, nextDateLiv, nextDateLivModifiable, modeleContrat);
            return dto;
        }
        dto.buttons = new InscriptionButton[]{InscriptionButton.VOIR};
        dto.isRetardataire = false;
        dto.libContrat = this.formatLibelleContratCartePrepayee(df, contratDTO, nextDateLiv, nextDateLivModifiable, modeleContrat);
        return dto;
    }

    private boolean computeIsContratPrepayeeSupprimable(Date now, Contrat contrat, RdbLink em) {
        Date d = DateUtils.suppressTime(now);
        d = DateUtils.addDays(d, contrat.modeleContrat.cartePrepayeeDelai);
        Query q = em.createQuery("select count(cc) from ContratCell cc  WHERE cc.contrat=:c and cc.modeleContratDate.dateLiv<=:d");
        q.setParameter("c", (Object)contrat);
        q.setParameter("d", (Object)d);
        int count = SQLUtils.toInt(q.getSingleResult());
        return count == 0;
    }

    private Date getNextDateLivraison(List<ModeleContratDate> datLivs, Date now, int cartePrepayeeDelai) {
        Date ref = DateUtils.addDays(now, -1);
        for (ModeleContratDate lig : datLivs) {
            if (!ref.before(lig.dateLiv)) continue;
            return lig.dateLiv;
        }
        return null;
    }

    private Date getNextDateLivModifiable(List<ModeleContratDate> mcds, Date now) {
        for (ModeleContratDate mcd : mcds) {
            if (!new ContratStatusService().isDateModifiableCartePrepayee(mcd, now)) continue;
            return mcd.dateLiv;
        }
        return null;
    }

    private String formatLibelleContratCartePrepayee(SimpleDateFormat df, SmallContratDTO c, Date nextDateLiv, Date nextDateLivModifiable, ModeleContrat modeleContrat) {
        String str = c.description;
        str = String.valueOf(str) + "<br/>";
        str = nextDateLiv == null ? String.valueOf(str) + "<b>Toutes les livraisons sont faites.</b>" : String.valueOf(str) + "<b>Prochaine livraison le " + df.format(nextDateLiv) + "</b>";
        str = String.valueOf(str) + "<br/>";
        if (nextDateLivModifiable == null) {
            str = String.valueOf(str) + "Ce contrat n'est plus modifiable.";
        } else {
            Date datLimit = DateUtils.addDays(nextDateLivModifiable, -(modeleContrat.cartePrepayeeDelai + 1));
            str = String.valueOf(str) + "La livraison du " + df.format(nextDateLivModifiable) + " est modifiable ( modification possible jusqu'au " + df.format(datLimit) + " minuit).";
        }
        str = String.valueOf(str) + "<br/>";
        return str;
    }

    private String formatLibelleStandard(SimpleDateFormat df, SmallContratDTO c, boolean isInscription) {
        String str = this.enteteContratAboEtLibre(df, c);
        str = isInscription ? String.valueOf(str) + "Vous pouvez vous inscrire et modifier ce contrat jusqu'au " + df.format(c.dateFinInscription) + " minuit." : String.valueOf(str) + "Ce contrat est modifiable jusqu'au " + df.format(c.dateFinInscription) + " minuit.";
        str = String.valueOf(str) + "<br/>";
        return str;
    }

    private String formatLibelleJoker(SimpleDateFormat df, SmallContratDTO c) {
        String str = this.enteteContratAboEtLibre(df, c);
        str = String.valueOf(str) + "Ce contrat n'est plus modifiable, mais vous pouvez \u00e9ventuellement ajuster vos jokers.";
        str = String.valueOf(str) + "<br/>";
        return str;
    }

    private String formatLibelleRetardataire(SimpleDateFormat df, SmallContratDTO c, boolean isInscription) {
        String str = this.enteteContratAboEtLibre(df, c);
        str = isInscription ? String.valueOf(str) + "Vous pouvez vous inscrire en tant que nouvel arrivant / retardataire pour ce contrat (vous pourrez modifier vos choix jusqu'\u00e0 ce soir minuit)." : String.valueOf(str) + "Vous vous \u00eates inscrit en tant que nouvel arrivant / retardataire pour ce contrat, vous pouvez modifier ce contrat jusqu'\u00e0 ce soir minuit.";
        str = String.valueOf(str) + "<br/>";
        return str;
    }

    private String formatLibelleNone(SimpleDateFormat df, SmallContratDTO c) {
        String str = this.enteteContratAboEtLibre(df, c);
        str = String.valueOf(str) + "Ce contrat n'est plus modifiable.";
        str = String.valueOf(str) + "<br/>";
        return str;
    }

    private String enteteContratAboEtLibre(SimpleDateFormat df, SmallContratDTO c) {
        String str = c.description;
        str = String.valueOf(str) + "<br/>";
        str = c.nbLivraison == 1 ? String.valueOf(str) + "<b>Une seule livraison le " + df.format(c.dateDebut) + "</b>" : String.valueOf(str) + "<b>" + c.nbLivraison + " livraisons \u00e0 partir du " + df.format(c.dateDebut) + " jusqu'au " + df.format(c.dateFin) + "</b>";
        str = String.valueOf(str) + "<br/>";
        return str;
    }
}

