/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.meslivraisons;

import fr.amapj.common.DateUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.acces.RoleList;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.modele.ModeleContratDate;
import fr.amapj.model.models.contrat.reel.ContratCell;
import fr.amapj.model.models.editionspe.EditionSpecifique;
import fr.amapj.model.models.editionspe.TypEditionSpecifique;
import fr.amapj.model.models.editionspe.emargement.FeuilleEmargementJson;
import fr.amapj.model.models.editionspe.emargement.TypFeuilleEmargement;
import fr.amapj.model.models.fichierbase.Producteur;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.model.models.permanence.periode.EtatPeriodePermanence;
import fr.amapj.model.models.permanence.periode.PeriodePermanence;
import fr.amapj.model.models.permanence.periode.PeriodePermanenceDate;
import fr.amapj.service.services.edgenerator.excel.emargement.EGFeuilleEmargement;
import fr.amapj.service.services.editionspe.EditionSpeService;
import fr.amapj.service.services.meslivraisons.JourLivraisonsDTO;
import fr.amapj.service.services.meslivraisons.MesLivraisonsDTO;
import fr.amapj.service.services.meslivraisons.ProducteurLivraisonsDTO;
import fr.amapj.service.services.meslivraisons.QteProdDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.TemporalType;

public class MesLivraisonsService {
    @DbRead
    public MesLivraisonsDTO getMesLivraisons(Date dateDebut, Date dateFin, List<RoleList> roles, Long idUtilisateur) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            MesLivraisonsDTO res = new MesLivraisonsDTO();
            Utilisateur user = em.find(Utilisateur.class, idUtilisateur);
            List<ContratCell> cells = this.getAllQte(em, dateDebut, dateFin, user);
            for (ContratCell cell : cells) {
                this.addCell(cell, res);
            }
            List<PeriodePermanenceDate> dds = this.getAllDistributionsForUtilisateur(em, dateDebut, dateFin, user);
            for (PeriodePermanenceDate dd : dds) {
                this.addDistribution(em, dd.datePerm, dd.id, res, dd.periodePermanence);
            }
            res.planningMensuel = this.computePlanningMensuel(em, dateDebut, dateFin, roles);
            MesLivraisonsDTO mesLivraisonsDTO = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return mesLivraisonsDTO;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    public List<PeriodePermanenceDate> getAllDistributionsForUtilisateur(RdbLink em, Date dateDebut, Date dateFin, Utilisateur utilisateur) {
        Query q = em.createQuery("select distinct(du.periodePermanenceDate) from PermanenceCell du WHERE du.periodePermanenceDate.periodePermanence.etat=:etat and du.periodePermanenceDate.datePerm>=:deb and du.periodePermanenceDate.datePerm<=:fin and du.periodePermanenceUtilisateur.utilisateur=:user order by du.periodePermanenceDate.datePerm");
        q.setParameter("etat", (Object)EtatPeriodePermanence.ACTIF);
        q.setParameter("deb", dateDebut, TemporalType.DATE);
        q.setParameter("fin", dateFin, TemporalType.DATE);
        q.setParameter("user", (Object)utilisateur);
        List dds = q.getResultList();
        return dds;
    }

    private void addDistribution(RdbLink em, Date dateLiv, Long idPeriodePermanenceDate, MesLivraisonsDTO res, PeriodePermanence periodePermanence) {
        JourLivraisonsDTO jour = this.findJour(dateLiv, res);
        if (jour.permanences == null) {
            jour.permanences = new ArrayList<JourLivraisonsDTO.InfoPermanence>();
        }
        JourLivraisonsDTO.InfoPermanence info = new JourLivraisonsDTO.InfoPermanence();
        info.dateDTO = new PeriodePermanenceService().loadOneDatePermanence(idPeriodePermanenceDate);
        info.periodePermanenceDTO = new PeriodePermanenceService().createSmallPeriodePermanenceDTO(em, periodePermanence);
        jour.permanences.add(info);
    }

    private void addCell(ContratCell cell, MesLivraisonsDTO res) {
        JourLivraisonsDTO jour = this.findJour(cell.modeleContratDate.dateLiv, res);
        ProducteurLivraisonsDTO producteurs = this.findProducteurLivraison(cell.modeleContratDate, cell.modeleContratDate.modeleContrat, jour);
        QteProdDTO qteProdDTO = this.findQteProdDTO(producteurs.produits, cell);
        qteProdDTO.qte += cell.qte;
    }

    private QteProdDTO findQteProdDTO(List<QteProdDTO> produits, ContratCell cell) {
        QteProdDTO qteProdDTO2;
        for (QteProdDTO qteProdDTO2 : produits) {
            if (!qteProdDTO2.idProduit.equals(cell.modeleContratProduit.produit.getId())) continue;
            return qteProdDTO2;
        }
        qteProdDTO2 = new QteProdDTO();
        qteProdDTO2.conditionnementProduit = cell.modeleContratProduit.produit.conditionnement;
        qteProdDTO2.nomProduit = cell.modeleContratProduit.produit.nom;
        qteProdDTO2.idProduit = cell.modeleContratProduit.produit.getId();
        qteProdDTO2.prixUnitaireProduit = cell.modeleContratProduit.prix;
        produits.add(qteProdDTO2);
        return qteProdDTO2;
    }

    private JourLivraisonsDTO findJour(Date dateLiv, MesLivraisonsDTO res) {
        JourLivraisonsDTO jour2;
        for (JourLivraisonsDTO jour2 : res.jours) {
            if (!jour2.date.equals(dateLiv)) continue;
            return jour2;
        }
        jour2 = new JourLivraisonsDTO();
        jour2.date = dateLiv;
        res.jours.add(jour2);
        return jour2;
    }

    private ProducteurLivraisonsDTO findProducteurLivraison(ModeleContratDate modeleContratDate, ModeleContrat modeleContrat, JourLivraisonsDTO jour) {
        ProducteurLivraisonsDTO producteur2;
        for (ProducteurLivraisonsDTO producteur2 : jour.producteurs) {
            if (!producteur2.idModeleContrat.equals(modeleContrat.getId())) continue;
            return producteur2;
        }
        producteur2 = new ProducteurLivraisonsDTO();
        producteur2.producteur = modeleContrat.producteur.nom;
        producteur2.modeleContrat = modeleContrat.nom;
        producteur2.idModeleContrat = modeleContrat.getId();
        producteur2.idModeleContratDate = modeleContratDate.getId();
        jour.producteurs.add(producteur2);
        return producteur2;
    }

    public List<ContratCell> getAllQte(RdbLink em, Date dateDebut, Date dateFin, Utilisateur user) {
        Query q = em.createQuery("select c from ContratCell c WHERE c.modeleContratDate.dateLiv>=:deb AND c.modeleContratDate.dateLiv<=:fin and c.contrat.utilisateur =:user order by c.modeleContratDate.dateLiv, c.contrat.modeleContrat.producteur.id, c.contrat.modeleContrat.id , c.modeleContratProduit.indx");
        q.setParameter("deb", dateDebut, TemporalType.DATE);
        q.setParameter("fin", dateFin, TemporalType.DATE);
        q.setParameter("user", (Object)user);
        List prods = q.getResultList();
        return prods;
    }

    private List<EGFeuilleEmargement> computePlanningMensuel(RdbLink em, Date dateDebut, Date dateFin, List<RoleList> roles) {
        ArrayList<EGFeuilleEmargement> res = new ArrayList<EGFeuilleEmargement>();
        if (!new EditionSpeService().needPlanningMensuel()) {
            return res;
        }
        List<Date> months = this.getMonth(em, dateDebut, dateFin);
        List<Date> weeks = this.getWeek(em, dateDebut, dateFin);
        List<EditionSpecifique> editions = new EditionSpeService().getEtiquetteByType(TypEditionSpecifique.FEUILLE_EMARGEMENT);
        for (EditionSpecifique editionSpecifique : editions) {
            EGFeuilleEmargement planningMensuel;
            FeuilleEmargementJson planningJson;
            if (!this.canAccess(roles, editionSpecifique)) continue;
            String suffix = "";
            if (editions.size() != 1) {
                suffix = editionSpecifique.nom;
            }
            if ((planningJson = (FeuilleEmargementJson)new EditionSpeService().load(editionSpecifique.id)).getTypPlanning() == TypFeuilleEmargement.MENSUEL) {
                for (Date month : months) {
                    planningMensuel = new EGFeuilleEmargement(editionSpecifique.getId(), month, suffix);
                    res.add(planningMensuel);
                }
                continue;
            }
            for (Date week : weeks) {
                planningMensuel = new EGFeuilleEmargement(editionSpecifique.getId(), week, suffix);
                res.add(planningMensuel);
            }
        }
        return res;
    }

    private boolean canAccess(List<RoleList> roles, EditionSpecifique editionSpecifique) {
        FeuilleEmargementJson planningJson = (FeuilleEmargementJson)new EditionSpeService().load(editionSpecifique.id);
        return roles.contains((Object)planningJson.getAccessibleBy());
    }

    private List<Date> getMonth(RdbLink em, Date dateDebut, Date dateFin) {
        Query q = em.createQuery("select distinct(mcd.dateLiv) from ModeleContratDate mcd WHERE mcd.dateLiv>=:deb AND mcd.dateLiv<=:fin order by mcd.dateLiv");
        q.setParameter("deb", dateDebut, TemporalType.DATE);
        q.setParameter("fin", dateFin, TemporalType.DATE);
        List mcds = q.getResultList();
        ArrayList<Date> res = new ArrayList<Date>();
        for (Date mcd : mcds) {
            Date month = DateUtils.firstDayInMonth(mcd);
            if (res.contains(month)) continue;
            res.add(month);
        }
        return res;
    }

    private List<Date> getWeek(RdbLink em, Date dateDebut, Date dateFin) {
        Query q = em.createQuery("select distinct(mcd.dateLiv) from ModeleContratDate mcd WHERE mcd.dateLiv>=:deb AND mcd.dateLiv<=:fin order by mcd.dateLiv");
        q.setParameter("deb", dateDebut, TemporalType.DATE);
        q.setParameter("fin", dateFin, TemporalType.DATE);
        List mcds = q.getResultList();
        ArrayList<Date> res = new ArrayList<Date>();
        for (Date mcd : mcds) {
            Date week = DateUtils.firstMonday(mcd);
            if (res.contains(week)) continue;
            res.add(week);
        }
        return res;
    }

    @DbRead
    public MesLivraisonsDTO getLivraisonFeuilleEmargementListe(Date d, Long idUtilisateur) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            MesLivraisonsDTO res = new MesLivraisonsDTO();
            Utilisateur user = em.find(Utilisateur.class, idUtilisateur);
            List<ContratCell> cells = this.getAllQte(em, d, d, user);
            for (ContratCell cell : cells) {
                this.addCell(cell, res);
            }
            MesLivraisonsDTO mesLivraisonsDTO = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return mesLivraisonsDTO;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public MesLivraisonsDTO getLivraisonProducteur(Date dateDebut, Date dateFin, Long idProducteur) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            MesLivraisonsDTO res = new MesLivraisonsDTO();
            Producteur producteur = em.find(Producteur.class, idProducteur);
            List<ContratCell> cells = this.getAllQte(em, dateDebut, dateFin, producteur);
            for (ContratCell cell : cells) {
                this.addCell(cell, res);
            }
            MesLivraisonsDTO mesLivraisonsDTO = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return mesLivraisonsDTO;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private List<ContratCell> getAllQte(RdbLink em, Date dateDebut, Date dateFin, Producteur producteur) {
        Query q = em.createQuery("select c from ContratCell c WHERE c.modeleContratDate.dateLiv>=:deb AND c.modeleContratDate.dateLiv<=:fin and c.contrat.modeleContrat.producteur =:prod order by c.modeleContratDate.dateLiv, c.contrat.modeleContrat.producteur.id, c.contrat.modeleContrat.id , c.modeleContratProduit.indx");
        q.setParameter("deb", dateDebut, TemporalType.DATE);
        q.setParameter("fin", dateFin, TemporalType.DATE);
        q.setParameter("prod", (Object)producteur);
        List prods = q.getResultList();
        return prods;
    }

    @DbRead
    public Date provideNextDate(Date ref, boolean next, Long userId) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            if (next) {
                em.createQuery("select min(c.modeleContratDate.dateLiv) from ContratCell c WHERE c.modeleContratDate.dateLiv>=:ref AND c.contrat.utilisateur.id =:userId ");
            } else {
                em.createQuery("select max(c.modeleContratDate.dateLiv) from ContratCell c WHERE c.modeleContratDate.dateLiv<:ref AND c.contrat.utilisateur.id =:userId ");
            }
            em.setParameter("ref", ref);
            em.setParameter("userId", userId);
            Date date = em.result().oneOrZero(Date.class);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return date;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public Date provideNextDateProducteur(Date ref, boolean next, Long prodId) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            if (next) {
                em.createQuery("select min(c.modeleContratDate.dateLiv) from ContratCell c WHERE c.modeleContratDate.dateLiv>=:ref AND c.contrat.modeleContrat.producteur.id =:prod ");
            } else {
                em.createQuery("select max(c.modeleContratDate.dateLiv) from ContratCell c WHERE c.modeleContratDate.dateLiv<:ref AND c.contrat.modeleContrat.producteur.id =:prod ");
            }
            em.setParameter("ref", ref);
            em.setParameter("prod", prodId);
            Date date = em.result().oneOrZero(Date.class);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return date;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }
}

