/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.mespaiements;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.DateUtils;
import fr.amapj.common.SQLUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.DbWrite;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.contrat.modele.GestionPaiement;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.modele.ModeleContratDatePaiement;
import fr.amapj.model.models.contrat.modele.SaisiePaiementCalculDate;
import fr.amapj.model.models.contrat.modele.SaisiePaiementModifiable;
import fr.amapj.model.models.contrat.modele.SaisiePaiementProposition;
import fr.amapj.model.models.contrat.modele.StrategiePaiement;
import fr.amapj.model.models.contrat.reel.EtatPaiement;
import fr.amapj.model.models.contrat.reel.Paiement;
import fr.amapj.service.services.gestioncontrat.DatePaiementModeleContratDTO;
import fr.amapj.service.services.gestioncontrat.ModeleContratDTO;
import fr.amapj.service.services.gestioncontratsigne.update.GestionContratSigneUpdateService;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

public class PaiementService {
    public List<ModeleContratDatePaiement> getAllDatesPaiements(RdbLink em, ModeleContrat mc) {
        Query q = em.createQuery("select p from ModeleContratDatePaiement p WHERE p.modeleContrat=:mc order by p.datePaiement");
        q.setParameter("mc", (Object)mc);
        List paiements = q.getResultList();
        return paiements;
    }

    @DbWrite
    public void updateTextePaiement(ModeleContratDTO dto) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, dto.id);
            if (mc.gestionPaiement != GestionPaiement.NON_GERE) {
                throw new AmapjRuntimeException();
            }
            mc.affichageMontant = dto.affichageMontant;
            mc.textPaiement = dto.textPaiement;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbWrite
    public void updateInfoPaiement(ModeleContratDTO modeleContrat, boolean updateDate) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            if (modeleContrat.gestionPaiement == GestionPaiement.NON_GERE && modeleContrat.datePaiements.size() != 0) {
                throw new AmapjRuntimeException();
            }
            ModeleContrat mc = em.find(ModeleContrat.class, modeleContrat.id);
            mc.gestionPaiement = modeleContrat.gestionPaiement;
            mc.textPaiement = modeleContrat.textPaiement;
            mc.affichageMontant = modeleContrat.affichageMontant;
            mc.dateRemiseCheque = modeleContrat.dateRemiseCheque;
            mc.libCheque = modeleContrat.libCheque;
            mc.saisiePaiementModifiable = modeleContrat.saisiePaiementModifiable;
            mc.saisiePaiementProposition = modeleContrat.saisiePaiementProposition;
            mc.montantChequeMiniCalculProposition = modeleContrat.montantChequeMiniCalculProposition;
            mc.strategiePaiement = modeleContrat.strategiePaiement;
            mc.saisiePaiementCalculDate = modeleContrat.saisiePaiementCalculDate;
            if (updateDate) {
                List<ModeleContratDatePaiement> datesInBase = this.getAllDatesPaiements(em, mc);
                for (ModeleContratDatePaiement modeleContratDatePaiement : datesInBase) {
                    em.remove(modeleContratDatePaiement);
                }
                for (DatePaiementModeleContratDTO datePaiementModeleContratDTO : modeleContrat.datePaiements) {
                    ModeleContratDatePaiement md = new ModeleContratDatePaiement();
                    md.modeleContrat = mc;
                    md.datePaiement = datePaiementModeleContratDTO.datePaiement;
                    em.persist(md);
                }
            }
            new GestionContratSigneUpdateService().markAllContratAsModified(mc, em);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbWrite
    public void deleteInfoPaiement(ModeleContratDTO modeleContrat) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, modeleContrat.id);
            mc.gestionPaiement = GestionPaiement.NON_GERE;
            mc.textPaiement = modeleContrat.textPaiement;
            mc.affichageMontant = modeleContrat.affichageMontant;
            mc.dateRemiseCheque = null;
            mc.libCheque = null;
            mc.saisiePaiementModifiable = SaisiePaiementModifiable.NON_MODIFIABLE;
            mc.saisiePaiementProposition = SaisiePaiementProposition.REPARTI_STRICT;
            mc.montantChequeMiniCalculProposition = 0;
            mc.strategiePaiement = StrategiePaiement.NON_GERE;
            mc.saisiePaiementCalculDate = SaisiePaiementCalculDate.AUTRE;
            TypedQuery<Paiement> q = em.createQuery("select p from Paiement p WHERE p.contrat.modeleContrat.id=:id AND p.etat=:etat", Paiement.class);
            q.setParameter("id", (Object)mc.id);
            q.setParameter("etat", (Object)EtatPaiement.A_FOURNIR);
            SQLUtils.deleteAll(em, q);
            List<ModeleContratDatePaiement> datesInBase = this.getAllDatesPaiements(em, mc);
            for (ModeleContratDatePaiement datePaiement : datesInBase) {
                em.remove(datePaiement);
            }
            new GestionContratSigneUpdateService().markAllContratAsModified(mc, em);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbWrite
    public void updateDatePaiement(ModeleContratDTO modeleContrat) throws OnSaveException {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, modeleContrat.id);
            List<ModeleContratDatePaiement> dateInBases = this.getAllDatesPaiements(em, mc);
            List<Date> dates = this.extractDates(modeleContrat.datePaiements);
            for (ModeleContratDatePaiement dateInBase : dateInBases) {
                Date ref = DateUtils.suppressTime(dateInBase.datePaiement);
                if (dates.contains(ref)) continue;
                int r = this.getNbPaiementForDate(em, dateInBase);
                if (r > 0) {
                    SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
                    String message = "Impossible de supprimer la date de paiement " + df.format(dateInBase.datePaiement) + " car il y a " + r + " paiements pr\u00e9vus \u00e0 cette date";
                    throw new OnSaveException(message);
                }
                em.remove(dateInBase);
            }
            for (Date date : dates) {
                if (this.contains(dateInBases, date)) continue;
                ModeleContratDatePaiement md = new ModeleContratDatePaiement();
                md.modeleContrat = mc;
                md.datePaiement = date;
                em.persist(md);
            }
            new GestionContratSigneUpdateService().markAllContratAsModified(mc, em);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    private boolean contains(List<ModeleContratDatePaiement> dateInBases, Date date) {
        for (ModeleContratDatePaiement mcdp : dateInBases) {
            Date ref = DateUtils.suppressTime(mcdp.datePaiement);
            if (!ref.equals(date)) continue;
            return true;
        }
        return false;
    }

    private int getNbPaiementForDate(RdbLink em, ModeleContratDatePaiement mcdp) {
        Query q = em.createQuery("select count(p.id) from Paiement p WHERE p.modeleContratDatePaiement=:mcdp");
        q.setParameter("mcdp", (Object)mcdp);
        return ((Long)q.getSingleResult()).intValue();
    }

    private List<Date> extractDates(List<DatePaiementModeleContratDTO> datePaiements) throws OnSaveException {
        ArrayList<Date> res = new ArrayList<Date>();
        for (DatePaiementModeleContratDTO dto : datePaiements) {
            Date date = DateUtils.suppressTime(dto.datePaiement);
            if (res.contains(date)) {
                throw new OnSaveException("Il y a une date de paiement en doublon");
            }
            res.add(date);
        }
        return res;
    }

    @DbRead
    public boolean canSuppressPaiementModeleContrat(Long modeleContratId) {
        try {
            boolean bl;
            block3: {
                Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
                RdbLink em = RdbLink.get();
                TypedQuery<Paiement> q = em.createQuery("select p from Paiement p WHERE p.contrat.modeleContrat.id=:id", Paiement.class);
                q.setParameter("id", (Object)modeleContratId);
                for (Paiement paiement : q.getResultList()) {
                    if (paiement.etat == EtatPaiement.A_FOURNIR) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return bl;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }
}

