/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.mespaiements.reception;

import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.DbWrite;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.contrat.reel.EtatPaiement;
import fr.amapj.model.models.contrat.reel.Paiement;
import fr.amapj.service.engine.tools.DbToDto;
import fr.amapj.service.services.mespaiements.reception.ReceptionChequeDTO;
import java.util.List;
import javax.persistence.TypedQuery;

public class ReceptionPaiementsService {
    @DbRead
    public List<ReceptionChequeDTO> getPaiementAReceptionnerContrat(Long contratId) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            TypedQuery<Paiement> q = em.createQuery("select p from Paiement p WHERE p.etat<>:etat and p.contrat.id=:id order by p.modeleContratDatePaiement.datePaiement asc", Paiement.class);
            q.setParameter("etat", (Object)EtatPaiement.PRODUCTEUR);
            q.setParameter("id", (Object)contratId);
            List<ReceptionChequeDTO> list = DbToDto.convert(q, e -> this.createDto((Paiement)e));
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return list;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private ReceptionChequeDTO createDto(Paiement paiement) {
        ReceptionChequeDTO dto = new ReceptionChequeDTO();
        dto.idPaiement = paiement.getId();
        dto.datePaiement = paiement.modeleContratDatePaiement.datePaiement;
        dto.montant = paiement.montant;
        dto.etatPaiement = paiement.etat;
        dto.commentaire1 = paiement.commentaire1;
        dto.commentaire2 = paiement.commentaire2;
        dto.commentaire3 = paiement.commentaire3;
        dto.commentaire4 = paiement.commentaire4;
        dto.nomUtilisateur = paiement.contrat.utilisateur.nom;
        dto.prenomUtilisateur = paiement.contrat.utilisateur.prenom;
        return dto;
    }

    @DbRead
    public List<ReceptionChequeDTO> getPaiementAReceptionnerModeleContrat(Long modeleContratId) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            TypedQuery<Paiement> q = em.createQuery("select p from Paiement p WHERE p.etat<>:etat and p.contrat.modeleContrat.id=:id order by p.modeleContratDatePaiement.datePaiement asc", Paiement.class);
            q.setParameter("etat", (Object)EtatPaiement.PRODUCTEUR);
            q.setParameter("id", (Object)modeleContratId);
            List<ReceptionChequeDTO> list = DbToDto.convert(q, e -> this.createDto((Paiement)e));
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return list;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbWrite
    public void receptionCheque(List<ReceptionChequeDTO> paiementDto) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            for (ReceptionChequeDTO dto : paiementDto) {
                Paiement p = em.find(Paiement.class, dto.idPaiement);
                p.etat = dto.etatPaiement;
                p.commentaire1 = dto.commentaire1;
                p.commentaire2 = dto.commentaire2;
                p.commentaire3 = dto.commentaire3;
                p.commentaire4 = dto.commentaire4;
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }
}

