/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.notification.hourly;

import fr.amapj.common.DateUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.tools.TestTools;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.NewTransaction;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.fichierbase.EtatUtilisateur;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.model.models.param.ChoixOuiNon;
import fr.amapj.model.models.stats.NotificationDone;
import fr.amapj.model.models.stats.TypNotificationDone;
import fr.amapj.service.services.mailer.MailerMessage;
import fr.amapj.service.services.mailer.MailerService;
import fr.amapj.service.services.parametres.ParametresDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.service.services.utilisateur.util.UtilisateurUtil;
import java.util.Date;
import java.util.List;
import javax.persistence.Query;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PeriodiqueNotificationService {
    private static final Logger logger = LogManager.getLogger();

    @DbRead
    public void sendPermanenceNotification() {
        try {
            Date d;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ParametresDTO param = new ParametresService().getParametres();
            if (param.envoiMailPeriodique != ChoixOuiNon.NON && (d = this.getLastNotificationDate(param)) != null) {
                List<Utilisateur> utilisateurs = this.getUtilisateursActifWithNoNotification(d, em);
                for (Utilisateur utilisateur : utilisateurs) {
                    if (!UtilisateurUtil.canSendMailTo(utilisateur)) continue;
                    this.sendMail(utilisateur, d, em, param);
                }
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private List<Utilisateur> getUtilisateursActifWithNoNotification(Date d, RdbLink em) {
        Query q = em.createQuery("select u from Utilisateur u where \tu.etatUtilisateur=:etat and  NOT EXISTS (select d from NotificationDone d where d.typNotificationDone=:typNotif and d.dateMailPeriodique=:d and d.utilisateur=u)  order by u.nom,u.prenom");
        q.setParameter("etat", (Object)EtatUtilisateur.ACTIF);
        q.setParameter("d", (Object)d);
        q.setParameter("typNotif", (Object)TypNotificationDone.MAIL_PERIODIQUE);
        List us = q.getResultList();
        return us;
    }

    private Date getLastNotificationDate(ParametresDTO param) {
        Date ref = DateUtils.getDateWithNoTime();
        int i = 0;
        while (i < 7) {
            Date d = DateUtils.addDays(ref, -i);
            if (DateUtils.getDayInMonth(d) == param.numJourDansMois) {
                return d;
            }
            ++i;
        }
        return null;
    }

    private void sendMail(Utilisateur utilisateur, Date d, RdbLink em, ParametresDTO param) {
        MailerMessage message = new MailerMessage();
        String titre = this.replaceWithContext(param.titreMailPeriodique, em, d, utilisateur, param);
        String content = this.replaceWithContext(param.contenuMailPeriodique, em, d, utilisateur, param);
        message.setTitle(titre);
        message.setContent(content);
        message.setEmail(utilisateur.email);
        this.sendMessageAndMemorize(message, d, utilisateur.getId());
    }

    private void sendMessageAndMemorize(MailerMessage message, Date d, Long utilisateurId) {
        NewTransaction.write(em -> this.sendMessageAndMemorize((RdbLink)em, message, d, utilisateurId));
    }

    protected void sendMessageAndMemorize(RdbLink em, MailerMessage message, Date d, Long utilisateurId) {
        NotificationDone notificationDone = new NotificationDone();
        notificationDone.typNotificationDone = TypNotificationDone.MAIL_PERIODIQUE;
        notificationDone.dateMailPeriodique = d;
        notificationDone.utilisateur = em.find(Utilisateur.class, utilisateurId);
        notificationDone.dateEnvoi = DateUtils.getDate();
        em.persist(notificationDone);
        new MailerService().sendHtmlMail(message);
    }

    private String replaceWithContext(String in, RdbLink em, Date d, Utilisateur u, ParametresDTO param) {
        String link = String.valueOf(param.getUrl()) + "?username=" + u.email;
        in = in.replaceAll("#NOM_AMAP#", param.nomAmap);
        in = in.replaceAll("#VILLE_AMAP#", param.villeAmap);
        in = in.replaceAll("#LINK#", link);
        return in;
    }

    public static void main(String[] args) {
        TestTools.init();
        PeriodiqueNotificationService service = new PeriodiqueNotificationService();
        service.sendPermanenceNotification();
    }
}

