/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.notification.hourly;

import fr.amapj.common.DateUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.tools.TestTools;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.NewTransaction;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.model.models.param.ChoixOuiNon;
import fr.amapj.model.models.permanence.periode.EtatPeriodePermanence;
import fr.amapj.model.models.permanence.reel.PermanenceCell;
import fr.amapj.service.services.mailer.MailerMessage;
import fr.amapj.service.services.mailer.MailerService;
import fr.amapj.service.services.parametres.ParametresDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDateDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceService;
import fr.amapj.service.services.utilisateur.util.UtilisateurUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.persistence.Query;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PermanenceNotificationService {
    private static final Logger logger = LogManager.getLogger();

    @DbRead
    public void sendPermanenceNotification() {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ParametresDTO param = new ParametresService().getParametres();
            if (param.envoiMailRappelPermanence != ChoixOuiNon.NON) {
                Query q = em.createQuery("select pc from PermanenceCell pc where  pc.periodePermanenceDate.periodePermanence.etat=:etat and  pc.periodePermanenceDate.datePerm>=:d1 and  pc.periodePermanenceDate.datePerm<=:d2 and  pc.dateNotification is null  order by pc.periodePermanenceUtilisateur.utilisateur.nom,pc.periodePermanenceUtilisateur.utilisateur.prenom");
                Date d1 = DateUtils.getDate();
                Date d2 = DateUtils.addDays(d1, param.delaiMailRappelPermanence);
                d2 = DateUtils.addHour(d2, -4);
                q.setParameter("etat", (Object)EtatPeriodePermanence.ACTIF);
                q.setParameter("d1", (Object)d1);
                q.setParameter("d2", (Object)d2);
                List pcs = q.getResultList();
                for (PermanenceCell pc : pcs) {
                    Utilisateur utilisateur = pc.periodePermanenceUtilisateur.utilisateur;
                    if (UtilisateurUtil.canSendMailTo(utilisateur)) {
                        this.sendPermanenceNotification(pc, em, param);
                        continue;
                    }
                    this.memorize(em, pc.id);
                }
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private void sendPermanenceNotification(PermanenceCell pc, RdbLink em, ParametresDTO param) {
        MailerMessage message = new MailerMessage();
        Utilisateur utilisateur = pc.periodePermanenceUtilisateur.utilisateur;
        String titre = this.replaceWithContext(param.titreMailRappelPermanence, pc, em, utilisateur, param);
        String content = this.replaceWithContext(param.contenuMailRappelPermanence, pc, em, utilisateur, param);
        message.setTitle(titre);
        message.setContent(content);
        message.setEmail(utilisateur.email);
        this.sendMessageAndMemorize(message, pc.getId());
    }

    private void sendMessageAndMemorize(MailerMessage message, Long idPermanenceCell) {
        NewTransaction.write(em -> this.sendMessageAndMemorize((RdbLink)em, message, idPermanenceCell));
    }

    protected void sendMessageAndMemorize(RdbLink em, MailerMessage message, Long idPermanenceCell) {
        this.memorize(em, idPermanenceCell);
        new MailerService().sendHtmlMail(message);
    }

    private void memorize(RdbLink em, Long idPermanenceCell) {
        PermanenceCell pc = em.find(PermanenceCell.class, idPermanenceCell);
        pc.dateNotification = DateUtils.getDate();
    }

    private String replaceWithContext(String in, PermanenceCell dpu, RdbLink em, Utilisateur u, ParametresDTO param) {
        if (in == null || in.trim().length() == 0) {
            in = "Permanence AMAP";
        }
        SimpleDateFormat df = new SimpleDateFormat("EEEEE dd MMMMM yyyy");
        PeriodePermanenceDateDTO permanenceDTO = new PeriodePermanenceService().loadOneDatePermanence(dpu.periodePermanenceDate.id);
        String link = String.valueOf(param.getUrl()) + "?username=" + u.email;
        in = in.replaceAll("#NOM_AMAP#", param.nomAmap);
        in = in.replaceAll("#VILLE_AMAP#", param.villeAmap);
        in = in.replaceAll("#LINK#", link);
        in = in.replaceAll("#DATE_PERMANENCE#", df.format(dpu.periodePermanenceDate.datePerm));
        in = in.replaceAll("#PERSONNES#", permanenceDTO.getNomInscrit());
        in = in.replaceAll("#PERSONNES_AVEC_ROLES#", permanenceDTO.getNomInscritWithRoles("<br/>"));
        in = in.replaceAll("#ROLES#", permanenceDTO.getRolesAsString(u.id));
        return in;
    }

    public static void main(String[] args) {
        TestTools.init();
        PermanenceNotificationService service = new PermanenceNotificationService();
        service.sendPermanenceNotification();
    }
}

