/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.notification.hourly.producteur;

import fr.amapj.common.DateUtils;
import fr.amapj.common.StackUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.contrat.modele.EtatModeleContrat;
import fr.amapj.model.models.fichierbase.Producteur;
import fr.amapj.service.engine.deamons.DeamonsContext;
import fr.amapj.service.services.notification.hourly.producteur.ProducteurFeuilleLivraisonNotificationService;
import fr.amapj.service.services.notification.hourly.producteur.ProducteurInscriptionRetardataireNotificationService;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProducteurNotificationService {
    private static final Logger logger = LogManager.getLogger();

    @DbRead
    public void sendProducteurNotification(DeamonsContext deamonsContext) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            em.createQuery("select distinct(mcd.modeleContrat.producteur) from ModeleContratDate mcd where mcd.dateLiv>=:d1 and mcd.modeleContrat.etat=:etat");
            em.setParameter("d1", DateUtils.getDate());
            em.setParameter("etat", (Object)EtatModeleContrat.ACTIF);
            List<Producteur> prods = em.result().list(Producteur.class);
            for (Producteur producteur : prods) {
                logger.info("Debut de notification du producteur : " + producteur.nom);
                try {
                    new ProducteurFeuilleLivraisonNotificationService().sendFeuilleLivraison(producteur, em, deamonsContext);
                    new ProducteurInscriptionRetardataireNotificationService().sendInscriptionRetardataire(producteur, em, deamonsContext);
                }
                catch (Exception e) {
                    ++deamonsContext.nbError;
                    logger.info("Erreur pour le producteur " + producteur.nom + "\n" + StackUtils.asString(e));
                }
                logger.info("Fin de notification du producteur : " + producteur.nom);
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }
}

