/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.permanence.detailperiode;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.CollectionUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.DbWrite;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.model.models.permanence.periode.PeriodePermanence;
import fr.amapj.model.models.permanence.periode.PeriodePermanenceDate;
import fr.amapj.model.models.permanence.periode.PeriodePermanenceUtilisateur;
import fr.amapj.model.models.permanence.periode.PermanenceRole;
import fr.amapj.model.models.permanence.reel.PermanenceCell;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDateDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceService;
import fr.amapj.service.services.permanence.periode.PermanenceCellDTO;
import fr.amapj.service.services.utilisateur.util.UtilisateurUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Query;

public class DetailPeriodePermanenceService {
    @DbWrite
    public void updateDetailPeriodePermanence(PeriodePermanenceDateDTO dto) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            new PeriodePermanenceService().lockOneDate(em, dto.idPeriodePermanenceDate);
            PeriodePermanenceDate ppd = em.find(PeriodePermanenceDate.class, dto.idPeriodePermanenceDate);
            for (PermanenceCellDTO pcDto : dto.permanenceCellDTOs) {
                PermanenceCell c = em.find(PermanenceCell.class, pcDto.idPermanenceCell);
                c.periodePermanenceUtilisateur = pcDto.idUtilisateur == null ? null : this.findPeriodePermanenceUtilisateur(em, pcDto.idUtilisateur, ppd.periodePermanence);
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    public PeriodePermanenceUtilisateur findPeriodePermanenceUtilisateur(RdbLink em, Long idUtilisateur, PeriodePermanence p) {
        Query q = em.createQuery("select c from PeriodePermanenceUtilisateur c WHERE c.periodePermanence=:p AND c.utilisateur.id=:uid");
        q.setParameter("p", (Object)p);
        q.setParameter("uid", (Object)idUtilisateur);
        List ppus = q.getResultList();
        if (ppus.size() == 1) {
            return (PeriodePermanenceUtilisateur)ppus.get(0);
        }
        throw new AmapjRuntimeException("size = " + ppus.size());
    }

    @DbRead
    public List<Utilisateur> computeAllowedUser(Long idDatePeriodePermanence) {
        try {
            List us;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            PeriodePermanenceDate ppd = em.find(PeriodePermanenceDate.class, idDatePeriodePermanence);
            PeriodePermanence p = ppd.periodePermanence;
            Query q = em.createQuery("select c.utilisateur from PeriodePermanenceUtilisateur c WHERE c.periodePermanence=:p order by c.utilisateur.nom, c.utilisateur.prenom");
            q.setParameter("p", (Object)p);
            List list = us = q.getResultList();
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return list;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public String getDeleteInscriptionInfo(PeriodePermanenceDTO dto) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            StringBuffer buf = new StringBuffer();
            PeriodePermanence pp = em.find(PeriodePermanence.class, dto.id);
            Query q = em.createQuery("select d from PeriodePermanenceDate d where  d.periodePermanence=:pp and d.datePerm >= :debut and  d.datePerm <= :fin");
            q.setParameter("pp", (Object)pp);
            q.setParameter("debut", (Object)dto.dateDebut);
            q.setParameter("fin", (Object)dto.dateFin);
            List mcds = q.getResultList();
            SimpleDateFormat df = new SimpleDateFormat("EEEEE dd MMMMM yyyy");
            buf.append("Les inscriptions sur " + mcds.size() + " dates de permanences suivantes vont \u00eatre supprim\u00e9es:<br/>");
            for (PeriodePermanenceDate modeleContratDate : mcds) {
                buf.append(" - " + df.format(modeleContratDate.datePerm) + "<br/>");
            }
            buf.append("<br/>");
            q = em.createQuery("select distinct(c.periodePermanenceUtilisateur.utilisateur) from PermanenceCell c where  c.periodePermanenceDate.periodePermanence=:pp and  c.periodePermanenceDate.datePerm >= :debut and  c.periodePermanenceDate.datePerm <= :fin  order by c.periodePermanenceUtilisateur.utilisateur.nom,c.periodePermanenceUtilisateur.utilisateur.prenom");
            q.setParameter("pp", (Object)pp);
            q.setParameter("debut", (Object)dto.dateDebut);
            q.setParameter("fin", (Object)dto.dateFin);
            List utilisateurs = q.getResultList();
            buf.append(UtilisateurUtil.getUtilisateurImpactes(utilisateurs));
            String string = buf.toString();
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return string;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbWrite
    public void performDeleteInscription(PeriodePermanenceDTO dto) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            PeriodePermanence pp = em.find(PeriodePermanence.class, dto.id);
            Query q = em.createQuery("select c from PermanenceCell c where  c.periodePermanenceDate.periodePermanence=:pp and  c.periodePermanenceDate.datePerm >= :debut and  c.periodePermanenceDate.datePerm <= :fin");
            q.setParameter("pp", (Object)pp);
            q.setParameter("debut", (Object)dto.dateDebut);
            q.setParameter("fin", (Object)dto.dateFin);
            List pcs = q.getResultList();
            for (PermanenceCell pc : pcs) {
                pc.periodePermanenceUtilisateur = null;
                pc.dateNotification = null;
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbWrite
    public void updateRoleAndUtilisateur(PeriodePermanenceDateDTO dto) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            new PeriodePermanenceService().lockOneDate(em, dto.idPeriodePermanenceDate);
            PeriodePermanenceDate ppd = em.find(PeriodePermanenceDate.class, dto.idPeriodePermanenceDate);
            ppd.nbPlace = dto.permanenceCellDTOs.size();
            Query q = em.createQuery("select c from PermanenceCell c WHERE c.periodePermanenceDate=:ppd");
            q.setParameter("ppd", (Object)ppd);
            List pcs = q.getResultList();
            ArrayList<PermanenceCellDTO> oldCells = new ArrayList<PermanenceCellDTO>();
            int i = 0;
            while (i < pcs.size()) {
                PermanenceCell pc = (PermanenceCell)pcs.get(i);
                PermanenceCellDTO pcDto = new PeriodePermanenceService().createPermanenceCellDTO(pc);
                oldCells.add(pcDto);
                em.remove(pc);
                ++i;
            }
            i = 0;
            while (i < ppd.nbPlace) {
                PermanenceCellDTO pcDto = dto.permanenceCellDTOs.get(i);
                PermanenceCell pc = new PermanenceCell();
                pc.periodePermanenceDate = ppd;
                pc.permanenceRole = em.find(PermanenceRole.class, pcDto.idRole);
                if (pcDto.idUtilisateur != null) {
                    pc.periodePermanenceUtilisateur = this.findPeriodePermanenceUtilisateur(em, pcDto.idUtilisateur, ppd.periodePermanence);
                    pc.dateNotification = CollectionUtils.findMatching(oldCells, e -> e.idPeriodePermanenceUtilisateur == permanenceCellDTO.idPeriodePermanenceUtilisateur && e.idRole == permanenceCellDTO.idRole, e -> e.dateNotification);
                }
                pc.indx = i++;
                em.persist(pc);
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }
}

