/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.permanence.mespermanences;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.DateUtils;
import fr.amapj.common.SQLUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.DbWrite;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.model.models.param.ChoixOuiNon;
import fr.amapj.model.models.permanence.periode.EtatPeriodePermanence;
import fr.amapj.model.models.permanence.periode.NaturePeriodePermanence;
import fr.amapj.model.models.permanence.periode.PeriodePermanence;
import fr.amapj.model.models.permanence.periode.PeriodePermanenceDate;
import fr.amapj.model.models.permanence.periode.PeriodePermanenceUtilisateur;
import fr.amapj.model.models.permanence.periode.RegleInscriptionPeriodePermanence;
import fr.amapj.model.models.permanence.reel.PermanenceCell;
import fr.amapj.service.services.permanence.detailperiode.DetailPeriodePermanenceService;
import fr.amapj.service.services.permanence.mespermanences.MesPermanenceDTO;
import fr.amapj.service.services.permanence.mespermanences.UnePeriodePermanenceDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDateDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceService;
import fr.amapj.service.services.permanence.periode.SmallPeriodePermanenceDTO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.TemporalType;

public class MesPermanencesService {
    @DbRead
    public MesPermanenceDTO getMesPermanenceDTO(Long userId) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            Date nowNoTime = DateUtils.getDateWithNoTime();
            RdbLink em = RdbLink.get();
            MesPermanenceDTO res = new MesPermanenceDTO();
            Utilisateur user = em.find(Utilisateur.class, userId);
            Query q = em.createQuery("select ppu from PeriodePermanenceUtilisateur ppu WHERE  ppu.periodePermanence.etat=:etat and  :d<=ppu.periodePermanence.dateFinInscription and  ppu.periodePermanence.nature=:t1 and  ppu.utilisateur.id = :uid  order by ppu.periodePermanence.dateFinInscription asc , ppu.periodePermanence.nom , ppu.periodePermanence.id");
            q.setParameter("etat", (Object)EtatPeriodePermanence.ACTIF);
            q.setParameter("t1", (Object)NaturePeriodePermanence.INSCRIPTION_LIBRE_AVEC_DATE_LIMITE);
            q.setParameter("d", (Object)nowNoTime);
            q.setParameter("uid", (Object)userId);
            List pps1 = q.getResultList();
            q = em.createQuery("select ppu from PeriodePermanenceUtilisateur ppu WHERE  ppu.periodePermanence.etat=:etat and  EXISTS (select ppd from PeriodePermanenceDate ppd where ppd.periodePermanence.id=ppu.periodePermanence.id and ppd.datePerm>=:d) and  ppu.periodePermanence.nature=:t1 and  ppu.utilisateur.id = :uid  order by ppu.periodePermanence.dateFinInscription asc , ppu.periodePermanence.nom , ppu.periodePermanence.id");
            q.setParameter("etat", (Object)EtatPeriodePermanence.ACTIF);
            q.setParameter("t1", (Object)NaturePeriodePermanence.INSCRIPTION_LIBRE_FLOTTANT);
            q.setParameter("d", (Object)nowNoTime);
            q.setParameter("uid", (Object)userId);
            List<PeriodePermanenceUtilisateur> pps2 = q.getResultList();
            pps2 = this.filterFlottant(pps2, em, nowNoTime);
            ArrayList<PeriodePermanenceUtilisateur> pps = new ArrayList<PeriodePermanenceUtilisateur>();
            pps.addAll(pps1);
            pps.addAll(pps2);
            for (PeriodePermanenceUtilisateur periodePermanenceUtilisateur : pps) {
                PeriodePermanence periodePermanence = periodePermanenceUtilisateur.periodePermanence;
                UnePeriodePermanenceDTO up = this.createUnePeriodePermanenceDTO(em, periodePermanence, periodePermanenceUtilisateur, nowNoTime);
                res.mesPeriodesPermanences.add(up);
            }
            res.mesPermanencesFutures = this.getDistributionsFutures(em, user);
            MesPermanenceDTO mesPermanenceDTO = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return mesPermanenceDTO;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private List<PeriodePermanenceUtilisateur> filterFlottant(List<PeriodePermanenceUtilisateur> pps, RdbLink em, Date now) {
        ArrayList<PeriodePermanenceUtilisateur> res = new ArrayList<PeriodePermanenceUtilisateur>();
        for (PeriodePermanenceUtilisateur ppu : pps) {
            if (!this.isModifiable(ppu.periodePermanence, em, now)) continue;
            res.add(ppu);
        }
        return res;
    }

    private boolean isModifiable(PeriodePermanence periodePermanence, RdbLink em, Date now) {
        int delai = periodePermanence.flottantDelai;
        Date ref = DateUtils.addDays(now, delai);
        Query q = em.createQuery("select count(ppd) from PeriodePermanenceDate ppd where ppd.periodePermanence=:pp and ppd.datePerm>:ref");
        q.setParameter("pp", (Object)periodePermanence);
        q.setParameter("ref", (Object)ref);
        return SQLUtils.toInt(q.getSingleResult()) >= 1;
    }

    public List<PeriodePermanenceDateDTO> getDistributionsFutures(RdbLink em, Utilisateur user) {
        Date dateDebut = DateUtils.firstMonday(DateUtils.getDate());
        Query q = em.createQuery("select distinct(pc.periodePermanenceDate) from PermanenceCell pc WHERE pc.periodePermanenceDate.periodePermanence.etat=:etat and pc.periodePermanenceDate.datePerm>=:deb and pc.periodePermanenceUtilisateur.utilisateur=:user order by pc.periodePermanenceDate.datePerm");
        q.setParameter("etat", (Object)EtatPeriodePermanence.ACTIF);
        q.setParameter("deb", dateDebut, TemporalType.DATE);
        q.setParameter("user", (Object)user);
        List ppds = q.getResultList();
        ArrayList<PeriodePermanenceDateDTO> res = new ArrayList<PeriodePermanenceDateDTO>();
        for (PeriodePermanenceDate ppd : ppds) {
            PeriodePermanenceDateDTO dto = new PeriodePermanenceService().loadOneDatePermanence(ppd.id);
            res.add(dto);
        }
        return res;
    }

    private UnePeriodePermanenceDTO createUnePeriodePermanenceDTO(RdbLink em, PeriodePermanence p, PeriodePermanenceUtilisateur ppu, Date nowNoTime) {
        UnePeriodePermanenceDTO dto = new UnePeriodePermanenceDTO();
        PeriodePermanenceService.DateInfo di = new PeriodePermanenceService().getDateDebutFin(em, p);
        dto.idPeriodePermanence = p.id;
        dto.nature = p.nature;
        dto.nom = p.nom;
        dto.description = p.description;
        dto.dateFinInscription = p.dateFinInscription;
        dto.dateDebut = di.dateDebut;
        dto.dateFin = di.dateFin;
        dto.nbDatePermanence = di.nbDatePerm;
        dto.nbSouhaite = ppu.nbParticipation;
        Query q = em.createQuery("select count(c) from PermanenceCell c WHERE c.periodePermanenceUtilisateur=:ppu");
        q.setParameter("ppu", (Object)ppu);
        dto.nbInscription = SQLUtils.toInt(q.getSingleResult());
        if (p.nature == NaturePeriodePermanence.INSCRIPTION_LIBRE_FLOTTANT) {
            dto.firstDateModifiable = this.computeFirstDateModifiable(p, em, nowNoTime);
        }
        dto.regleInscription = p.regleInscription;
        dto.depassementAutorise = p.depassementAutorise;
        return dto;
    }

    private Date computeFirstDateModifiable(PeriodePermanence p, RdbLink em, Date nowNoTime) {
        int delai = p.flottantDelai;
        Date ref = DateUtils.addDays(nowNoTime, delai);
        Query q = em.createQuery("select ppd from PeriodePermanenceDate ppd where ppd.periodePermanence=:pp and ppd.datePerm>:ref order by ppd.datePerm");
        q.setParameter("pp", (Object)p);
        q.setParameter("ref", (Object)ref);
        List ppds = q.getResultList();
        if (ppds.size() == 0) {
            return null;
        }
        return ((PeriodePermanenceDate)ppds.get((int)0)).datePerm;
    }

    @DbRead
    public UnePeriodePermanenceDTO loadCompteurPeriodePermanence(Long idPeriodePermanence, Long userId) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            PeriodePermanence p = em.find(PeriodePermanence.class, idPeriodePermanence);
            PeriodePermanenceUtilisateur ppu = new DetailPeriodePermanenceService().findPeriodePermanenceUtilisateur(em, userId, p);
            UnePeriodePermanenceDTO unePeriodePermanenceDTO = this.createUnePeriodePermanenceDTO(em, p, ppu, DateUtils.getDateWithNoTime());
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return unePeriodePermanenceDTO;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbWrite
    public InscriptionMessage inscription(Long userId, Long idPeriodePermanenceDate, Long idRole, RegleInscriptionPeriodePermanence regle) {
        try {
            InscriptionMessage inscriptionMessage;
            block11: {
                Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
                RdbLink em = RdbLink.get();
                new PeriodePermanenceService().lockOneDate(em, idPeriodePermanenceDate);
                PeriodePermanenceDate ppd = em.find(PeriodePermanenceDate.class, idPeriodePermanenceDate);
                Query q = em.createQuery("select c from PermanenceCell c WHERE c.periodePermanenceDate=:ppd order by c.indx");
                q.setParameter("ppd", (Object)ppd);
                List pcs = q.getResultList();
                PeriodePermanenceUtilisateur ppu = new DetailPeriodePermanenceService().findPeriodePermanenceUtilisateur(em, userId, ppd.periodePermanence);
                if (ppu == null) {
                    throw new AmapjRuntimeException("Vous ne pouvez pas vous inscrire \u00e0 cette p\u00e9riode");
                }
                if (regle == RegleInscriptionPeriodePermanence.UNE_INSCRIPTION_PAR_DATE) {
                    for (PermanenceCell pc : pcs) {
                        if (pc.periodePermanenceUtilisateur == null || !pc.periodePermanenceUtilisateur.utilisateur.getId().equals(userId)) continue;
                        inscriptionMessage = InscriptionMessage.DEJA_INSCRIT_CETTE_DATE;
                        break block11;
                    }
                } else {
                    for (PermanenceCell pc : pcs) {
                        if (pc.periodePermanenceUtilisateur == null || !pc.periodePermanenceUtilisateur.utilisateur.getId().equals(userId) || !pc.permanenceRole.id.equals(idRole)) continue;
                        inscriptionMessage = InscriptionMessage.DEJA_INSCRIT_CETTE_DATE;
                        break block11;
                    }
                }
                q = em.createQuery("select count(c) from PermanenceCell c WHERE c.periodePermanenceUtilisateur=:ppu");
                q.setParameter("ppu", (Object)ppu);
                int nbInscriptionReel = SQLUtils.toInt(q.getSingleResult());
                if (nbInscriptionReel >= ppu.nbParticipation && ppu.periodePermanence.depassementAutorise == ChoixOuiNon.NON) {
                    inscriptionMessage = InscriptionMessage.NOMBRE_SUFFISANT;
                } else {
                    PermanenceCell pc = this.findPlaceDisponible(pcs, idRole);
                    if (pc == null) {
                        inscriptionMessage = InscriptionMessage.PAS_DE_PLACE_CETTE_DATE;
                    } else {
                        pc.periodePermanenceUtilisateur = ppu;
                        inscriptionMessage = null;
                    }
                }
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return inscriptionMessage;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    private PermanenceCell findPlaceDisponible(List<PermanenceCell> pcs, Long idRole) {
        for (PermanenceCell pc : pcs) {
            if (pc.periodePermanenceUtilisateur != null || !pc.permanenceRole.id.equals(idRole)) continue;
            return pc;
        }
        return null;
    }

    @DbWrite
    public void deleteInscription(Long userId, Long idPeriodePermanenceDate) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            new PeriodePermanenceService().lockOneDate(em, idPeriodePermanenceDate);
            PeriodePermanenceDate ppd = em.find(PeriodePermanenceDate.class, idPeriodePermanenceDate);
            Query q = em.createQuery("select c from PermanenceCell c WHERE c.periodePermanenceDate=:ppd");
            q.setParameter("ppd", (Object)ppd);
            List pcs = q.getResultList();
            for (PermanenceCell pc : pcs) {
                if (pc.periodePermanenceUtilisateur == null || !pc.periodePermanenceUtilisateur.utilisateur.getId().equals(userId)) continue;
                pc.dateNotification = null;
                pc.periodePermanenceUtilisateur = null;
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbWrite
    public void deleteInscriptionRoleDifferent(Long userId, Long idPeriodePermanenceDate, Long idRole) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            new PeriodePermanenceService().lockOneDate(em, idPeriodePermanenceDate);
            PeriodePermanenceDate ppd = em.find(PeriodePermanenceDate.class, idPeriodePermanenceDate);
            Query q = em.createQuery("select c from PermanenceCell c WHERE c.periodePermanenceDate=:ppd");
            q.setParameter("ppd", (Object)ppd);
            List pcs = q.getResultList();
            for (PermanenceCell pc : pcs) {
                if (pc.periodePermanenceUtilisateur == null || !pc.periodePermanenceUtilisateur.utilisateur.getId().equals(userId) || !pc.permanenceRole.id.equals(idRole)) continue;
                pc.dateNotification = null;
                pc.periodePermanenceUtilisateur = null;
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbWrite
    public InscriptionMessage inscriptionToutAutorise(Long userId, Long idPeriodePermanenceCell, Long idPeriodePermanenceDate) {
        try {
            InscriptionMessage inscriptionMessage;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            new PeriodePermanenceService().lockOneDate(em, idPeriodePermanenceDate);
            PeriodePermanenceDate ppd = em.find(PeriodePermanenceDate.class, idPeriodePermanenceDate);
            PeriodePermanenceUtilisateur ppu = new DetailPeriodePermanenceService().findPeriodePermanenceUtilisateur(em, userId, ppd.periodePermanence);
            if (ppu == null) {
                throw new AmapjRuntimeException("Vous ne pouvez pas vous inscrire \u00e0 cette p\u00e9riode");
            }
            Query q = em.createQuery("select count(c) from PermanenceCell c WHERE c.periodePermanenceUtilisateur=:ppu");
            q.setParameter("ppu", (Object)ppu);
            int nbInscriptionReel = SQLUtils.toInt(q.getSingleResult());
            if (nbInscriptionReel >= ppu.nbParticipation && ppu.periodePermanence.depassementAutorise == ChoixOuiNon.NON) {
                inscriptionMessage = InscriptionMessage.NOMBRE_SUFFISANT;
            } else {
                PermanenceCell cell = em.find(PermanenceCell.class, idPeriodePermanenceCell);
                if (cell.periodePermanenceUtilisateur != null) {
                    inscriptionMessage = InscriptionMessage.PLACE_NON_DISPONIBLE;
                } else {
                    cell.periodePermanenceUtilisateur = ppu;
                    inscriptionMessage = null;
                }
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return inscriptionMessage;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbWrite
    public void deleteInscriptionToutAutorise(Long userId, Long idPeriodePermanenceCell, Long idPeriodePermanenceDate) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            new PeriodePermanenceService().lockOneDate(em, idPeriodePermanenceDate);
            PermanenceCell cell = em.find(PermanenceCell.class, idPeriodePermanenceCell);
            if (cell.periodePermanenceUtilisateur != null && cell.periodePermanenceUtilisateur.utilisateur.getId().equals(userId)) {
                cell.dateNotification = null;
                cell.periodePermanenceUtilisateur = null;
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbRead
    public List<SmallPeriodePermanenceDTO> getAllPeriodeInFuture() {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Date dateDebut = DateUtils.getDateWithNoTime();
            Query q = em.createQuery("select distinct(pc.periodePermanence) from PeriodePermanenceDate pc WHERE pc.periodePermanence.etat=:etat and pc.datePerm>=:deb order by pc.periodePermanence.id");
            q.setParameter("etat", (Object)EtatPeriodePermanence.ACTIF);
            q.setParameter("deb", dateDebut, TemporalType.DATE);
            List ppds = q.getResultList();
            ArrayList<SmallPeriodePermanenceDTO> dtos = new ArrayList<SmallPeriodePermanenceDTO>();
            for (PeriodePermanence ppd : ppds) {
                SmallPeriodePermanenceDTO dto = new SmallPeriodePermanenceDTO();
                dto.id = ppd.id;
                dto.nom = ppd.nom;
                dtos.add(dto);
            }
            ArrayList<SmallPeriodePermanenceDTO> arrayList = dtos;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return arrayList;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    public static enum InscriptionMessage {
        DEJA_INSCRIT_CETTE_DATE,
        NOMBRE_SUFFISANT,
        PAS_DE_PLACE_CETTE_DATE,
        PLACE_NON_DISPONIBLE;

    }
}

