/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.permanence.periode;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.DateUtils;
import fr.amapj.common.FormatUtils;
import fr.amapj.common.SQLUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.DbWrite;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.fichierbase.EtatUtilisateur;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.model.models.permanence.periode.EtatPeriodePermanence;
import fr.amapj.model.models.permanence.periode.PeriodePermanence;
import fr.amapj.model.models.permanence.periode.PeriodePermanenceDate;
import fr.amapj.model.models.permanence.periode.PeriodePermanenceUtilisateur;
import fr.amapj.model.models.permanence.periode.PermanenceRole;
import fr.amapj.model.models.permanence.reel.PermanenceCell;
import fr.amapj.service.engine.tools.DbToDto;
import fr.amapj.service.services.archivage.tools.SuppressionState;
import fr.amapj.service.services.gestioncotisation.GestionCotisationService;
import fr.amapj.service.services.parametres.ParametresArchivageDTO;
import fr.amapj.service.services.permanence.periode.FrequencePermanence;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDateDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceUtilisateurDTO;
import fr.amapj.service.services.permanence.periode.PermanenceCellDTO;
import fr.amapj.service.services.permanence.periode.SmallPeriodePermanenceDTO;
import fr.amapj.service.services.permanence.role.PermanenceRoleService;
import fr.amapj.service.services.utilisateur.UtilisateurService;
import fr.amapj.view.engine.popup.suppressionpopup.UnableToSuppressException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;

public class PeriodePermanenceService {
    @DbRead
    public List<SmallPeriodePermanenceDTO> getAllPeriodePermanence() {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ArrayList<SmallPeriodePermanenceDTO> res = new ArrayList<SmallPeriodePermanenceDTO>();
            Query q = em.createQuery("select p from PeriodePermanence p");
            List ps = q.getResultList();
            for (PeriodePermanence p : ps) {
                SmallPeriodePermanenceDTO dto = this.createSmallPeriodePermanenceDTO(em, p);
                res.add(dto);
            }
            ArrayList<SmallPeriodePermanenceDTO> arrayList = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return arrayList;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    public SmallPeriodePermanenceDTO createSmallPeriodePermanenceDTO(RdbLink em, PeriodePermanence p) {
        SmallPeriodePermanenceDTO dto = new SmallPeriodePermanenceDTO();
        dto.id = p.id;
        dto.nom = p.nom;
        DateInfo di = this.getDateDebutFin(em, p);
        dto.dateDebut = di.dateDebut;
        dto.dateFin = di.dateFin;
        dto.nbDatePerm = di.nbDatePerm;
        dto.etat = p.etat;
        dto.pourcentageInscription = this.getPourcentageInscription(p, em);
        return dto;
    }

    @DbRead
    public List<PeriodePermanenceDTO> getAllPermanenceDTO(Long userId) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            TypedQuery<PeriodePermanence> q = em.createQuery("select distinct(d.periodePermanence) from PeriodePermanenceUtilisateur d WHERE d.utilisateur.id=:id", PeriodePermanence.class);
            q.setParameter("id", (Object)userId);
            List<PeriodePermanenceDTO> list = DbToDto.convert(q, e -> this.loadPeriodePermanenceDTO(e.id));
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return list;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public PeriodePermanenceDTO loadPeriodePermanenceDTO(Long idPeriodePermanence) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            PeriodePermanence p = em.find(PeriodePermanence.class, idPeriodePermanence);
            PeriodePermanenceDTO dto = this.createPeriodePermanenceDTO(em, p);
            Query q = em.createQuery("select c from PeriodePermanenceDate c WHERE c.periodePermanence=:p ORDER BY c.datePerm");
            q.setParameter("p", (Object)p);
            List pds = q.getResultList();
            for (PeriodePermanenceDate pd : pds) {
                PeriodePermanenceDateDTO ddto = this.createPeriodePermanenceDateDTO(pd);
                dto.datePerms.add(ddto);
            }
            q = em.createQuery("select c from PermanenceCell c WHERE c.periodePermanenceDate.periodePermanence=:p order by c.indx");
            q.setParameter("p", (Object)p);
            List pcs = q.getResultList();
            int i = 0;
            while (i < pcs.size()) {
                PermanenceCell pc = (PermanenceCell)pcs.get(i);
                PermanenceCellDTO pcDto = this.createPermanenceCellDTO(pc);
                PeriodePermanenceDateDTO ddto = this.findPeriodePermanenceDateDTO(dto.datePerms, pc.periodePermanenceDate.id);
                ddto.permanenceCellDTOs.add(pcDto);
                ++i;
            }
            for (PeriodePermanenceDateDTO ddto : dto.datePerms) {
                int i2 = 0;
                while (i2 < ddto.permanenceCellDTOs.size()) {
                    PermanenceCellDTO pcDto = ddto.permanenceCellDTOs.get(i2);
                    pcDto.lib = this.computeLib(pcDto.nomRole, pcDto.idRole, ddto.permanenceCellDTOs, i2);
                    ++i2;
                }
            }
            q = em.createQuery("select d from PeriodePermanenceUtilisateur d WHERE d.periodePermanence=:p ORDER BY d.utilisateur.nom,d.utilisateur.prenom,d.utilisateur.id");
            q.setParameter("p", (Object)p);
            List ps = q.getResultList();
            for (PeriodePermanenceUtilisateur ppu : ps) {
                PeriodePermanenceUtilisateurDTO adto = this.createPeriodePermanenceUtilisateurDTO(ppu);
                dto.utilisateurs.add(adto);
            }
            PeriodePermanenceDTO periodePermanenceDTO = dto;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return periodePermanenceDTO;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    public PeriodePermanenceDateDTO createPeriodePermanenceDateDTO(PeriodePermanenceDate pd) {
        PeriodePermanenceDateDTO ddto = new PeriodePermanenceDateDTO();
        ddto.nomPeriode = pd.periodePermanence.nom;
        ddto.idPeriodePermanenceDate = pd.id;
        ddto.datePerm = pd.datePerm;
        ddto.nbPlace = pd.nbPlace;
        ddto.regleInscription = pd.periodePermanence.regleInscription;
        return ddto;
    }

    public PermanenceCellDTO createPermanenceCellDTO(PermanenceCell pc) {
        PermanenceCellDTO pcDto = new PermanenceCellDTO();
        pcDto.idPermanenceCell = pc.id;
        if (pc.periodePermanenceUtilisateur != null) {
            Utilisateur u = pc.periodePermanenceUtilisateur.utilisateur;
            pcDto.idUtilisateur = u.getId();
            pcDto.nom = u.nom;
            pcDto.prenom = u.prenom;
            pcDto.idPeriodePermanenceUtilisateur = pc.periodePermanenceUtilisateur.id;
        }
        pcDto.idRole = pc.permanenceRole.id;
        pcDto.nomRole = pc.permanenceRole.nom;
        pcDto.dateNotification = pc.dateNotification;
        pcDto.lib = null;
        return pcDto;
    }

    private String computeLib(String nomRole, Long idRole, List<PermanenceCellDTO> permanenceCellDTOs, int i) {
        if (this.isUniqueRole(idRole, permanenceCellDTOs)) {
            return nomRole;
        }
        return String.valueOf(nomRole) + " (" + this.findNbOccurrence(idRole, permanenceCellDTOs, i) + ")";
    }

    private int findNbOccurrence(Long idRole, List<PermanenceCellDTO> permanenceCellDTOs, int rang) {
        int nb = 0;
        int i = 0;
        while (i <= rang) {
            PermanenceCellDTO pc = permanenceCellDTOs.get(i);
            if (pc.idRole == idRole) {
                ++nb;
            }
            ++i;
        }
        return nb;
    }

    private boolean isUniqueRole(Long idRole, List<PermanenceCellDTO> permanenceCellDTOs) {
        int nb = 0;
        for (PermanenceCellDTO pc : permanenceCellDTOs) {
            if (pc.idRole != idRole) continue;
            ++nb;
        }
        return nb == 1;
    }

    public PeriodePermanenceUtilisateurDTO createPeriodePermanenceUtilisateurDTO(PeriodePermanenceUtilisateur ppu) {
        PeriodePermanenceUtilisateurDTO adto = new PeriodePermanenceUtilisateurDTO();
        adto.idPeriodePermanenceUtilisateur = ppu.id;
        adto.idUtilisateur = ppu.utilisateur.getId();
        adto.nom = ppu.utilisateur.nom;
        adto.prenom = ppu.utilisateur.prenom;
        adto.nbParticipation = ppu.nbParticipation;
        return adto;
    }

    private PeriodePermanenceDTO createPeriodePermanenceDTO(RdbLink em, PeriodePermanence p) {
        PeriodePermanenceDTO dto = new PeriodePermanenceDTO();
        dto.id = p.id;
        dto.nom = p.nom;
        dto.description = p.description;
        dto.flottantDelai = p.flottantDelai;
        DateInfo di = this.getDateDebutFin(em, p);
        dto.dateDebut = di.dateDebut;
        dto.dateFin = di.dateFin;
        dto.nbDatePerm = di.nbDatePerm;
        dto.nbUtilisateur = this.getNbPeriodePermanenceUtilisateur(p, em);
        dto.dateFinInscription = p.dateFinInscription;
        dto.etat = p.etat;
        dto.nature = p.nature;
        dto.pourcentageInscription = this.getPourcentageInscription(p, em);
        dto.regleInscription = p.regleInscription;
        dto.depassementAutorise = p.depassementAutorise;
        return dto;
    }

    private PeriodePermanenceDateDTO findPeriodePermanenceDateDTO(List<PeriodePermanenceDateDTO> datePerms, Long id) {
        for (PeriodePermanenceDateDTO detailPeriodePermanenceDTO : datePerms) {
            if (!detailPeriodePermanenceDTO.idPeriodePermanenceDate.equals(id)) continue;
            return detailPeriodePermanenceDTO;
        }
        throw new AmapjRuntimeException();
    }

    @DbRead
    public PeriodePermanenceDateDTO loadOneDatePermanence(Long idPeriodePermanenceDate) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            PeriodePermanenceDate ppd = em.find(PeriodePermanenceDate.class, idPeriodePermanenceDate);
            PeriodePermanenceDateDTO dto = this.createPeriodePermanenceDateDTO(ppd);
            Query q = em.createQuery("select c from PermanenceCell c WHERE c.periodePermanenceDate=:ppd order by c.indx");
            q.setParameter("ppd", (Object)ppd);
            List pcs = q.getResultList();
            int i = 0;
            while (i < pcs.size()) {
                PermanenceCell pc = (PermanenceCell)pcs.get(i);
                PermanenceCellDTO pcDto = this.createPermanenceCellDTO(pc);
                dto.permanenceCellDTOs.add(pcDto);
                ++i;
            }
            i = 0;
            while (i < dto.permanenceCellDTOs.size()) {
                PermanenceCellDTO pcDto = dto.permanenceCellDTOs.get(i);
                pcDto.lib = this.computeLib(pcDto.nomRole, pcDto.idRole, dto.permanenceCellDTOs, i);
                ++i;
            }
            PeriodePermanenceDateDTO periodePermanenceDateDTO = dto;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return periodePermanenceDateDTO;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    public List<PeriodePermanenceDateDTO> getAllDistributionsActif(RdbLink em, Date dateDebut, Date dateFin) {
        Query q = em.createQuery("select ppd from PeriodePermanenceDate ppd WHERE ppd.periodePermanence.etat=:etat and ppd.datePerm>=:deb and ppd.datePerm<=:fin order by ppd.datePerm");
        q.setParameter("etat", (Object)EtatPeriodePermanence.ACTIF);
        q.setParameter("deb", dateDebut, TemporalType.DATE);
        q.setParameter("fin", dateFin, TemporalType.DATE);
        ArrayList<PeriodePermanenceDateDTO> res = new ArrayList<PeriodePermanenceDateDTO>();
        List ppds = q.getResultList();
        for (PeriodePermanenceDate ppd : ppds) {
            PeriodePermanenceDateDTO dto = this.loadOneDatePermanence(ppd.id);
            res.add(dto);
        }
        return res;
    }

    private int getNbPeriodePermanenceUtilisateur(PeriodePermanence p, RdbLink em) {
        Query q = em.createQuery("select count(c) from PeriodePermanenceUtilisateur c WHERE c.periodePermanence=:p");
        q.setParameter("p", (Object)p);
        return SQLUtils.toInt(q.getSingleResult());
    }

    private int getNbInscription(PeriodePermanence p, RdbLink em) {
        Query q = em.createQuery("select count(c) from PermanenceCell c WHERE c.periodePermanenceDate.periodePermanence=:p and c.periodePermanenceUtilisateur is not null");
        q.setParameter("p", (Object)p);
        int nbInscrits = SQLUtils.toInt(q.getSingleResult());
        return nbInscrits;
    }

    private int getNbTotalPlace(PeriodePermanence p, RdbLink em) {
        Query q = em.createQuery("select sum(c.nbPlace) from PeriodePermanenceDate c WHERE c.periodePermanence=:p");
        q.setParameter("p", (Object)p);
        int nbPlaces = SQLUtils.toInt(q.getSingleResult());
        return nbPlaces;
    }

    private int getPourcentageInscription(PeriodePermanence p, RdbLink em) {
        int nbPlaces = this.getNbTotalPlace(p, em);
        int nbInscrits = this.getNbInscription(p, em);
        if (nbPlaces == 0) {
            return 100;
        }
        return nbInscrits * 100 / nbPlaces;
    }

    public DateInfo getDateDebutFin(RdbLink em, PeriodePermanence p) {
        DateInfo di = new DateInfo();
        Query q = em.createQuery("select min(c.datePerm),max(c.datePerm),count(c.datePerm) from PeriodePermanenceDate c WHERE c.periodePermanence=:p");
        q.setParameter("p", (Object)p);
        Object[] res = (Object[])q.getSingleResult();
        di.dateDebut = (Date)res[0];
        di.dateFin = (Date)res[1];
        di.nbDatePerm = SQLUtils.toInt(res[2]);
        return di;
    }

    @DbWrite
    public Long create(PeriodePermanenceDTO dto) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            PeriodePermanence p = new PeriodePermanence();
            p.nom = dto.nom;
            p.description = dto.description;
            p.dateFinInscription = dto.dateFinInscription;
            p.flottantDelai = dto.flottantDelai;
            p.etat = EtatPeriodePermanence.CREATION;
            p.nature = dto.nature;
            p.regleInscription = dto.regleInscription;
            p.depassementAutorise = dto.depassementAutorise;
            em.persist(p);
            if (dto.datePerms.size() == 0) {
                throw new AmapjRuntimeException("Vous ne pouvez pas cr\u00e9er une periode de permanence avec 0 date de permanence");
            }
            PermanenceRole defaultRole = new PermanenceRoleService().getOrCreateDefaultRole(em);
            for (PeriodePermanenceDateDTO date : dto.datePerms) {
                PeriodePermanenceDate md = new PeriodePermanenceDate();
                md.periodePermanence = p;
                md.datePerm = date.datePerm;
                md.nbPlace = date.nbPlace;
                em.persist(md);
                int i = 0;
                while (i < date.nbPlace) {
                    PermanenceCell pc = new PermanenceCell();
                    pc.periodePermanenceDate = md;
                    pc.permanenceRole = defaultRole;
                    pc.indx = i++;
                    em.persist(pc);
                }
            }
            for (PeriodePermanenceUtilisateurDTO detail : dto.utilisateurs) {
                Utilisateur utilisateur = em.find(Utilisateur.class, detail.idUtilisateur);
                PeriodePermanenceUtilisateur ppu = new PeriodePermanenceUtilisateur();
                ppu.nbParticipation = detail.nbParticipation;
                ppu.utilisateur = utilisateur;
                ppu.periodePermanence = p;
                em.persist(ppu);
            }
            Long l = p.id;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return l;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    public void fillDatePermanence(PeriodePermanenceDTO dto) {
        List<Date> dates = this.getAllDates(dto.dateDebut, dto.dateFin, dto.frequencePermanence);
        for (Date date : dates) {
            PeriodePermanenceDateDTO d = new PeriodePermanenceDateDTO();
            d.datePerm = date;
            d.nbPlace = dto.nbPlaceParDate;
            dto.datePerms.add(d);
        }
    }

    private List<Date> getAllDates(Date dateDebut, Date dateFin, FrequencePermanence frequence) {
        if (frequence == FrequencePermanence.UNE_FOIS_PAR_MOIS) {
            return this.getAllDatesUneFoisParMois(dateDebut, dateFin);
        }
        ArrayList<Date> res = new ArrayList<Date>();
        int cpt = 0;
        res.add(dateDebut);
        int delta = 0;
        if (frequence == FrequencePermanence.UNE_FOIS_PAR_SEMAINE) {
            delta = 7;
        } else if (frequence == FrequencePermanence.QUINZE_JOURS) {
            delta = 14;
        }
        dateDebut = DateUtils.addDays(dateDebut, delta);
        while (dateDebut.before(dateFin) || dateDebut.equals(dateFin)) {
            res.add(dateDebut);
            dateDebut = DateUtils.addDays(dateDebut, delta);
            if (++cpt <= 1000) continue;
            throw new AmapjRuntimeException("Erreur dans la saisie des dates");
        }
        return res;
    }

    private List<Date> getAllDatesUneFoisParMois(Date dateDebut, Date dateFin) {
        ArrayList<Date> res = new ArrayList<Date>();
        int cpt = 0;
        res.add(dateDebut);
        int rank = DateUtils.getDayOfWeekInMonth(dateDebut);
        int delta = 7;
        dateDebut = DateUtils.addDays(dateDebut, delta);
        while (dateDebut.before(dateFin) || dateDebut.equals(dateFin)) {
            ++cpt;
            if (DateUtils.getDayOfWeekInMonth(dateDebut) == rank) {
                res.add(dateDebut);
            }
            dateDebut = DateUtils.addDays(dateDebut, delta);
            if (cpt <= 1000) continue;
            throw new RuntimeException("Erreur dans la saisie des dates");
        }
        return res;
    }

    @DbWrite
    public void deletePeriodePermanence(Long id) throws UnableToSuppressException {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            PeriodePermanence p = em.find(PeriodePermanence.class, id);
            int nbInscrits = this.getNbInscription(p, em);
            if (nbInscrits > 0) {
                String str = "Vous ne pouvez plus supprimer cette periode de permanence<br/>car " + nbInscrits + " adh\u00e9rents sont d\u00e9j\u00e0 inscrits<br/><br/>." + "Si vous souhaitez r\u00e9ellement supprimer cette periode de permanence,<br/>" + "allez tout d'abord dans \"Gestions des inscriptions aux permanences\", puis vous supprimez les inscriptions (bouton Autre)";
                throw new UnableToSuppressException(str);
            }
            this.suppressAllPermanenceCell(em, p);
            this.suppressAllDates(em, p);
            this.suppressAllPermanenceUtilisateurs(em, p);
            em.remove(p);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    private void suppressAllDates(RdbLink em, PeriodePermanence p) {
        Query q = em.createQuery("select d from PeriodePermanenceDate d WHERE d.periodePermanence=:p");
        q.setParameter("p", (Object)p);
        SQLUtils.deleteAll(em, q);
    }

    private void suppressAllPermanenceUtilisateurs(RdbLink em, PeriodePermanence p) {
        Query q = em.createQuery("select d from PeriodePermanenceUtilisateur d WHERE d.periodePermanence=:p");
        q.setParameter("p", (Object)p);
        SQLUtils.deleteAll(em, q);
    }

    private void suppressAllPermanenceCell(RdbLink em, PeriodePermanence p) {
        Query q = em.createQuery("select d from PermanenceCell d WHERE d.periodePermanenceDate.periodePermanence=:p");
        q.setParameter("p", (Object)p);
        SQLUtils.deleteAll(em, q);
    }

    @DbRead
    public void fillUtilisateur(PeriodePermanenceDTO dto) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            dto.utilisateurs.clear();
            List<Utilisateur> utilisateurs = this.getAllUtilisateursCotisants(em, dto.idPeriodeCotisation);
            for (Utilisateur utilisateur : utilisateurs) {
                PeriodePermanenceUtilisateurDTO e = this.createAffectAdherentDetailDTO(utilisateur);
                dto.utilisateurs.add(e);
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    public List<Utilisateur> getAllUtilisateursCotisants(RdbLink em, Long idPeriodeCotisation) {
        if (idPeriodeCotisation == null) {
            return new UtilisateurService().getUtilisateurs(EtatUtilisateur.ACTIF);
        }
        return new GestionCotisationService().getAllUtilisateurAvecAdhesion(idPeriodeCotisation);
    }

    @DbRead
    public PeriodePermanenceUtilisateurDTO createAffectAdherentDetailDTO(Long userId) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Utilisateur utilisateur = em.find(Utilisateur.class, userId);
            PeriodePermanenceUtilisateurDTO periodePermanenceUtilisateurDTO = this.createAffectAdherentDetailDTO(utilisateur);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return periodePermanenceUtilisateurDTO;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    public PeriodePermanenceUtilisateurDTO createAffectAdherentDetailDTO(Utilisateur utilisateur) {
        PeriodePermanenceUtilisateurDTO e = new PeriodePermanenceUtilisateurDTO();
        e.idUtilisateur = utilisateur.getId();
        e.nom = utilisateur.nom;
        e.prenom = utilisateur.prenom;
        return e;
    }

    private int getNbTotalPlace(PeriodePermanenceDTO dto) {
        int nbPlaces = 0;
        for (PeriodePermanenceDateDTO d : dto.datePerms) {
            nbPlaces += d.nbPlace;
        }
        return nbPlaces;
    }

    private int getNbTotalParticipation(PeriodePermanenceDTO dto) {
        int nbParticipation = 0;
        for (PeriodePermanenceUtilisateurDTO detail : dto.utilisateurs) {
            nbParticipation += detail.nbParticipation;
        }
        return nbParticipation;
    }

    public void fillNombreParPersonne(PeriodePermanenceDTO dto) {
        int nbDate = dto.datePerms.size();
        int nbPlaces = this.getNbTotalPlace(dto);
        int nbParPersonne = nbPlaces / dto.utilisateurs.size();
        String message = "Il y a au total " + nbDate + " dates de permanences<br/>" + "et " + dto.utilisateurs.size() + " adh\u00e9rents participants<br>";
        int reliquat = nbPlaces - nbParPersonne * dto.utilisateurs.size();
        int borneSup = (nbParPersonne + 1) * dto.utilisateurs.size() - nbPlaces;
        if (reliquat == 0) {
            message = String.valueOf(message) + "Cela fait donc exactement " + nbParPersonne + " participations par personne";
            dto.nbParPersonne = nbParPersonne;
        } else {
            message = String.valueOf(message) + "Cela fait donc soit <ul>" + "<li>" + nbParPersonne + " participations par personne et il y aura " + reliquat + " permanences avec une personne en moins</li>" + "<li>" + (nbParPersonne + 1) + " participations par personne et il y aura " + borneSup + " permanences avec une personne en plus</li></ul>";
            dto.nbParPersonne = nbParPersonne + 1;
        }
        dto.message = message;
    }

    @DbWrite
    public void updateEtat(EtatPeriodePermanence newValue, Long idPeriodePermanence) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            PeriodePermanence p = em.find(PeriodePermanence.class, idPeriodePermanence);
            p.etat = newValue;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    public void lockOneDate(RdbLink em, Long idPeriodePermanenceDate) {
        Query q = em.createQuery("select c from PeriodePermanenceDate c WHERE c.id=:ppd");
        q.setParameter("ppd", (Object)idPeriodePermanenceDate);
        q.setLockMode(LockModeType.PESSIMISTIC_READ);
        List us = q.getResultList();
        if (us.size() != 1) {
            throw new AmapjRuntimeException("Lock impossible size =" + us.size());
        }
    }

    @DbRead
    public String computeBilan(PeriodePermanenceDTO dto) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            int nbPlaceTotal = this.getNbTotalPlace(dto);
            int nbParticipations = this.getNbTotalParticipation(dto);
            StringBuilder sb = new StringBuilder();
            sb.append("Nom de la p\u00e9riode de permanence :" + dto.nom + "<br/><br/>");
            sb.append("Nombre de dates de permanences : " + dto.datePerms.size() + "<br/>");
            sb.append("Nombre moyen de personnes \u00e0 chaque date : " + FormatUtils.div2int2digit(nbPlaceTotal, dto.datePerms.size()) + "<br/>");
            sb.append("Soit un total de  " + nbPlaceTotal + " places de permanences \u00e0 occuper.<br/><br/>");
            sb.append("Nombre de personnes pouvant s'inscrire : " + dto.utilisateurs.size() + "<br/>");
            sb.append("Nombre moyen de participation par personne : " + FormatUtils.div2int2digit(nbParticipations, dto.utilisateurs.size()) + "<br/>");
            sb.append("Soit un total de  " + nbParticipations + " participations totales.<br/><br/>");
            if (nbPlaceTotal == nbParticipations) {
                sb.append("Le nombre de participations est \u00e9gale au nombre de places. Parfait ! <br/><br/>");
            } else if (nbPlaceTotal < nbParticipations) {
                sb.append("Il y a moins de places que de participations. Toutes les permanences seront r\u00e9alis\u00e9es , mais certaines personnes feront moins de permanence que pr\u00e9vu.<br/><br/>");
            } else {
                sb.append("Il y a plus de places que de participations. Il manquera des personnes \u00e0 certaines permanences.<br/><br/>");
            }
            if (dto.id != null) {
                sb.append("Avancement des inscriptions:<br/>");
                RdbLink em = RdbLink.get();
                PeriodePermanence p = em.find(PeriodePermanence.class, dto.id);
                int nbInscrits = this.getNbInscription(p, em);
                sb.append("Il y a pour le moment " + nbInscrits + " inscriptions sur les " + nbPlaceTotal + " places \u00e0 occuper,<br/>");
                sb.append("soit un pourcentage de couverture de " + FormatUtils.div2int2digit(nbInscrits * 100, nbPlaceTotal) + "%.<br/>");
            }
            String string = sb.toString();
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return string;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    public void deleteUtilisateur(RdbLink em, Utilisateur u) {
        TypedQuery<PeriodePermanenceUtilisateur> q = em.createQuery("select d from PeriodePermanenceUtilisateur d WHERE d.utilisateur=:u", PeriodePermanenceUtilisateur.class);
        q.setParameter("u", (Object)u);
        List ppus = q.getResultList();
        for (PeriodePermanenceUtilisateur ppu : ppus) {
            this.deleteUtilisateurPermanenceCell(em, ppu);
            em.remove(ppu);
        }
    }

    private void deleteUtilisateurPermanenceCell(RdbLink em, PeriodePermanenceUtilisateur ppu) {
        TypedQuery<PermanenceCell> q = em.createQuery("select c from PermanenceCell c WHERE c.periodePermanenceUtilisateur=:ppu", PermanenceCell.class);
        q.setParameter("ppu", (Object)ppu);
        List pcs = q.getResultList();
        for (PermanenceCell pc : pcs) {
            pc.dateNotification = null;
            pc.periodePermanenceUtilisateur = null;
        }
    }

    public String computeSuppressionLib(ParametresArchivageDTO param) {
        String str = "Il est souhaitable de supprimer une p\u00e9riode de permanence qui remplit les conditions suivantes : <ul><li>la date de fin de cette p\u00e9riode de permanence est plus vieille que " + param.suppressionPeriodePermanence + " jours</li></ul><br/>";
        return str;
    }

    public SuppressionState computeSuppressionState(SmallPeriodePermanenceDTO dto, ParametresArchivageDTO param) {
        SuppressionState res = new SuppressionState();
        Date ref2 = DateUtils.getDateWithNoTime();
        if (dto.dateFin.after(ref2 = DateUtils.addDays(ref2, -param.suppressionPeriodePermanence))) {
            res.nonSupprimables.add("La date de fin de cette p\u00e9riode de permanence est trop r\u00e9cente");
        }
        return res;
    }

    public List<SmallPeriodePermanenceDTO> getAllPeriodePermanenceSupprimables(ParametresArchivageDTO param) {
        List<SmallPeriodePermanenceDTO> ps = this.getAllPeriodePermanence();
        ArrayList<SmallPeriodePermanenceDTO> res = new ArrayList<SmallPeriodePermanenceDTO>();
        for (SmallPeriodePermanenceDTO p : ps) {
            SuppressionState state = this.computeSuppressionState(p, param);
            if (state.getStatus() != SuppressionState.SStatus.OUI_SANS_RESERVE) continue;
            res.add(p);
        }
        res.sort(Comparator.comparing(e -> e.dateFin));
        return res;
    }

    @DbWrite
    public void deleteWithInscrits(Long id) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            PeriodePermanence p = em.find(PeriodePermanence.class, id);
            TypedQuery<PermanenceCell> q = em.createQuery("select c from PermanenceCell c WHERE c.periodePermanenceDate.periodePermanence=:p", PermanenceCell.class);
            q.setParameter("p", (Object)p);
            for (PermanenceCell permanenceCell : q.getResultList()) {
                permanenceCell.periodePermanenceUtilisateur = null;
            }
            this.deletePeriodePermanence(id);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    public static class DateInfo {
        public Date dateDebut;
        public Date dateFin;
        public int nbDatePerm;
    }
}

