/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.permanence.role;

import fr.amapj.common.CollectionUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.DbWrite;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.permanence.periode.PeriodePermanence;
import fr.amapj.model.models.permanence.periode.PermanenceRole;
import fr.amapj.service.services.permanence.role.PermanenceRoleDTO;
import fr.amapj.view.engine.popup.suppressionpopup.UnableToSuppressException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Query;

public class PermanenceRoleService {
    @DbRead
    public List<PermanenceRoleDTO> getAllRoles() {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ArrayList<PermanenceRoleDTO> res = new ArrayList<PermanenceRoleDTO>();
            Query q = em.createQuery("select p from PermanenceRole p order by p.nom");
            List ps = q.getResultList();
            for (PermanenceRole p : ps) {
                PermanenceRoleDTO dto = this.createPermanenceRoleDto(em, p);
                res.add(dto);
            }
            ArrayList<PermanenceRoleDTO> arrayList = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return arrayList;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    public PermanenceRoleDTO createPermanenceRoleDto(RdbLink em, PermanenceRole p) {
        PermanenceRoleDTO dto = new PermanenceRoleDTO();
        dto.id = p.id;
        dto.nom = p.nom;
        dto.description = p.description;
        dto.defaultRole = p.defaultRole;
        return dto;
    }

    @DbWrite
    public Long update(PermanenceRoleDTO dto, boolean create) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            PermanenceRole p = create ? new PermanenceRole() : em.find(PermanenceRole.class, dto.id);
            p.nom = dto.nom;
            p.description = dto.description;
            p.defaultRole = false;
            if (create) {
                em.persist(p);
            }
            Long l = p.id;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return l;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbWrite
    public void delete(Long id) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            PermanenceRole p = em.find(PermanenceRole.class, id);
            List<PeriodePermanence> pps = this.findPermanence(p, em);
            if (pps.size() != 0) {
                throw new UnableToSuppressException("Ce role est utilis\u00e9 dans les permanences suivantes :" + CollectionUtils.asStdString(pps, e -> e.nom));
            }
            em.remove(p);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    private List<PeriodePermanence> findPermanence(PermanenceRole r, RdbLink em) {
        Query q = em.createQuery("select distinct(pc.periodePermanenceDate.periodePermanence) from PermanenceCell pc WHERE pc.permanenceRole=:r");
        q.setParameter("r", (Object)r);
        return q.getResultList();
    }

    public PermanenceRole getOrCreateDefaultRole(RdbLink em) {
        Query q = em.createQuery("select p from PermanenceRole p where p.defaultRole=true order by p.nom");
        List ps = q.getResultList();
        if (ps.size() >= 1) {
            return (PermanenceRole)ps.get(0);
        }
        PermanenceRole p = new PermanenceRole();
        p.nom = "Place ";
        p.description = "Place ";
        p.defaultRole = true;
        em.persist(p);
        return p;
    }

    @DbRead
    public Long getIdDefaultRole() {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Long l = this.getOrCreateDefaultRole((RdbLink)em).id;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return l;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }
}

