/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.produitextended;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fr.amapj.common.GzipUtils;
import fr.amapj.common.SQLUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.modele.StockMultiContrat;
import fr.amapj.model.models.fichierbase.Producteur;
import fr.amapj.model.models.fichierbase.Produit;
import fr.amapj.model.models.produitextended.ProduitExtendedParam;
import fr.amapj.model.models.produitextended.ProduitExtendedTyp;
import fr.amapj.model.models.produitextended.qtedispostock.QteDispoStock;
import fr.amapj.model.models.produitextended.reglesconversion.RegleConversionProduit;
import fr.amapj.model.models.produitextended.reglesconversion.RegleConversionStock;
import fr.amapj.service.services.produit.ProduitDTO;
import javax.persistence.TypedQuery;

public class ProduitExtendedService {
    public QteDispoStock loadQteDispoStock(RdbLink em, ModeleContrat mc) {
        ProduitExtendedParam p = this.findQteDispoStockExtendedParam(em, mc);
        return this.convertQteDispoStock(p);
    }

    private ProduitExtendedParam findQteDispoStockExtendedParam(RdbLink em, ModeleContrat mc) {
        Producteur p = mc.producteur;
        if (mc.stockMultiContrat == StockMultiContrat.NON) {
            return this.findQteDispoStockExtendedParamMonoContrat(em, mc, p);
        }
        return this.findQteDispoStockExtendedParamMultiContrat(em, p);
    }

    private ProduitExtendedParam findQteDispoStockExtendedParamMonoContrat(RdbLink em, ModeleContrat mc, Producteur p) {
        TypedQuery<ProduitExtendedParam> q1 = em.createQuery("select c from ProduitExtendedParam c where c.modeleContrat=:mc AND c.producteur=:p AND c.typ=:typ", ProduitExtendedParam.class);
        q1.setParameter("mc", (Object)mc);
        q1.setParameter("p", (Object)p);
        q1.setParameter("typ", (Object)ProduitExtendedTyp.QTE_DISPO_STOCK);
        return SQLUtils.oneOrZero(q1);
    }

    private ProduitExtendedParam findQteDispoStockExtendedParamMultiContrat(RdbLink em, Producteur p) {
        TypedQuery<ProduitExtendedParam> q1 = em.createQuery("select c from ProduitExtendedParam c where c.modeleContrat IS NULL AND c.producteur=:p AND c.typ=:typ", ProduitExtendedParam.class);
        q1.setParameter("p", (Object)p);
        q1.setParameter("typ", (Object)ProduitExtendedTyp.QTE_DISPO_STOCK);
        return SQLUtils.oneOrZero(q1);
    }

    private QteDispoStock convertQteDispoStock(ProduitExtendedParam param) {
        QteDispoStock res = param == null ? new QteDispoStock() : (QteDispoStock)this.createGson().fromJson(GzipUtils.uncompress(param.content), QteDispoStock.class);
        res.setDefault();
        return res;
    }

    public void saveQteDispoStock(QteDispoStock qteDispoStock, Long modeleContratId, RdbLink em) {
        ModeleContrat mc = em.find(ModeleContrat.class, modeleContratId);
        ProduitExtendedParam param = this.findQteDispoStockExtendedParam(em, mc);
        if (param == null) {
            param = this.createStockExtendedParam(em, mc);
        }
        param.content = GzipUtils.compress(this.createGson().toJson((Object)qteDispoStock));
    }

    private ProduitExtendedParam createStockExtendedParam(RdbLink em, ModeleContrat mc) {
        ProduitExtendedParam param = new ProduitExtendedParam();
        param.typ = ProduitExtendedTyp.QTE_DISPO_STOCK;
        param.producteur = mc.producteur;
        param.modeleContrat = mc.stockMultiContrat == StockMultiContrat.NON ? mc : null;
        em.persist(param);
        return param;
    }

    public RegleConversionProduit loadRegleConversionProduit(RdbLink em, Producteur p) {
        return this.convertRegleConversionProduit(this.findRegleConversionProduitExtendedParam(em, p));
    }

    private ProduitExtendedParam findRegleConversionProduitExtendedParam(RdbLink em, Producteur p) {
        TypedQuery<ProduitExtendedParam> q1 = em.createQuery("select c from ProduitExtendedParam c where c.modeleContrat IS NULL AND c.producteur=:p AND c.typ=:typ", ProduitExtendedParam.class);
        q1.setParameter("p", (Object)p);
        q1.setParameter("typ", (Object)ProduitExtendedTyp.REGLES_CONVERSION_STOCK);
        return SQLUtils.oneOrZero(q1);
    }

    private RegleConversionProduit convertRegleConversionProduit(ProduitExtendedParam param) {
        RegleConversionProduit res = param == null ? new RegleConversionProduit() : (RegleConversionProduit)this.createGson().fromJson(GzipUtils.uncompress(param.content), RegleConversionProduit.class);
        res.setDefault();
        return res;
    }

    public void saveRegleConversionProduit(RegleConversionProduit qteDispoStock, Producteur p, RdbLink em) {
        ProduitExtendedParam param = this.findRegleConversionProduitExtendedParam(em, p);
        if (param == null) {
            param = this.createRegleConversionProduitExtendedParam(em, p);
        }
        param.content = GzipUtils.compress(this.createGson().toJson((Object)qteDispoStock));
    }

    private ProduitExtendedParam createRegleConversionProduitExtendedParam(RdbLink em, Producteur p) {
        ProduitExtendedParam param = new ProduitExtendedParam();
        param.typ = ProduitExtendedTyp.REGLES_CONVERSION_STOCK;
        param.producteur = p;
        param.modeleContrat = null;
        em.persist(param);
        return param;
    }

    public void saveRegleConversionOneProduit(Produit produit, ProduitDTO dto, RdbLink em) {
        RegleConversionProduit r = this.loadRegleConversionProduit(em, produit.producteur);
        RegleConversionStock stock = r.findReglesConversionStock(produit.id);
        stock.coefficient = dto.coefficient;
        stock.idProduitEnStock = dto.idProduitEnStock;
        stock.limiteQuantite = dto.limiteQuantite;
        this.saveRegleConversionProduit(r, produit.producteur, em);
    }

    private Gson createGson() {
        return new GsonBuilder().setDateFormat("dd/MM/yyyy").create();
    }
}

