/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.session;

import com.vaadin.server.WebBrowser;
import com.vaadin.ui.UI;
import fr.amapj.model.engine.transaction.DataBaseInfo;
import fr.amapj.model.models.acces.RoleList;
import fr.amapj.service.services.appinstance.LogAccessDTO;
import fr.amapj.service.services.session.SessionData;
import fr.amapj.service.services.session.SessionParameters;
import fr.amapj.service.services.suiviacces.ConnectedUserDTO;
import fr.amapj.view.engine.ui.AmapUI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class SessionManager {
    private static final List<AmapUI> listeners = new CopyOnWriteArrayList<AmapUI>();

    public static void register(AmapUI listener) {
        listeners.add(listener);
    }

    public static void unregister(AmapUI listener) {
        listeners.remove((Object)listener);
    }

    public static void broadcast(String message) {
        for (AmapUI listener : listeners) {
            listener.receiveBroadcast(message);
        }
    }

    public static int getNbError(LogAccessDTO dto) {
        for (AmapUI ui : listeners) {
            SessionParameters params;
            if (ui.getData() == null || (params = ((SessionData)ui.getData()).sessionParameters) == null || params.logId != dto.id) continue;
            return params.getNbError();
        }
        return 0;
    }

    public static List<ConnectedUserDTO> getAllConnectedUser() {
        ArrayList<ConnectedUserDTO> us = new ArrayList<ConnectedUserDTO>();
        for (AmapUI ui : listeners) {
            ConnectedUserDTO u = new ConnectedUserDTO();
            u.agent = SessionManager.getAgentName(ui);
            if (ui.getData() != null) {
                u.dbName = ((SessionData)ui.getData()).dataBaseInfo.getDbName();
                SessionParameters params = ((SessionData)ui.getData()).sessionParameters;
                if (params != null) {
                    u.nom = params.userNom;
                    u.prenom = params.userPrenom;
                    u.email = params.userEmail;
                    u.date = params.dateConnexion;
                    u.isLogged = true;
                } else {
                    u.nom = "--";
                    u.prenom = "--";
                    u.isLogged = false;
                }
            }
            us.add(u);
        }
        return us;
    }

    public static String getAgentName(UI ui) {
        if (ui.getSession() == null) {
            return "Session null";
        }
        WebBrowser browser = ui.getPage().getWebBrowser();
        if (browser.isChrome()) {
            return "Chrome " + browser.getBrowserMajorVersion();
        }
        if (browser.isFirefox()) {
            return "Firefox " + browser.getBrowserMajorVersion();
        }
        if (browser.isIE()) {
            return "IE " + browser.getBrowserMajorVersion();
        }
        if (browser.isOpera()) {
            return "Opera " + browser.getBrowserMajorVersion();
        }
        if (browser.isSafari()) {
            return "Safari " + browser.getBrowserMajorVersion();
        }
        if (browser.isEdge()) {
            return "Edge " + browser.getBrowserMajorVersion();
        }
        return "XX";
    }

    public static SessionParameters getSessionParameters() {
        SessionData data = SessionManager.getSessionData();
        if (data == null) {
            return null;
        }
        return data.sessionParameters;
    }

    public static void setSessionParameters(SessionParameters param) {
        SessionManager.getSessionData().sessionParameters = param;
    }

    public static void initSessionData(DataBaseInfo dataBaseInfo) {
        SessionData data = new SessionData();
        data.dataBaseInfo = dataBaseInfo;
        UI.getCurrent().setData((Object)data);
    }

    private static SessionData getSessionData() {
        return (SessionData)UI.getCurrent().getData();
    }

    public static boolean canDisconnect() {
        return SessionManager.getSessionData() != null && SessionManager.getSessionParameters() != null;
    }

    public static Long getUserId() {
        return SessionManager.getSessionParameters().userId;
    }

    public static List<RoleList> getUserRoles() {
        return SessionManager.getSessionParameters().userRole;
    }

    public static DataBaseInfo getDb() {
        return SessionManager.getSessionData().dataBaseInfo;
    }
}

