/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.stockservice.verifstock;

import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.fichierbase.Produit;
import fr.amapj.service.services.stockservice.verifstock.Consommateur;
import fr.amapj.service.services.stockservice.verifstock.Qte;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ProduitEnStockDTO {
    public Long idProduit;
    public int[] qteDispo;
    public boolean[] hasConsommateurCommandable;
    public List<Consommateur> consommateurs = new ArrayList<Consommateur>();
    public String nomProduit;
    public String condtionnementProduit;
    public Integer prix;
    public int indx;
    public Long idModeleContrat;

    public Qte getQteRestante(int indexDate) {
        Qte qte = new Qte(this.qteDispo[indexDate]);
        for (Consommateur consommateur : this.consommateurs) {
            consommateur.consommerOther(qte, indexDate);
            consommateur.consommerMe(qte, indexDate);
        }
        return qte;
    }

    public double getQteConsomme(int indexDate) {
        Qte qte = new Qte(0.0);
        for (Consommateur consommateur : this.consommateurs) {
            consommateur.consommerOther(qte, indexDate);
            consommateur.consommerMe(qte, indexDate);
        }
        return Math.abs(qte.qte);
    }

    public boolean isStockSuffisant(int indexDate) {
        Qte qte = new Qte(this.qteDispo[indexDate]);
        for (Consommateur consommateur : this.consommateurs) {
            consommateur.consommerOther(qte, indexDate);
        }
        for (Consommateur consommateur : this.consommateurs) {
            if (consommateur.isStockSuffisant(qte, indexDate)) continue;
            return false;
        }
        return true;
    }

    public void computePrettyMessage(List<String> res, RdbLink em, SimpleDateFormat df, int indexDate, Date date) {
        Qte qte = new Qte(this.qteDispo[indexDate]);
        for (Consommateur consommateur : this.consommateurs) {
            consommateur.consommerOther(qte, indexDate);
        }
        for (Consommateur consommateur : this.consommateurs) {
            consommateur.computePrettyMessage(res, em, df, qte, indexDate, date);
        }
    }

    public Consommateur findConsommateur(Long idProduitCommande) {
        for (Consommateur consommateur : this.consommateurs) {
            if (!consommateur.produitCdeDTO.idProduit.equals(idProduitCommande)) continue;
            return consommateur;
        }
        return null;
    }

    public void addDebugInfo(List<String> ls, int indexDate, RdbLink em) {
        Produit p = em.find(Produit.class, this.idProduit);
        ls.add("Produit en stock : " + p.nom + "," + p.conditionnement);
        ls.add("Qte dispo = " + this.qteDispo[indexDate]);
        ls.add("Consomm\u00e9 par");
        for (Consommateur consommateur : this.consommateurs) {
            consommateur.addDebugInfo(ls, indexDate, em);
        }
        ls.add("");
    }
}

