/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.stockservice.verifstock;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.FormatUtils;
import fr.amapj.common.LongUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.modele.ModeleContratExclude;
import fr.amapj.model.models.contrat.modele.ModeleContratProduit;
import fr.amapj.model.models.contrat.modele.StockGestion;
import fr.amapj.model.models.contrat.modele.StockMultiContrat;
import fr.amapj.model.models.fichierbase.Producteur;
import fr.amapj.model.models.fichierbase.Produit;
import fr.amapj.model.models.produitextended.qtedispostock.QteDispoStock;
import fr.amapj.model.models.produitextended.reglesconversion.ProduitLimiteQuantite;
import fr.amapj.model.models.produitextended.reglesconversion.RegleConversionProduit;
import fr.amapj.model.models.produitextended.reglesconversion.RegleConversionStock;
import fr.amapj.service.services.mescontrats.ContratDTO;
import fr.amapj.service.services.produitextended.ProduitExtendedService;
import fr.amapj.service.services.stockservice.verifstock.Consommateur;
import fr.amapj.service.services.stockservice.verifstock.ProduitCdeDTO;
import fr.amapj.service.services.stockservice.verifstock.ProduitEnStockDTO;
import fr.amapj.service.services.stockservice.verifstock.VerifStockDateDTO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

public class VerifStockDTO {
    public List<Date> dates = new ArrayList<Date>();
    public Map<Date, Integer> mapDateIndex = new HashMap<Date, Integer>();
    public VerifStockDateDTO verifStockDateDTO = new VerifStockDateDTO();

    public boolean isStockSuffisant() {
        int indexDate = 0;
        while (indexDate < this.dates.size()) {
            if (!this.verifStockDateDTO.isStockSuffisant(indexDate)) {
                return false;
            }
            ++indexDate;
        }
        return true;
    }

    public void computePrettyMessage(List<String> res, RdbLink em, SimpleDateFormat df) {
        int indexDate = 0;
        while (indexDate < this.dates.size()) {
            this.verifStockDateDTO.computePrettyMessage(res, em, df, indexDate, this.dates.get(indexDate));
            ++indexDate;
        }
    }

    public List<String> showDebug(RdbLink em) {
        ArrayList<String> ls = new ArrayList<String>();
        SimpleDateFormat df = FormatUtils.getStdDate();
        int i = 0;
        while (i < this.dates.size()) {
            Date date = this.dates.get(i);
            ls.add("Date : " + df.format(date));
            this.verifStockDateDTO.addDebugInfo(ls, i, em);
            ++i;
        }
        return ls;
    }

    public int findDate(Date date) {
        Integer indexDate = this.mapDateIndex.get(date);
        return indexDate != null ? indexDate : -1;
    }

    public void addAllDates(List<Date> ds) {
        ds.sort(null);
        int i = 0;
        while (i < ds.size()) {
            Date date = ds.get(i);
            this.dates.add(date);
            this.mapDateIndex.put(date, i);
            ++i;
        }
    }

    public void addAllProduits(List<ModeleContratProduit> mcps, boolean fullProdInfo, RdbLink em, Producteur producteur, List<Long> additionalProduits, RegleConversionProduit regles) {
        for (ModeleContratProduit mcp : mcps) {
            Long idProduit = mcp.produit.id;
            RegleConversionStock r = regles.findReglesConversionStock(idProduit);
            switch (r.limiteQuantite) {
                case SUIVI_STANDARD: {
                    this.verifStockDateDTO.createProduitEnStockAndConsommateur(idProduit, idProduit, 1.0, this.dates.size(), fullProdInfo, mcp);
                    break;
                }
                case SUIVI_AVEC_REGLE_CALCUL: {
                    this.verifStockDateDTO.createProduitEnStockAndConsommateur(r.idProduitEnStock, idProduit, r.coefficient, this.dates.size(), fullProdInfo, null);
                    break;
                }
            }
        }
        for (Long idProduitCde : additionalProduits) {
            RegleConversionStock r = regles.findReglesConversionStock(idProduitCde);
            if (r.limiteQuantite != ProduitLimiteQuantite.SUIVI_AVEC_REGLE_CALCUL) continue;
            this.verifStockDateDTO.addConsommateurIfNeeded(r.idProduitEnStock, r.idProduit, r.coefficient, this.dates.size());
        }
    }

    public void setQteMe(ContratDTO dto) {
        int j = 0;
        while (j < dto.contratColumns.size()) {
            Long produitId = dto.contratColumns.get((int)j).produitId;
            Consommateur consommateur = this.verifStockDateDTO.findConsommateur(produitId);
            if (consommateur != null) {
                ProduitCdeDTO produitCdeDTO = consommateur.produitCdeDTO;
                int i = 0;
                while (i < dto.contratLigs.size()) {
                    Date date = dto.contratLigs.get((int)i).date;
                    int indexDate = this.findDate(date);
                    if (indexDate != -1) {
                        produitCdeDTO.qteMe[indexDate] = dto.cell[i][j].qte;
                    }
                    ++i;
                }
            }
            ++j;
        }
    }

    public void completeInfoProduitAndSortProduit(RdbLink em) {
        for (ProduitEnStockDTO p : this.verifStockDateDTO.prodStocks) {
            Produit prod = em.find(Produit.class, p.idProduit);
            p.nomProduit = prod.nom;
            p.condtionnementProduit = prod.conditionnement;
        }
        this.verifStockDateDTO.prodStocks.sort(Comparator.comparing(e -> e.idModeleContrat, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(e -> e.indx).thenComparing(e -> String.valueOf(e.nomProduit) + "," + e.condtionnementProduit));
    }

    public void computeHasConsommateurCommandable(List<Long> idModeleContrats, RegleConversionProduit regles, RdbLink em, Date dateRef) {
        for (Long idModeleContrat : idModeleContrats) {
            Map<Excluded, Integer> excluded = this.getAllExcludedDateProduit(em, idModeleContrat);
            List<Date> dates = this.getAllDates(em, idModeleContrat, dateRef);
            List<ModeleContratProduit> prods = this.getAllProduit(em, idModeleContrat);
            for (Date date : dates) {
                int indexDate = this.findDate(date);
                if (indexDate == -1) continue;
                for (ModeleContratProduit prod : prods) {
                    ProduitCdeDTO produitCdeDTO;
                    Consommateur consommateur = this.verifStockDateDTO.findConsommateur(prod.produit.id);
                    if (consommateur == null || this.isExcluded(excluded, date, produitCdeDTO = consommateur.produitCdeDTO)) continue;
                    produitCdeDTO.produitEnStockDTO.hasConsommateurCommandable[indexDate] = true;
                }
            }
        }
    }

    private boolean isExcluded(Map<Excluded, Integer> excluded, Date date, ProduitCdeDTO produitCdeDTO) {
        boolean b = excluded.containsKey(new Excluded(date, null));
        if (b) {
            return true;
        }
        return excluded.containsKey(new Excluded(date, produitCdeDTO.idProduit));
    }

    private Map<Excluded, Integer> getAllExcludedDateProduit(RdbLink em, Long idModeleContrat) {
        TypedQuery<ModeleContratExclude> q = em.createQuery("select mce from ModeleContratExclude mce where mce.modeleContrat.id=:id", ModeleContratExclude.class);
        q.setParameter("id", (Object)idModeleContrat);
        List ls = q.getResultList();
        HashMap<Excluded, Integer> res = new HashMap<Excluded, Integer>();
        for (ModeleContratExclude e : ls) {
            res.put(new Excluded(e.date.dateLiv, e.produit == null ? null : e.produit.produit.id), 1);
        }
        return res;
    }

    private List<Date> getAllDates(RdbLink em, Long idModeleContrat, Date dateRef) {
        TypedQuery<Date> q = em.createQuery("select mcd.dateLiv from ModeleContratDate mcd where mcd.modeleContrat.id=:id AND mcd.dateLiv >= :dateRef", Date.class);
        q.setParameter("id", (Object)idModeleContrat);
        q.setParameter("dateRef", (Object)dateRef);
        return q.getResultList();
    }

    private List<ModeleContratProduit> getAllProduit(RdbLink em, Long idModeleContrat) {
        TypedQuery<ModeleContratProduit> q = em.createQuery("select mcp from ModeleContratProduit mcp where mcp.modeleContrat.id=:id", ModeleContratProduit.class);
        q.setParameter("id", (Object)idModeleContrat);
        return q.getResultList();
    }

    public void insertQteCommandeOther(RdbLink em, ModeleContrat mc, Long contratId) {
        List<Long> produitCommandeIds = this.verifStockDateDTO.computeProduitCommandeIds();
        List<Object[]> ls = this.loadQteOther(produitCommandeIds, this.dates, em, mc, contratId);
        for (Object[] r : ls) {
            int qteCommande = ((Long)r[0]).intValue();
            Date date = (Date)r[1];
            Long produitId = (Long)r[2];
            this.setQteCommandeOther(date, produitId, qteCommande);
        }
    }

    public void setQteCommandeOther(Date date, Long produitId, int qteCommande) {
        int indexDate = this.findDate(date);
        ProduitCdeDTO produitCdeDTO = this.verifStockDateDTO.findConsommateur((Long)produitId).produitCdeDTO;
        produitCdeDTO.qteOther[indexDate] = qteCommande;
    }

    private List<Object[]> loadQteOther(List<Long> produitCommandeIds, List<Date> dates, RdbLink em, ModeleContrat mc, Long contratId) {
        switch (mc.stockMultiContrat) {
            case NON: {
                return this.loadQteOtherMonoContrat(em, mc, contratId, produitCommandeIds, dates);
            }
            case OUI: {
                return this.loadQteOtherMultiContrat(em, mc, contratId, produitCommandeIds, dates);
            }
        }
        throw new AmapjRuntimeException();
    }

    private List<Object[]> loadQteOtherMonoContrat(RdbLink em, ModeleContrat mc, Long contratId, List<Long> produitCommandeIds, List<Date> dates) {
        if (produitCommandeIds.size() == 0 || dates.size() == 0) {
            return new ArrayList<Object[]>();
        }
        Query q = em.createQuery("select sum(c.qte),c.modeleContratDate.dateLiv,c.modeleContratProduit.produit.id from ContratCell c where c.contrat.modeleContrat=:mc AND " + (contratId != null ? "c.contrat.id<>:contratId AND " : " ") + "c.modeleContratDate.dateLiv IN :dates AND " + "c.modeleContratProduit.produit.id IN :produits " + "group by c.modeleContratDate.dateLiv,c.modeleContratProduit.produit.id");
        if (contratId != null) {
            q.setParameter("contratId", (Object)contratId);
        }
        q.setParameter("mc", (Object)mc);
        q.setParameter("dates", dates);
        q.setParameter("produits", produitCommandeIds);
        return q.getResultList();
    }

    private List<Object[]> loadQteOtherMultiContrat(RdbLink em, ModeleContrat mc, Long contratId, List<Long> produitCommandeIds, List<Date> dates) {
        if (produitCommandeIds.size() == 0 || dates.size() == 0) {
            return new ArrayList<Object[]>();
        }
        Query q = em.createQuery("select sum(c.qte),c.modeleContratDate.dateLiv,c.modeleContratProduit.produit.id from ContratCell c where c.contrat.modeleContrat.producteur=:p AND c.contrat.modeleContrat.stockGestion=:g AND c.contrat.modeleContrat.stockMultiContrat=:m AND " + (contratId != null ? "c.contrat.id<>:contratId AND " : " ") + "c.modeleContratDate.dateLiv IN :dates AND " + "c.modeleContratProduit.produit.id IN :produits " + "group by c.modeleContratDate.dateLiv,c.modeleContratProduit.produit.id");
        q.setParameter("p", (Object)mc.producteur);
        q.setParameter("g", (Object)StockGestion.OUI);
        q.setParameter("m", (Object)StockMultiContrat.OUI);
        if (contratId != null) {
            q.setParameter("contratId", (Object)contratId);
        }
        q.setParameter("dates", dates);
        q.setParameter("produits", produitCommandeIds);
        return q.getResultList();
    }

    public QteDispoStock insertQteDispoStock(RdbLink em, ModeleContrat mc) {
        QteDispoStock qteDispoStock = new ProduitExtendedService().loadQteDispoStock(em, mc);
        for (ProduitEnStockDTO produitEnStockDTO : this.verifStockDateDTO.prodStocks) {
            int indexDate = 0;
            while (indexDate < this.dates.size()) {
                produitEnStockDTO.qteDispo[indexDate] = qteDispoStock.findQteDispo(mc.stockIdentiqueDate, this.dates.get(indexDate), produitEnStockDTO.idProduit);
                ++indexDate;
            }
        }
        return qteDispoStock;
    }

    public static class Excluded {
        public Date date;
        public Long idProduit;

        public Excluded(Date date, Long idProduit) {
            this.date = date;
            this.idProduit = idProduit;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Excluded) {
                Excluded c = (Excluded)obj;
                return LongUtils.equals(this.idProduit, c.idProduit) && this.date.equals(c.date);
            }
            return false;
        }

        public int hashCode() {
            return (this.idProduit != null ? this.idProduit.hashCode() : 0) + this.date.hashCode();
        }
    }
}

