/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.stockservice.verifstock;

import fr.amapj.common.DateUtils;
import fr.amapj.common.FormatUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.modele.ModeleContratProduit;
import fr.amapj.model.models.contrat.modele.StockGestion;
import fr.amapj.model.models.contrat.modele.StockMultiContrat;
import fr.amapj.model.models.produitextended.reglesconversion.RegleConversionProduit;
import fr.amapj.service.services.mescontrats.ContratDTO;
import fr.amapj.service.services.mescontrats.MesContratsService;
import fr.amapj.service.services.mescontrats.MonContratDTO;
import fr.amapj.service.services.produitextended.ProduitExtendedService;
import fr.amapj.service.services.stockservice.verifstock.VerifStockDTO;
import fr.amapj.view.views.saisiecontrat.SaisieContrat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.TypedQuery;

public class VerifStockService {
    public void insertInfoStock(RdbLink em, ModeleContrat mc, MonContratDTO m, SaisieContrat.ModeSaisie modeSaisie) {
        VerifStockDTO verif;
        if (mc.stockGestion == StockGestion.NON || modeSaisie == SaisieContrat.ModeSaisie.CHEQUE_SEUL || modeSaisie == SaisieContrat.ModeSaisie.READ_ONLY) {
            m.verifStockDTO = new VerifStockDTO();
            return;
        }
        ContratDTO dto = m.contratDTO;
        m.verifStockDTO = verif = this.loadVerifStock(em, mc, dto, dto.contratId);
        int i = 0;
        while (i < dto.contratLigs.size()) {
            Date date = dto.contratLigs.get((int)i).date;
            int indexDate = verif.findDate(date);
            if (indexDate != -1) {
                int j = 0;
                while (j < dto.contratColumns.size()) {
                    if (dto.cell[i][j].qte == 0) {
                        Long produitId = dto.contratColumns.get((int)j).produitId;
                        dto.cell[i][j].available = verif.verifStockDateDTO.isOneMoreAvailable(produitId, indexDate);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public VerifStockDTO loadVerifStock(RdbLink em, ModeleContrat mc, ContratDTO contratDTO, Long idContrat) {
        if (mc.stockGestion == StockGestion.NON) {
            return new VerifStockDTO();
        }
        VerifStockDTO res = new VerifStockDTO();
        RegleConversionProduit regles = new ProduitExtendedService().loadRegleConversionProduit(em, mc.producteur);
        res.addAllDates(this.computeDates(contratDTO));
        List<ModeleContratProduit> mcps = this.getAllProduit(em, mc);
        List<Long> additionalProduits = this.getAdditionnalProduits(em, mc);
        res.addAllProduits(mcps, false, em, mc.producteur, additionalProduits, regles);
        res.insertQteCommandeOther(em, mc, idContrat);
        res.insertQteDispoStock(em, mc);
        return res;
    }

    private List<Date> computeDates(ContratDTO dto) {
        Date ref = DateUtils.getDateWithNoTime();
        ArrayList<Date> ds = new ArrayList<Date>();
        int i = 0;
        while (i < dto.contratLigs.size()) {
            Date date = dto.contratLigs.get((int)i).date;
            if (!date.before(ref)) {
                ds.add(date);
            }
            ++i;
        }
        return ds;
    }

    public List<ModeleContratProduit> getAllProduit(RdbLink em, ModeleContrat mc) {
        TypedQuery<ModeleContratProduit> q = em.createQuery("select mcp from ModeleContratProduit mcp where mcp.modeleContrat=:mc", ModeleContratProduit.class);
        q.setParameter("mc", (Object)mc);
        return q.getResultList();
    }

    private List<Long> getAdditionnalProduits(RdbLink em, ModeleContrat mc) {
        if (mc.stockMultiContrat == StockMultiContrat.NON) {
            return new ArrayList<Long>();
        }
        TypedQuery<Long> q = em.createQuery("select p.id from Produit p where p.producteur.id=:prd order by p.nom,p.conditionnement", Long.class);
        q.setParameter("prd", (Object)mc.producteur.id);
        return q.getResultList();
    }

    @DbRead
    public List<String> computePrettyMessage(VerifStockDTO verifStockDTO) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ArrayList<String> res = new ArrayList<String>();
            SimpleDateFormat df = FormatUtils.getStdDate();
            res.add("Les quantit\u00e9s command\u00e9es sont trop importantes.");
            verifStockDTO.computePrettyMessage(res, em, df);
            ArrayList<String> arrayList = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return arrayList;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public List<String> showDebug(Long modeleContratId) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            MonContratDTO m = new MesContratsService().loadMonContratDTO(modeleContratId, null, SaisieContrat.ModeSaisie.STANDARD);
            List<String> list = m.verifStockDTO.showDebug(em);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return list;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }
}

