/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.utilisateur;

import fr.amapj.common.CollectionUtils;
import fr.amapj.common.DateUtils;
import fr.amapj.common.LongUtils;
import fr.amapj.common.RandomUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.DbWrite;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.acces.RoleList;
import fr.amapj.model.models.fichierbase.EtatUtilisateur;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.engine.tools.DbToDto;
import fr.amapj.service.services.access.AccessManagementService;
import fr.amapj.service.services.authentification.PasswordManager;
import fr.amapj.service.services.gestioncotisation.GestionCotisationService;
import fr.amapj.service.services.gestioncotisation.PeriodeCotisationUtilisateurDTO;
import fr.amapj.service.services.mailer.MailerMessage;
import fr.amapj.service.services.mailer.MailerService;
import fr.amapj.service.services.notification.DeleteNotificationService;
import fr.amapj.service.services.parametres.ParametresDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceService;
import fr.amapj.service.services.utilisateur.UtilisateurDTO;
import fr.amapj.service.services.utilisateur.envoimail.EnvoiMailDTO;
import fr.amapj.service.services.utilisateur.envoimail.EnvoiMailUtilisateurDTO;
import fr.amapj.service.services.utilisateur.envoimail.StatusEnvoiMailDTO;
import fr.amapj.service.services.utilisateur.util.UtilisateurUtil;
import fr.amapj.view.engine.popup.suppressionpopup.UnableToSuppressException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Query;

public class UtilisateurService {
    @DbRead
    public List<UtilisateurDTO> getAllUtilisateurs(EtatUtilisateur etat) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            List<Utilisateur> us = this.getUtilisateurs(etat);
            List<UtilisateurDTO> list = DbToDto.transform(us, u -> this.createUtilisateurDto(em, (Utilisateur)u));
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return list;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    public UtilisateurDTO createUtilisateurDto(RdbLink em, Utilisateur u) {
        UtilisateurDTO dto = new UtilisateurDTO();
        dto.id = u.getId();
        dto.nom = u.nom;
        dto.prenom = u.prenom;
        dto.roles = new AccessManagementService().getRoleAsString(em, u);
        dto.email = u.email;
        dto.etatUtilisateur = u.etatUtilisateur;
        dto.dateCreation = u.dateCreation;
        dto.dateModification = u.dateModification;
        dto.numTel1 = u.numTel1;
        dto.numTel2 = u.numTel2;
        dto.libAdr1 = u.libAdr1;
        dto.codePostal = u.codePostal;
        dto.ville = u.ville;
        return dto;
    }

    @DbRead
    public UtilisateurDTO loadUtilisateurDto(Long idUtilisateur) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Utilisateur u = em.find(Utilisateur.class, idUtilisateur);
            UtilisateurDTO utilisateurDTO = this.createUtilisateurDto(em, u);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return utilisateurDTO;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbWrite
    public void updateUtilisateur(UtilisateurDTO dto) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            Utilisateur u = em.find(Utilisateur.class, dto.id);
            u.nom = dto.nom;
            u.prenom = dto.prenom;
            u.email = dto.email;
            u.dateModification = DateUtils.getDate();
            u.numTel1 = dto.numTel1;
            u.numTel2 = dto.numTel2;
            u.libAdr1 = dto.libAdr1;
            u.codePostal = dto.codePostal;
            u.ville = dto.ville;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbWrite
    public void updateEtat(EtatUtilisateur newValue, Long id) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            Utilisateur u = em.find(Utilisateur.class, id);
            u.etatUtilisateur = newValue;
            u.dateModification = DateUtils.getDate();
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbWrite
    public UtilisateurInfo createNewUser(UtilisateurDTO utilisateurDTO, boolean generatePassword, boolean sendMail) {
        try {
            UtilisateurInfo utilisateurInfo;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            String nom = utilisateurDTO.nom.trim();
            String prenom = utilisateurDTO.prenom.trim();
            String email = utilisateurDTO.email.trim().toLowerCase();
            Utilisateur u = new Utilisateur();
            u.nom = nom;
            u.prenom = prenom;
            u.email = email;
            u.dateCreation = DateUtils.getDate();
            u.numTel1 = utilisateurDTO.numTel1;
            u.numTel2 = utilisateurDTO.numTel2;
            u.libAdr1 = utilisateurDTO.libAdr1;
            u.codePostal = utilisateurDTO.codePostal;
            u.ville = utilisateurDTO.ville;
            em.persist(u);
            UtilisateurInfo res = new UtilisateurInfo();
            res.id = u.getId();
            if (!generatePassword) {
                utilisateurInfo = res;
            } else {
                String clearPassword = RandomUtils.generatePasswordMaj(8);
                new PasswordManager().setUserPassword(u.getId(), clearPassword);
                if (sendMail) {
                    ParametresDTO param = new ParametresService().getParametres();
                    String link = String.valueOf(param.getUrl()) + "?username=" + u.email;
                    StringBuffer buf = new StringBuffer();
                    buf.append("<h2>" + param.nomAmap + "</h2>");
                    buf.append("<br/>");
                    buf.append("Bonjour , voici vos identifiants pour vous connecter \u00e0 l'application WEB de :" + param.nomAmap);
                    buf.append("<br/>");
                    buf.append("<br/>");
                    buf.append("Adresse e mail : " + email);
                    buf.append("<br/>");
                    buf.append("<br/>");
                    buf.append("Mot de passe : " + clearPassword);
                    buf.append("<br/>");
                    buf.append("<br/>");
                    buf.append("<a href=\"" + link + "\">Cliquez ici pour acc\u00e9der \u00e0 l'application</a>");
                    buf.append("<br/>");
                    buf.append("<br/>");
                    buf.append("Merci de conserver ce lien pour pouvoir vous reconnecter plus tard.");
                    buf.append("<br/>");
                    buf.append("Si vous souhaitez changer votre mot de passe, vous pourrez le faire en vous connectant dans l'application, puis en allant dans le menu \"Mon Compte\"");
                    buf.append("<br/>");
                    buf.append("<br/>");
                    new MailerService().sendHtmlMail(new MailerMessage(email, "Bienvenue \u00e0 " + param.nomAmap, buf.toString()));
                    utilisateurInfo = res;
                } else {
                    res.password = clearPassword;
                    utilisateurInfo = res;
                }
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return utilisateurInfo;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbWrite
    public void deleteUtilisateur(Long id) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            Utilisateur u = em.find(Utilisateur.class, id);
            int r = this.countContrat(u, em);
            if (r > 0) {
                throw new UnableToSuppressException("Cet utilisateur poss\u00e9de " + r + " contrats.");
            }
            List<PeriodeCotisationUtilisateurDTO> ps = new GestionCotisationService().getPeriodeCotisation(id);
            if (ps.size() > 0) {
                throw new UnableToSuppressException("Cet utilisateur est indiqu\u00e9 comme cotisant sur les p\u00e9riodes de cotisation suivantes :" + CollectionUtils.asStdString(ps, e -> e.periodeNom));
            }
            List<RoleList> rs = new AccessManagementService().getUserRole(u, em);
            this.checkRole(rs, RoleList.ADMIN);
            this.checkRole(rs, RoleList.TRESORIER);
            this.checkRole(rs, RoleList.PRODUCTEUR);
            this.checkRole(rs, RoleList.REFERENT);
            new DeleteNotificationService().deleteAllNotificationDoneUtilisateur(em, u);
            new PeriodePermanenceService().deleteUtilisateur(em, u);
            em.remove(u);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    private void checkRole(List<RoleList> rls, RoleList rl) {
        if (rls.contains((Object)rl)) {
            throw new UnableToSuppressException("Cet utilisateur est " + (Object)((Object)rl) + ". Enlevez lui ce r\u00f4le avant de le supprimer.");
        }
    }

    private int countContrat(Utilisateur u, RdbLink em) {
        Query q = em.createQuery("select count(c) from Contrat c WHERE c.utilisateur=:u");
        q.setParameter("u", (Object)u);
        return LongUtils.toInt(q.getSingleResult());
    }

    @DbRead
    public int countContrat(Long idUtilisateur) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Utilisateur u = em.find(Utilisateur.class, idUtilisateur);
            int n = this.countContrat(u, em);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return n;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public List<Utilisateur> getUtilisateurs(EtatUtilisateur etat) {
        try {
            List us;
            Query q;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            if (etat == null) {
                q = em.createQuery("select u from Utilisateur u order by u.nom,u.prenom");
            } else {
                q = em.createQuery("select u from Utilisateur u where u.etatUtilisateur=:etat order by u.nom,u.prenom");
                q.setParameter("etat", (Object)etat);
            }
            List list = us = q.getResultList();
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return list;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbWrite
    public void insertAllUtilisateurs(List<UtilisateurDTO> utilisateurs) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            for (UtilisateurDTO utilisateurDTO : utilisateurs) {
                this.createNewUser(utilisateurDTO, false, false);
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbRead
    public EnvoiMailDTO getEnvoiMailDTO() {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            EnvoiMailDTO dto = new EnvoiMailDTO();
            dto.utilisateurs = new ArrayList<EnvoiMailUtilisateurDTO>();
            Query q = em.createQuery("select u from Utilisateur u where u.etatUtilisateur=:etat and u.password is null order by u.nom,u.prenom");
            q.setParameter("etat", (Object)EtatUtilisateur.ACTIF);
            List us = q.getResultList();
            for (Utilisateur u : us) {
                if (!UtilisateurUtil.canSendMailTo(u)) continue;
                EnvoiMailUtilisateurDTO emu = new EnvoiMailUtilisateurDTO();
                emu.idUtilisateur = u.getId();
                emu.sendMail = true;
                dto.utilisateurs.add(emu);
            }
            EnvoiMailDTO envoiMailDTO = dto;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return envoiMailDTO;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    public StatusEnvoiMailDTO envoiEmailBienvenue(EnvoiMailDTO envoiMail) {
        StatusEnvoiMailDTO ret = new StatusEnvoiMailDTO();
        for (EnvoiMailUtilisateurDTO dto : envoiMail.utilisateurs) {
            if (!dto.sendMail) continue;
            String email = this.getEmail(dto.idUtilisateur);
            String clearPassword = RandomUtils.generatePasswordMaj(8);
            try {
                this.sendEmail(email, envoiMail.texteMail, clearPassword);
                new PasswordManager().setUserPassword(dto.idUtilisateur, clearPassword);
                ++ret.nbMailOK;
            }
            catch (Exception e) {
                String msg = "Impossible d'envoyer un e mail \u00e0 " + email + " car :" + e.getMessage();
                ret.erreurs.add(msg);
            }
        }
        return ret;
    }

    @DbRead
    private String getEmail(Long idUtilisateur) {
        try {
            String email;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Utilisateur utilisateur = em.find(Utilisateur.class, idUtilisateur);
            String string = email = utilisateur.email;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return string;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private void sendEmail(String email, String texte, String clearPassword) {
        ParametresDTO param = new ParametresService().getParametres();
        String subject = String.valueOf(param.nomAmap) + " - Bienvenue";
        String htmlContent = texte;
        htmlContent = htmlContent.replaceAll("\r\n", "<br/>");
        htmlContent = htmlContent.replaceAll("\n\r", "<br/>");
        htmlContent = htmlContent.replaceAll("\n", "<br/>");
        htmlContent = htmlContent.replaceAll("\r", "<br/>");
        String link = String.valueOf(param.getUrl()) + "?username=" + email;
        htmlContent = htmlContent.replaceAll("#LINK#", link);
        htmlContent = htmlContent.replaceAll("#PASSWORD#", clearPassword);
        htmlContent = htmlContent.replaceAll("#EMAIL#", email);
        MailerMessage message = new MailerMessage();
        message.setEmail(email);
        message.setTitle(subject);
        message.setContent(htmlContent);
        new MailerService().sendHtmlMail(message);
    }

    @DbRead
    public String prettyString(Long idUtilisateur) {
        try {
            String string;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            if (idUtilisateur == null) {
                string = "";
            } else {
                Utilisateur p = em.find(Utilisateur.class, idUtilisateur);
                string = String.valueOf(p.nom) + " " + p.prenom;
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return string;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    public static class UtilisateurInfo {
        public String password;
        public Long id;
    }
}

